/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.nx.codec.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.nx.codec.match.AbstractMatchCodec;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntryDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntrySerializerKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Nxm1Class;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmClassBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmNxNsi;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.nx.match.nsi.grouping.NsiValuesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.NsiCaseValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.NsiCaseValueBuilder;

public class NsiCodec
extends AbstractMatchCodec {
    private static final int VALUE_LENGTH = 1;
    private static final int NXM_FIELD_CODE = 38;
    public static final MatchEntrySerializerKey<Nxm1Class, NxmNxNsi> SERIALIZER_KEY = new MatchEntrySerializerKey(4, Nxm1Class.class, NxmNxNsi.class);
    public static final MatchEntryDeserializerKey DESERIALIZER_KEY = new MatchEntryDeserializerKey(4, 1, 38);

    public void serialize(MatchEntry input, ByteBuf outBuffer) {
        this.serializeHeader(input, outBuffer);
        NsiCaseValue nsiCaseValue = (NsiCaseValue)input.getMatchEntryValue();
        outBuffer.writeByte((int)nsiCaseValue.getNsiValues().getNsi().shortValue());
    }

    public MatchEntry deserialize(ByteBuf message) {
        MatchEntryBuilder matchEntriesBuilder = this.deserializeHeader(message);
        NsiCaseValueBuilder nsiCaseValueBuilder = new NsiCaseValueBuilder();
        nsiCaseValueBuilder.setNsiValues(new NsiValuesBuilder().setNsi(message.readUnsignedByte()).build());
        matchEntriesBuilder.setMatchEntryValue((MatchEntryValue)nsiCaseValueBuilder.build());
        matchEntriesBuilder.setHasMask(Boolean.valueOf(false));
        return matchEntriesBuilder.build();
    }

    @Override
    public int getNxmFieldCode() {
        return 38;
    }

    @Override
    public int getOxmClassCode() {
        return 1;
    }

    @Override
    public int getValueLength() {
        return 1;
    }

    @Override
    public Class<? extends MatchField> getNxmField() {
        return NxmNxNsi.class;
    }

    @Override
    public Class<? extends OxmClassBase> getOxmClass() {
        return Nxm1Class.class;
    }
}

