/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.nx.codec.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.nx.codec.match.AbstractMatchCodec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Nxm1Class;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmClassBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.nx.match.reg.grouping.RegValuesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.RegCaseValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.RegCaseValueBuilder;

public abstract class AbstractRegCodec
extends AbstractMatchCodec {
    private static final int VALUE_LENGTH = 4;

    public MatchEntry deserialize(ByteBuf message) {
        MatchEntryBuilder matchEntriesBuilder = this.deserializeHeader(message);
        RegCaseValueBuilder caseBuilder = new RegCaseValueBuilder();
        caseBuilder.setRegValues(new RegValuesBuilder().setValue(message.readUnsignedInt()).build());
        matchEntriesBuilder.setMatchEntryValue((MatchEntryValue)caseBuilder.build());
        return matchEntriesBuilder.build();
    }

    public void serialize(MatchEntry input, ByteBuf outBuffer) {
        this.serializeHeader(input, outBuffer);
        RegCaseValue regCase = (RegCaseValue)input.getMatchEntryValue();
        Long value = regCase.getRegValues().getValue();
        outBuffer.writeInt(value.intValue());
    }

    @Override
    public int getOxmClassCode() {
        return 1;
    }

    @Override
    public int getValueLength() {
        return 4;
    }

    @Override
    public Class<? extends OxmClassBase> getOxmClass() {
        return Nxm1Class.class;
    }
}

