/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.nx.codec.action;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.nx.api.NiciraActionDeserializerKey;
import org.opendaylight.openflowjava.nx.api.NiciraActionSerializerKey;
import org.opendaylight.openflowjava.nx.codec.action.AbstractActionCodec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionSetNsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionSetNspBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.set.nsp.grouping.NxActionSetNspBuilder;

public class SetNspCodec
extends AbstractActionCodec {
    public static final int LENGTH = 16;
    public static final byte NXAST_SET_NSP_SUBTYPE = 32;
    public static final NiciraActionSerializerKey SERIALIZER_KEY = new NiciraActionSerializerKey(4, ActionSetNsp.class);
    public static final NiciraActionDeserializerKey DESERIALIZER_KEY = new NiciraActionDeserializerKey(4, 32);
    private static final int padding = 2;

    public void serialize(Action input, ByteBuf outBuffer) {
        ActionSetNsp action = (ActionSetNsp)input.getActionChoice();
        SetNspCodec.serializeHeader(16, 32, outBuffer);
        outBuffer.writeZero(2);
        outBuffer.writeInt(action.getNxActionSetNsp().getNsp().intValue());
    }

    public Action deserialize(ByteBuf message) {
        ActionBuilder actionBuilder = SetNspCodec.deserializeHeader(message);
        ActionSetNspBuilder builder = new ActionSetNspBuilder();
        NxActionSetNspBuilder nxActionSetNspBuilder = new NxActionSetNspBuilder();
        message.skipBytes(2);
        nxActionSetNspBuilder.setNsp(message.readUnsignedInt());
        builder.setNxActionSetNsp(nxActionSetNspBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)builder.build());
        return actionBuilder.build();
    }
}

