/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.nx.codec.action;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.nx.api.NiciraActionDeserializerKey;
import org.opendaylight.openflowjava.nx.api.NiciraActionSerializerKey;
import org.opendaylight.openflowjava.nx.codec.action.AbstractActionCodec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionSetNsi;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionSetNsiBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.set.nsi.grouping.NxActionSetNsiBuilder;

public class SetNsiCodec
extends AbstractActionCodec {
    public static final int LENGTH = 16;
    public static final byte NXAST_SET_NSI_SUBTYPE = 33;
    public static final NiciraActionSerializerKey SERIALIZER_KEY = new NiciraActionSerializerKey(4, ActionSetNsi.class);
    public static final NiciraActionDeserializerKey DESERIALIZER_KEY = new NiciraActionDeserializerKey(4, 33);
    private static final int padding = 5;

    public void serialize(Action input, ByteBuf outBuffer) {
        ActionSetNsi action = (ActionSetNsi)input.getActionChoice();
        SetNsiCodec.serializeHeader(16, 33, outBuffer);
        outBuffer.writeByte((int)action.getNxActionSetNsi().getNsi().byteValue());
        outBuffer.writeZero(5);
    }

    public Action deserialize(ByteBuf message) {
        ActionBuilder actionBuilder = SetNsiCodec.deserializeHeader(message);
        ActionSetNsiBuilder builder = new ActionSetNsiBuilder();
        NxActionSetNsiBuilder nxActionSetNsiBuilder = new NxActionSetNsiBuilder();
        nxActionSetNsiBuilder.setNsi(message.readUnsignedByte());
        message.skipBytes(5);
        builder.setNxActionSetNsi(nxActionSetNsiBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)builder.build());
        return actionBuilder.build();
    }
}

