/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.nx.codec.action;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.nx.api.NiciraActionDeserializerKey;
import org.opendaylight.openflowjava.nx.api.NiciraActionSerializerKey;
import org.opendaylight.openflowjava.nx.codec.action.AbstractActionCodec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionSetNshc1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionSetNshc1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.set.nshc._1.grouping.NxActionSetNshc1Builder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetNshc1Codec
extends AbstractActionCodec {
    private static final Logger LOG = LoggerFactory.getLogger(SetNshc1Codec.class);
    public static final int LENGTH = 16;
    public static final byte NXAST_SET_NSC_SUBTYPE = 34;
    public static final NiciraActionSerializerKey SERIALIZER_KEY = new NiciraActionSerializerKey(4, ActionSetNshc1.class);
    public static final NiciraActionDeserializerKey DESERIALIZER_KEY = new NiciraActionDeserializerKey(4, 34);
    private static final int padding = 2;

    public void serialize(Action input, ByteBuf outBuffer) {
        ActionSetNshc1 action = (ActionSetNshc1)input.getActionChoice();
        SetNshc1Codec.serializeHeader(16, 34, outBuffer);
        outBuffer.writeZero(2);
        outBuffer.writeInt(action.getNxActionSetNshc1().getNshc().intValue());
    }

    public Action deserialize(ByteBuf message) {
        ActionBuilder actionBuilder = SetNshc1Codec.deserializeHeader(message);
        ActionSetNshc1Builder builder = new ActionSetNshc1Builder();
        NxActionSetNshc1Builder nxActionSetNspBuilder = new NxActionSetNshc1Builder();
        message.skipBytes(2);
        nxActionSetNspBuilder.setNshc(message.readUnsignedInt());
        builder.setNxActionSetNshc1(nxActionSetNspBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)builder.build());
        return actionBuilder.build();
    }
}

