/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.learningswitch.multi;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.openflowplugin.learningswitch.FlowCommitWrapper;
import org.opendaylight.openflowplugin.learningswitch.InstanceIdentifierUtils;
import org.opendaylight.openflowplugin.learningswitch.LearningSwitchHandler;
import org.opendaylight.openflowplugin.learningswitch.LearningSwitchHandlerSimpleImpl;
import org.opendaylight.openflowplugin.learningswitch.multi.PacketInDispatcherImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.Table;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.TransmitPacket;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleLearningSwitchHandlerFacadeImpl
implements LearningSwitchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MultipleLearningSwitchHandlerFacadeImpl.class);
    private final @NonNull FlowCommitWrapper dataStoreAccessor;
    private final @NonNull TransmitPacket transmitPacket;
    private final PacketInDispatcherImpl packetInDispatcher;

    public MultipleLearningSwitchHandlerFacadeImpl(@NonNull FlowCommitWrapper dataStoreAccessor, @NonNull TransmitPacket transmitPacket, @NonNull PacketInDispatcherImpl packetInDispatcher) {
        this.dataStoreAccessor = Objects.requireNonNull(dataStoreAccessor);
        this.transmitPacket = Objects.requireNonNull(transmitPacket);
        this.packetInDispatcher = Objects.requireNonNull(packetInDispatcher);
    }

    @Override
    public synchronized void onSwitchAppeared(InstanceIdentifier<Table> appearedTablePath) {
        LOG.debug("expected table acquired, learning ..");
        InstanceIdentifier<Node> nodePath = InstanceIdentifierUtils.getNodePath(appearedTablePath);
        if (!this.packetInDispatcher.getHandlerMapping().containsKey(nodePath)) {
            LearningSwitchHandlerSimpleImpl simpleLearningSwitch = new LearningSwitchHandlerSimpleImpl(this.dataStoreAccessor, this.transmitPacket, null);
            simpleLearningSwitch.onSwitchAppeared(appearedTablePath);
            this.packetInDispatcher.getHandlerMapping().put(nodePath, simpleLearningSwitch);
        }
    }
}

