/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.learningswitch;

import java.util.List;
import java.util.Objects;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.openflowplugin.learningswitch.LearningSwitchHandler;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.Table;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WakeupOnNode
implements DataTreeChangeListener<Table> {
    private static final Logger LOG = LoggerFactory.getLogger(WakeupOnNode.class);
    private final LearningSwitchHandler learningSwitchHandler;

    public WakeupOnNode(LearningSwitchHandler learningSwitchHandler) {
        this.learningSwitchHandler = Objects.requireNonNull(learningSwitchHandler);
    }

    public void onDataTreeChanged(List<DataTreeModification<Table>> modifications) {
        Uint8 requiredTableId = Uint8.ZERO;
        for (DataTreeModification<Table> modification : modifications) {
            Table table;
            if (modification.getRootNode().modificationType() != DataObjectModification.ModificationType.SUBTREE_MODIFIED || (table = (Table)modification.getRootNode().dataAfter()) == null) continue;
            LOG.trace("table: {}", (Object)table);
            if (!requiredTableId.equals(table.getId())) continue;
            this.learningSwitchHandler.onSwitchAppeared((InstanceIdentifier<Table>)modification.getRootPath().path());
        }
    }
}

