/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.learningswitch;

import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.mdsal.binding.api.RpcService;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.openflowplugin.learningswitch.DataTreeChangeListenerRegistrationHolder;
import org.opendaylight.openflowplugin.learningswitch.FlowCommitWrapperImpl;
import org.opendaylight.openflowplugin.learningswitch.LearningSwitchHandlerSimpleImpl;
import org.opendaylight.openflowplugin.learningswitch.WakeupOnNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.Table;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.PacketReceived;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.TransmitPacket;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LearningSwitchManagerSimpleImpl
implements DataTreeChangeListenerRegistrationHolder,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(LearningSwitchManagerSimpleImpl.class);
    private final Registration dataTreeChangeListenerRegistration;
    private final Registration packetInRegistration;

    public LearningSwitchManagerSimpleImpl(DataBroker dataBroker, NotificationService notificationService, RpcService rpcService) {
        LOG.debug("start() -->");
        FlowCommitWrapperImpl dataStoreAccessor = new FlowCommitWrapperImpl(dataBroker);
        LearningSwitchHandlerSimpleImpl learningSwitchHandler = new LearningSwitchHandlerSimpleImpl(dataStoreAccessor, (TransmitPacket)rpcService.getRpc(TransmitPacket.class), this);
        this.packetInRegistration = notificationService.registerListener(PacketReceived.class, (NotificationService.Listener)learningSwitchHandler);
        this.dataTreeChangeListenerRegistration = dataBroker.registerDataTreeChangeListener(DataTreeIdentifier.of((LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)InstanceIdentifier.create(Nodes.class).child(Node.class).augmentation(FlowCapableNode.class).child(Table.class)), (DataTreeChangeListener)new WakeupOnNode(learningSwitchHandler));
        LOG.debug("start() <--");
    }

    @Override
    public void close() {
        LOG.debug("stop() -->");
        this.packetInRegistration.close();
        this.dataTreeChangeListenerRegistration.close();
        LOG.debug("stop() <--");
    }

    @Override
    public Registration getDataTreeChangeListenerRegistration() {
        return this.dataTreeChangeListenerRegistration;
    }
}

