/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.learningswitch;

import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.Table;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.TableKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.Flow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.FlowKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnectorKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.common.Uint8;

public final class InstanceIdentifierUtils {
    private InstanceIdentifierUtils() {
    }

    public static InstanceIdentifier<Node> createNodePath(NodeId nodeId) {
        return InstanceIdentifier.builder(Nodes.class).child(Node.class, (Key)new NodeKey(nodeId)).build();
    }

    public static InstanceIdentifier<Node> getNodePath(InstanceIdentifier<?> nodeChild) {
        return nodeChild.firstIdentifierOf(Node.class);
    }

    public static InstanceIdentifier<Table> createTablePath(InstanceIdentifier<Node> nodePath, TableKey tableKey) {
        return nodePath.augmentation(FlowCapableNode.class).child(Table.class, (Key)tableKey);
    }

    public static InstanceIdentifier<Flow> createFlowPath(InstanceIdentifier<Table> tablePath, FlowKey flowKey) {
        return tablePath.child(Flow.class, (Key)flowKey);
    }

    public static Uint8 getTableId(InstanceIdentifier<Table> tablePath) {
        return ((TableKey)tablePath.firstKeyOf(Table.class)).getId();
    }

    public static NodeConnectorKey getNodeConnectorKey(InstanceIdentifier<?> nodeConnectorPath) {
        return (NodeConnectorKey)nodeConnectorPath.firstKeyOf(NodeConnector.class);
    }

    public static InstanceIdentifier<NodeConnector> createNodeConnectorPath(InstanceIdentifier<Node> nodeKey, NodeConnectorKey nodeConnectorKey) {
        return nodeKey.child(NodeConnector.class, (Key)nodeConnectorKey);
    }
}

