/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.applications.statistics.manager.impl.helper;

import org.opendaylight.openflowplugin.applications.statistics.manager.impl.helper.MatchComparatorHelper;
import org.opendaylight.openflowplugin.applications.statistics.manager.impl.helper.SimpleComparator;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.Match;

public final class MatchComparatorFactory {
    private MatchComparatorFactory() {
    }

    public static SimpleComparator<Match> createNull() {
        return new SimpleComparator<Match>(){

            @Override
            public boolean areObjectsEqual(Match statsMatch, Match storedMatch) {
                return statsMatch == null == (storedMatch == null);
            }
        };
    }

    public static SimpleComparator<Match> createVlan() {
        return new SimpleComparator<Match>(){

            @Override
            public boolean areObjectsEqual(Match statsMatch, Match storedMatch) {
                if (storedMatch == null) {
                    return false;
                }
                return !(storedMatch.getVlanMatch() == null ? statsMatch.getVlanMatch() != null : !storedMatch.getVlanMatch().equals(statsMatch.getVlanMatch()));
            }
        };
    }

    public static SimpleComparator<Match> createTunnel() {
        return new SimpleComparator<Match>(){

            @Override
            public boolean areObjectsEqual(Match statsMatch, Match storedMatch) {
                if (storedMatch == null) {
                    return false;
                }
                return !(storedMatch.getTunnel() == null ? statsMatch.getTunnel() != null : !storedMatch.getTunnel().equals(statsMatch.getTunnel()));
            }
        };
    }

    public static SimpleComparator<Match> createProtocolMatchFields() {
        return new SimpleComparator<Match>(){

            @Override
            public boolean areObjectsEqual(Match statsMatch, Match storedMatch) {
                if (storedMatch == null) {
                    return false;
                }
                return !(storedMatch.getProtocolMatchFields() == null ? statsMatch.getProtocolMatchFields() != null : !storedMatch.getProtocolMatchFields().equals(statsMatch.getProtocolMatchFields()));
            }
        };
    }

    public static SimpleComparator<Match> createMetadata() {
        return new SimpleComparator<Match>(){

            @Override
            public boolean areObjectsEqual(Match statsMatch, Match storedMatch) {
                if (storedMatch == null) {
                    return false;
                }
                return !(storedMatch.getMetadata() == null ? statsMatch.getMetadata() != null : !storedMatch.getMetadata().equals(statsMatch.getMetadata()));
            }
        };
    }

    public static SimpleComparator<Match> createL4() {
        return new SimpleComparator<Match>(){

            @Override
            public boolean areObjectsEqual(Match statsMatch, Match storedMatch) {
                if (storedMatch == null) {
                    return false;
                }
                return !(storedMatch.getLayer4Match() == null ? statsMatch.getLayer4Match() != null : !storedMatch.getLayer4Match().equals(statsMatch.getLayer4Match()));
            }
        };
    }

    public static SimpleComparator<Match> createL3() {
        return new SimpleComparator<Match>(){

            @Override
            public boolean areObjectsEqual(Match statsMatch, Match storedMatch) {
                if (storedMatch == null) {
                    return false;
                }
                return !(storedMatch.getLayer3Match() == null ? statsMatch.getLayer3Match() != null : !MatchComparatorHelper.layer3MatchEquals(statsMatch.getLayer3Match(), storedMatch.getLayer3Match()));
            }
        };
    }

    public static SimpleComparator<Match> createIp() {
        return new SimpleComparator<Match>(){

            @Override
            public boolean areObjectsEqual(Match statsMatch, Match storedMatch) {
                if (storedMatch == null) {
                    return false;
                }
                return !(storedMatch.getIpMatch() == null ? statsMatch.getIpMatch() != null : !storedMatch.getIpMatch().equals(statsMatch.getIpMatch()));
            }
        };
    }

    public static SimpleComparator<Match> createInPort() {
        return new SimpleComparator<Match>(){

            @Override
            public boolean areObjectsEqual(Match statsMatch, Match storedMatch) {
                if (storedMatch == null) {
                    return false;
                }
                return !(storedMatch.getInPort() == null ? statsMatch.getInPort() != null : !storedMatch.getInPort().equals((Object)statsMatch.getInPort()));
            }
        };
    }

    public static SimpleComparator<Match> createInPhyPort() {
        return new SimpleComparator<Match>(){

            @Override
            public boolean areObjectsEqual(Match statsMatch, Match storedMatch) {
                if (storedMatch == null) {
                    return false;
                }
                return !(storedMatch.getInPhyPort() == null ? statsMatch.getInPhyPort() != null : !storedMatch.getInPhyPort().equals((Object)statsMatch.getInPhyPort()));
            }
        };
    }

    public static SimpleComparator<Match> createEthernet() {
        return new SimpleComparator<Match>(){

            @Override
            public boolean areObjectsEqual(Match statsMatch, Match storedMatch) {
                if (storedMatch == null) {
                    return false;
                }
                return !(storedMatch.getEthernetMatch() == null ? statsMatch.getEthernetMatch() != null : !MatchComparatorHelper.ethernetMatchEquals(statsMatch.getEthernetMatch(), storedMatch.getEthernetMatch()));
            }
        };
    }

    public static SimpleComparator<Match> createIcmpv4() {
        return new SimpleComparator<Match>(){

            @Override
            public boolean areObjectsEqual(Match statsMatch, Match storedMatch) {
                if (storedMatch == null) {
                    return false;
                }
                return !(storedMatch.getIcmpv4Match() == null ? statsMatch.getIcmpv4Match() != null : !storedMatch.getIcmpv4Match().equals(statsMatch.getIcmpv4Match()));
            }
        };
    }
}

