/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.applications.statistics.manager.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataChangeListener;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataBroker;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeEvent;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatNodeRegistration;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatPermCollector;
import org.opendaylight.openflowplugin.applications.statistics.manager.StatisticsManager;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNodeUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityFlowStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityGroupStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityPortStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityQueueStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowFeatureCapabilityTableStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.flow.node.SwitchFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatNodeRegistrationImpl
implements StatNodeRegistration,
DataChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(StatNodeRegistrationImpl.class);
    private final StatisticsManager manager;
    private ListenerRegistration<DataChangeListener> listenerRegistration;
    private ListenerRegistration<?> notifListenerRegistration;

    public StatNodeRegistrationImpl(StatisticsManager manager, DataBroker db, NotificationProviderService notificationService) {
        this.manager = (StatisticsManager)Preconditions.checkNotNull((Object)manager, (Object)"StatisticManager can not be null!");
        Preconditions.checkArgument((db != null ? 1 : 0) != 0, (Object)"DataBroker can not be null!");
        Preconditions.checkArgument((notificationService != null ? 1 : 0) != 0, (Object)"NotificationProviderService can not be null!");
        this.notifListenerRegistration = notificationService.registerNotificationListener((NotificationListener)this);
        InstanceIdentifier flowNodeWildCardIdentifier = InstanceIdentifier.create(Nodes.class).child(Node.class).augmentation(FlowCapableNode.class);
        this.listenerRegistration = db.registerDataChangeListener(LogicalDatastoreType.OPERATIONAL, flowNodeWildCardIdentifier, (DataChangeListener)this, AsyncDataBroker.DataChangeScope.BASE);
    }

    @Override
    public void close() throws Exception {
        if (this.notifListenerRegistration != null) {
            try {
                this.notifListenerRegistration.close();
            }
            catch (Exception e) {
                LOG.warn("Error by stop FlowCapableNode Notification StatNodeRegistration. Exception {}", (Throwable)e);
            }
            this.notifListenerRegistration = null;
        }
        if (this.listenerRegistration != null) {
            try {
                this.listenerRegistration.close();
            }
            catch (Exception e) {
                LOG.warn("Error by stop FlowCapableNode DataChange StatListeningCommiter.", (Throwable)e);
            }
            this.listenerRegistration = null;
        }
    }

    @Override
    public void connectFlowCapableNode(InstanceIdentifier<SwitchFeatures> keyIdent, SwitchFeatures data, InstanceIdentifier<Node> nodeIdent) {
        Preconditions.checkNotNull(keyIdent, (Object)"InstanceIdentifier can not be null!");
        Preconditions.checkNotNull((Object)data, (String)"SwitchFeatures data for {} can not be null!", (Object[])new Object[]{keyIdent});
        Preconditions.checkArgument((!keyIdent.isWildcarded() ? 1 : 0) != 0, (Object)"InstanceIdentifier is WildCarded!");
        LOG.trace("STAT-MANAGER - connecting flow capable node {}", nodeIdent);
        ArrayList<StatPermCollector.StatCapabTypes> statCapabTypes = new ArrayList<StatPermCollector.StatCapabTypes>();
        Short maxCapTables = Short.valueOf("1");
        List capabilities = data.getCapabilities() != null ? data.getCapabilities() : Collections.emptyList();
        for (Class capability : capabilities) {
            if (FlowFeatureCapabilityTableStats.class.equals((Object)capability)) {
                statCapabTypes.add(StatPermCollector.StatCapabTypes.TABLE_STATS);
                continue;
            }
            if (FlowFeatureCapabilityFlowStats.class.equals((Object)capability)) {
                statCapabTypes.add(StatPermCollector.StatCapabTypes.FLOW_STATS);
                continue;
            }
            if (FlowFeatureCapabilityGroupStats.class.equals((Object)capability)) {
                statCapabTypes.add(StatPermCollector.StatCapabTypes.GROUP_STATS);
                continue;
            }
            if (FlowFeatureCapabilityPortStats.class.equals((Object)capability)) {
                statCapabTypes.add(StatPermCollector.StatCapabTypes.PORT_STATS);
                continue;
            }
            if (!FlowFeatureCapabilityQueueStats.class.equals((Object)capability)) continue;
            statCapabTypes.add(StatPermCollector.StatCapabTypes.QUEUE_STATS);
        }
        maxCapTables = data.getMaxTables();
        Optional maxTables = Optional.of((Object)maxCapTables);
        this.manager.connectedNodeRegistration(nodeIdent, Collections.unmodifiableList(statCapabTypes), (Short)maxTables.get());
    }

    @Override
    public void disconnectFlowCapableNode(InstanceIdentifier<Node> nodeIdent) {
        Preconditions.checkArgument((nodeIdent != null ? 1 : 0) != 0, (Object)"InstanceIdentifier can not be NULL!");
        Preconditions.checkArgument((!nodeIdent.isWildcarded() ? 1 : 0) != 0, (String)"InstanceIdentifier {} is WildCarded!", (Object[])new Object[]{nodeIdent});
        LOG.trace("STAT-MANAGER - disconnect flow capable node {}", nodeIdent);
        this.manager.disconnectedNodeUnregistration(nodeIdent);
    }

    public void onNodeConnectorRemoved(NodeConnectorRemoved notification) {
    }

    public void onNodeConnectorUpdated(NodeConnectorUpdated notification) {
    }

    public void onNodeRemoved(NodeRemoved notification) {
        Preconditions.checkNotNull((Object)notification);
        NodeRef nodeRef = notification.getNodeRef();
        InstanceIdentifier nodeRefIdent = nodeRef.getValue();
        InstanceIdentifier nodeIdent = nodeRefIdent.firstIdentifierOf(Node.class);
        if (nodeIdent != null) {
            LOG.debug("Received onNodeRemoved for node:{} ", (Object)nodeIdent);
            this.disconnectFlowCapableNode((InstanceIdentifier<Node>)nodeIdent);
        }
    }

    public void onNodeUpdated(NodeUpdated notification) {
        Preconditions.checkNotNull((Object)notification);
        FlowCapableNodeUpdated newFlowNode = (FlowCapableNodeUpdated)notification.getAugmentation(FlowCapableNodeUpdated.class);
        if (newFlowNode != null && newFlowNode.getSwitchFeatures() != null) {
            NodeRef nodeRef = notification.getNodeRef();
            InstanceIdentifier nodeRefIdent = nodeRef.getValue();
            InstanceIdentifier nodeIdent = nodeRefIdent.firstIdentifierOf(Node.class);
            InstanceIdentifier swichFeaturesIdent = nodeIdent.augmentation(FlowCapableNode.class).child(SwitchFeatures.class);
            SwitchFeatures switchFeatures = newFlowNode.getSwitchFeatures();
            this.connectFlowCapableNode((InstanceIdentifier<SwitchFeatures>)swichFeaturesIdent, switchFeatures, (InstanceIdentifier<Node>)nodeIdent);
        }
    }

    public void onDataChanged(AsyncDataChangeEvent<InstanceIdentifier<?>, DataObject> changeEvent) {
        Preconditions.checkNotNull(changeEvent, (Object)"Async ChangeEvent can not be null!");
        Set<InstanceIdentifier> createdData = changeEvent.getCreatedData() != null ? changeEvent.getCreatedData().keySet() : Collections.emptySet();
        for (InstanceIdentifier entryKey : createdData) {
            InstanceIdentifier nodeIdent = entryKey.firstIdentifierOf(Node.class);
            if (nodeIdent.isWildcarded()) continue;
            NodeRef nodeRef = new NodeRef(nodeIdent);
            this.manager.getRpcMsgManager().getGroupFeaturesStat(nodeRef);
            this.manager.getRpcMsgManager().getMeterFeaturesStat(nodeRef);
        }
    }
}

