/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.intent.types.rev150122.Uuid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.EthernetService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.service.IspServiceType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetServiceKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class EthernetServiceBuilder
implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService> {
    private String _asn;
    private String _circuitId;
    private List<IspServiceType> _ispServiceType;
    private EthernetServiceKey _key;
    private String _name;
    private Uuid _routerGroupId;
    private Long _serviceSpeed;
    Map<Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService>> augmentation = Collections.emptyMap();

    public EthernetServiceBuilder() {
    }

    public EthernetServiceBuilder(EthernetService arg) {
        this._routerGroupId = arg.getRouterGroupId();
        this._name = arg.getName();
        this._circuitId = arg.getCircuitId();
        this._asn = arg.getAsn();
        this._serviceSpeed = arg.getServiceSpeed();
        this._ispServiceType = arg.getIspServiceType();
    }

    public EthernetServiceBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new EthernetServiceKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._asn = base.getAsn();
        this._circuitId = base.getCircuitId();
        this._ispServiceType = base.getIspServiceType();
        this._routerGroupId = base.getRouterGroupId();
        this._serviceSpeed = base.getServiceSpeed();
        if (base instanceof EthernetServiceImpl) {
            EthernetServiceImpl impl = (EthernetServiceImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof EthernetService) {
            this._routerGroupId = ((EthernetService)arg).getRouterGroupId();
            this._name = ((EthernetService)arg).getName();
            this._circuitId = ((EthernetService)arg).getCircuitId();
            this._asn = ((EthernetService)arg).getAsn();
            this._serviceSpeed = ((EthernetService)arg).getServiceSpeed();
            this._ispServiceType = ((EthernetService)arg).getIspServiceType();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.EthernetService] \nbut was: " + arg);
        }
    }

    public String getAsn() {
        return this._asn;
    }

    public String getCircuitId() {
        return this._circuitId;
    }

    public List<IspServiceType> getIspServiceType() {
        return this._ispServiceType;
    }

    public EthernetServiceKey getKey() {
        return this._key;
    }

    public String getName() {
        return this._name;
    }

    public Uuid getRouterGroupId() {
        return this._routerGroupId;
    }

    public Long getServiceSpeed() {
        return this._serviceSpeed;
    }

    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public EthernetServiceBuilder setAsn(String value) {
        this._asn = value;
        return this;
    }

    public EthernetServiceBuilder setCircuitId(String value) {
        this._circuitId = value;
        return this;
    }

    public EthernetServiceBuilder setIspServiceType(List<IspServiceType> value) {
        this._ispServiceType = value;
        return this;
    }

    public EthernetServiceBuilder setKey(EthernetServiceKey value) {
        this._key = value;
        return this;
    }

    public EthernetServiceBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public EthernetServiceBuilder setRouterGroupId(Uuid value) {
        this._routerGroupId = value;
        return this;
    }

    private static void checkServiceSpeedRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public EthernetServiceBuilder setServiceSpeed(Long value) {
        if (value != null) {
            EthernetServiceBuilder.checkServiceSpeedRange(value);
        }
        this._serviceSpeed = value;
        return this;
    }

    public EthernetServiceBuilder addAugmentation(Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public EthernetServiceBuilder removeAugmentation(Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService build() {
        return new EthernetServiceImpl(this);
    }

    private static final class EthernetServiceImpl
    implements org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService {
        private final String _asn;
        private final String _circuitId;
        private final List<IspServiceType> _ispServiceType;
        private final EthernetServiceKey _key;
        private final String _name;
        private final Uuid _routerGroupId;
        private final Long _serviceSpeed;
        private Map<Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService.class;
        }

        private EthernetServiceImpl(EthernetServiceBuilder base) {
            if (base.getKey() == null) {
                this._key = new EthernetServiceKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._asn = base.getAsn();
            this._circuitId = base.getCircuitId();
            this._ispServiceType = base.getIspServiceType();
            this._routerGroupId = base.getRouterGroupId();
            this._serviceSpeed = base.getServiceSpeed();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService>>(base.augmentation);
                }
            }
        }

        @Override
        public String getAsn() {
            return this._asn;
        }

        @Override
        public String getCircuitId() {
            return this._circuitId;
        }

        @Override
        public List<IspServiceType> getIspServiceType() {
            return this._ispServiceType;
        }

        @Override
        public EthernetServiceKey getKey() {
            return this._key;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Uuid getRouterGroupId() {
            return this._routerGroupId;
        }

        @Override
        public Long getServiceSpeed() {
            return this._serviceSpeed;
        }

        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._asn);
            result = 31 * result + Objects.hashCode(this._circuitId);
            result = 31 * result + Objects.hashCode(this._ispServiceType);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._routerGroupId);
            result = 31 * result + Objects.hashCode(this._serviceSpeed);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService other = (org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService)obj;
            if (!Objects.equals(this._asn, other.getAsn())) {
                return false;
            }
            if (!Objects.equals(this._circuitId, other.getCircuitId())) {
                return false;
            }
            if (!Objects.equals(this._ispServiceType, other.getIspServiceType())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._routerGroupId, other.getRouterGroupId())) {
                return false;
            }
            if (!Objects.equals(this._serviceSpeed, other.getServiceSpeed())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                EthernetServiceImpl otherImpl = (EthernetServiceImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.services.EthernetService>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "EthernetService [";
            StringBuilder builder = new StringBuilder(name);
            if (this._asn != null) {
                builder.append("_asn=");
                builder.append(this._asn);
                builder.append(", ");
            }
            if (this._circuitId != null) {
                builder.append("_circuitId=");
                builder.append(this._circuitId);
                builder.append(", ");
            }
            if (this._ispServiceType != null) {
                builder.append("_ispServiceType=");
                builder.append(this._ispServiceType);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._routerGroupId != null) {
                builder.append("_routerGroupId=");
                builder.append(this._routerGroupId);
                builder.append(", ");
            }
            if (this._serviceSpeed != null) {
                builder.append("_serviceSpeed=");
                builder.append(this._serviceSpeed);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

