/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.service.IspServiceType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.service.IspServiceTypeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.nic.network.mapping.ethernet.service.rev170613.ethernet.service.isp.service.type.EthernetServiceTypes;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class IspServiceTypeBuilder
implements Builder<IspServiceType> {
    private EthernetServiceTypes _ethernetServiceTypes;
    private IspServiceTypeKey _key;
    private Short _order;
    Map<Class<? extends Augmentation<IspServiceType>>, Augmentation<IspServiceType>> augmentation = Collections.emptyMap();

    public IspServiceTypeBuilder() {
    }

    public IspServiceTypeBuilder(IspServiceType base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new IspServiceTypeKey(base.getOrder());
            this._order = base.getOrder();
        } else {
            this._key = base.getKey();
            this._order = this._key.getOrder();
        }
        this._ethernetServiceTypes = base.getEthernetServiceTypes();
        if (base instanceof IspServiceTypeImpl) {
            IspServiceTypeImpl impl = (IspServiceTypeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<IspServiceType>>, Augmentation<IspServiceType>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IspServiceType>>, Augmentation<IspServiceType>>(casted.augmentations());
        }
    }

    public EthernetServiceTypes getEthernetServiceTypes() {
        return this._ethernetServiceTypes;
    }

    public IspServiceTypeKey getKey() {
        return this._key;
    }

    public Short getOrder() {
        return this._order;
    }

    public <E extends Augmentation<IspServiceType>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public IspServiceTypeBuilder setEthernetServiceTypes(EthernetServiceTypes value) {
        this._ethernetServiceTypes = value;
        return this;
    }

    public IspServiceTypeBuilder setKey(IspServiceTypeKey value) {
        this._key = value;
        return this;
    }

    private static void checkOrderRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public IspServiceTypeBuilder setOrder(Short value) {
        if (value != null) {
            IspServiceTypeBuilder.checkOrderRange(value);
        }
        this._order = value;
        return this;
    }

    public IspServiceTypeBuilder addAugmentation(Class<? extends Augmentation<IspServiceType>> augmentationType, Augmentation<IspServiceType> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IspServiceType>>, Augmentation<IspServiceType>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public IspServiceTypeBuilder removeAugmentation(Class<? extends Augmentation<IspServiceType>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public IspServiceType build() {
        return new IspServiceTypeImpl(this);
    }

    private static final class IspServiceTypeImpl
    implements IspServiceType {
        private final EthernetServiceTypes _ethernetServiceTypes;
        private final IspServiceTypeKey _key;
        private final Short _order;
        private Map<Class<? extends Augmentation<IspServiceType>>, Augmentation<IspServiceType>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<IspServiceType> getImplementedInterface() {
            return IspServiceType.class;
        }

        private IspServiceTypeImpl(IspServiceTypeBuilder base) {
            if (base.getKey() == null) {
                this._key = new IspServiceTypeKey(base.getOrder());
                this._order = base.getOrder();
            } else {
                this._key = base.getKey();
                this._order = this._key.getOrder();
            }
            this._ethernetServiceTypes = base.getEthernetServiceTypes();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<IspServiceType>>, Augmentation<IspServiceType>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<IspServiceType>>, Augmentation<IspServiceType>>(base.augmentation);
                }
            }
        }

        @Override
        public EthernetServiceTypes getEthernetServiceTypes() {
            return this._ethernetServiceTypes;
        }

        @Override
        public IspServiceTypeKey getKey() {
            return this._key;
        }

        @Override
        public Short getOrder() {
            return this._order;
        }

        public <E extends Augmentation<IspServiceType>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ethernetServiceTypes);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._order);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!IspServiceType.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            IspServiceType other = (IspServiceType)obj;
            if (!Objects.equals(this._ethernetServiceTypes, other.getEthernetServiceTypes())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._order, other.getOrder())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                IspServiceTypeImpl otherImpl = (IspServiceTypeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<IspServiceType>>, Augmentation<IspServiceType>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "IspServiceType [";
            StringBuilder builder = new StringBuilder(name);
            if (this._ethernetServiceTypes != null) {
                builder.append("_ethernetServiceTypes=");
                builder.append(this._ethernetServiceTypes);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._order != null) {
                builder.append("_order=");
                builder.append(this._order);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

