/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.nic.constraints;

import org.opendaylight.nic.mapped.MappedObject;

public class ClassifierConstraint
extends MappedObject {
    public static final String PORT_MIN = "portMin";
    public static final String PORT_MAX = "portMax";
    public static final String PROTOCOL = "protocol";
    public static String TYPE = "ClassifierConstraint";

    public void setPortMax(Integer portMax) {
        this.properties.put(PORT_MAX, portMax.toString());
    }

    public void setProtocol(String protocol) {
        this.properties.put(PROTOCOL, protocol);
    }

    public void setPortMin(Integer portMin) {
        this.properties.put(PORT_MAX, portMin.toString());
    }

    public ClassifierConstraint(Integer portMin, Integer portMax, String protocol) {
        this.setPortMin(portMin);
        this.setPortMax(portMax);
        this.setProtocol(protocol);
        this.type = TYPE;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String key() {
        StringBuilder key = new StringBuilder();
        key.append(this.getProtocol().toUpperCase());
        key.append("/");
        if (this.getPortMax().equals(this.getPortMin())) {
            key.append(this.getPortMax());
        } else {
            key.append(this.getPortMin());
            key.append("-");
            key.append(this.getPortMax());
        }
        return key.toString();
    }

    public Pair<Integer, Integer> intersection(ClassifierConstraint other) {
        Pair<Integer, Integer> rangeMax;
        if (other == null) {
            return null;
        }
        if (!this.getProtocol().equals(other.getProtocol())) {
            return null;
        }
        Pair<Integer, Integer> range = new Pair<Integer, Integer>(this.getPortMin(), this.getPortMax());
        Pair<Integer, Integer> otherRange = new Pair<Integer, Integer>(other.getPortMin(), other.getPortMax());
        Pair<Integer, Integer> intersection = null;
        Pair<Integer, Integer> rangeMin = range.getFirst() < otherRange.getFirst() ? range : otherRange;
        Pair<Integer, Integer> pair = rangeMax = rangeMin.equals(range) ? otherRange : range;
        if (rangeMin.getSecond() < rangeMax.getFirst()) {
            return null;
        }
        intersection = new Pair<Integer, Integer>(rangeMax.getFirst(), rangeMin.getSecond() < rangeMax.getSecond() ? rangeMin.getSecond() : rangeMax.getSecond());
        return intersection;
    }

    public Integer getPortMin() {
        return Integer.parseInt((String)this.properties.get(PORT_MIN));
    }

    public Integer getPortMax() {
        return Integer.parseInt((String)this.properties.get(PORT_MAX));
    }

    public String getProtocol() {
        return (String)this.properties.get(PROTOCOL);
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    public static ClassifierConstraint fromMappedObject(MappedObject obj) {
        ClassifierConstraint constraint = new ClassifierConstraint(Integer.parseInt(obj.getProperty(PORT_MIN)), Integer.parseInt(obj.getProperty(PORT_MAX)), obj.getProperty(PROTOCOL));
        return constraint;
    }

    private class Pair<F, S> {
        private F first;
        private S second;

        public Pair(F first, S second) {
            this.first = first;
            this.second = second;
        }

        public void setFirst(F first) {
            this.first = first;
        }

        public void setSecond(S second) {
            this.second = second;
        }

        public F getFirst() {
            return this.first;
        }

        public S getSecond() {
            return this.second;
        }
    }
}

