/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.nic.compiler;

import com.google.common.collect.Sets;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.opendaylight.nic.compiler.EndpointImpl;
import org.opendaylight.nic.compiler.PolicyImpl;
import org.opendaylight.nic.compiler.api.Action;
import org.opendaylight.nic.compiler.api.Endpoint;
import org.opendaylight.nic.compiler.api.IntentCompiler;
import org.opendaylight.nic.compiler.api.Policy;

public class IntentCompilerImpl
implements IntentCompiler {
    @Override
    public Collection<Policy> compile(Collection<Policy> policies) {
        LinkedList<Policy> conflictingPolicies = new LinkedList<Policy>(policies);
        LinkedList<Policy> compiledPolicies = new LinkedList<Policy>();
        while (!conflictingPolicies.isEmpty()) {
            Policy policy = (Policy)conflictingPolicies.remove();
            Iterator iterator2 = conflictingPolicies.iterator();
            LinkedList<Policy> results = new LinkedList<Policy>();
            while (iterator2.hasNext()) {
                Policy policy2 = (Policy)iterator2.next();
                if (!this.conflicts(policy, policy2)) continue;
                iterator2.remove();
                results.addAll(this.transform(policy, policy2));
            }
            if (results.isEmpty()) {
                compiledPolicies.add(policy);
                continue;
            }
            conflictingPolicies.addAll(results);
        }
        return compiledPolicies;
    }

    @Override
    public Set<Endpoint> parseEndpointGroup(String csv) throws UnknownHostException {
        String[] ipAdresses;
        LinkedHashSet<Endpoint> endpoints = new LinkedHashSet<Endpoint>();
        for (String ipAddress : ipAdresses = csv.split(",")) {
            endpoints.add(new EndpointImpl(InetAddress.getByName(ipAddress)));
        }
        return endpoints;
    }

    @Override
    public Policy createPolicy(Set<Endpoint> source, Set<Endpoint> destination, Action action) {
        return new PolicyImpl(source, destination, action);
    }

    private Collection<Policy> transform(Policy p1, Policy p2) {
        Sets.SetView dst;
        LinkedList<Policy> policies = new LinkedList<Policy>();
        Sets.SetView src = Sets.difference(p1.src(), p2.src());
        if (!src.isEmpty()) {
            dst = Sets.difference(p1.dst(), p2.dst());
            if (!dst.isEmpty()) {
                policies.add(new PolicyImpl((Set<Endpoint>)src, (Set<Endpoint>)dst, p1.action()));
            }
            if (!(dst = Sets.intersection(p1.dst(), p2.dst())).isEmpty()) {
                policies.add(new PolicyImpl((Set<Endpoint>)src, (Set<Endpoint>)dst, p1.action()));
            }
        }
        if (!(src = Sets.intersection(p1.src(), p2.src())).isEmpty()) {
            dst = Sets.intersection(p1.dst(), p2.dst());
            if (!dst.isEmpty()) {
                policies.add(new PolicyImpl((Set<Endpoint>)src, (Set<Endpoint>)dst, this.merge(p1.action(), p2.action())));
            }
            if (!(dst = Sets.difference(p1.dst(), p2.dst())).isEmpty()) {
                policies.add(new PolicyImpl((Set<Endpoint>)src, (Set<Endpoint>)dst, p1.action()));
            }
            if (!(dst = Sets.difference(p2.dst(), p1.dst())).isEmpty()) {
                policies.add(new PolicyImpl((Set<Endpoint>)src, (Set<Endpoint>)dst, p2.action()));
            }
        }
        if (!(src = Sets.difference(p2.src(), p1.src())).isEmpty()) {
            dst = Sets.intersection(p1.dst(), p2.dst());
            if (!dst.isEmpty()) {
                policies.add(new PolicyImpl((Set<Endpoint>)src, (Set<Endpoint>)dst, p2.action()));
            }
            if (!(dst = Sets.difference(p2.dst(), p1.dst())).isEmpty()) {
                policies.add(new PolicyImpl((Set<Endpoint>)src, (Set<Endpoint>)dst, p2.action()));
            }
        }
        return policies;
    }

    private Action merge(Action a1, Action a2) {
        if (Action.BLOCK.equals((Object)a1) || Action.BLOCK.equals((Object)a2)) {
            return Action.BLOCK;
        }
        return Action.ALLOW;
    }

    private boolean conflicts(Policy p1, Policy p2) {
        return !Sets.intersection(p1.src(), p2.src()).isEmpty() && !Sets.intersection(p1.dst(), p2.dst()).isEmpty();
    }
}

