/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netvirt.openstack.netvirt.sfc.workaround.services;

import java.util.ArrayList;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.AccessListsBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.Ipv4Acl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.Acl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.AclBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.AccessListEntriesBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.Ace;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.AceBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.ActionsBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.MatchesBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.actions.PacketHandling;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.actions.packet.handling.PermitBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.matches.AceType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.matches.ace.type.AceIpBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.acl.transport.header.fields.DestinationPortRangeBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.acl.transport.header.fields.SourcePortRangeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netvirt.sfc.acl.rev150105.RedirectToSfc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netvirt.sfc.acl.rev150105.RedirectToSfcBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class AclUtils {
    private static final String ACLNAME = "httpAcl";
    private static final String RULENAME = "httpRule";
    private static final String SFCNAME = "SFC";

    public MatchesBuilder matchesBuilder(MatchesBuilder matchesBuilder, int dstPort) {
        SourcePortRangeBuilder sourcePortRangeBuilder = new SourcePortRangeBuilder().setLowerPort(PortNumber.getDefaultInstance((String)"0")).setUpperPort(PortNumber.getDefaultInstance((String)"0"));
        PortNumber portNumber = new PortNumber(Integer.valueOf(dstPort));
        DestinationPortRangeBuilder destinationPortRangeBuilder = new DestinationPortRangeBuilder().setLowerPort(portNumber).setUpperPort(portNumber);
        AceIpBuilder aceIpBuilder = new AceIpBuilder().setSourcePortRange(sourcePortRangeBuilder.build()).setDestinationPortRange(destinationPortRangeBuilder.build()).setProtocol(Short.valueOf((short)6));
        return matchesBuilder.setAceType((AceType)aceIpBuilder.build());
    }

    public ActionsBuilder actionsBuilder(ActionsBuilder actionsBuilder, Boolean permit) {
        return actionsBuilder.setPacketHandling((PacketHandling)new PermitBuilder().setPermit(permit).build());
    }

    public ActionsBuilder actionsBuilder(ActionsBuilder actionsBuilder, String sfcName, boolean renderRsp) {
        RedirectToSfcBuilder redirectToSfcBuilder = new RedirectToSfcBuilder().setSfcName(sfcName).setRenderRsp(Boolean.valueOf(renderRsp));
        return actionsBuilder.addAugmentation(RedirectToSfc.class, (Augmentation)redirectToSfcBuilder.build());
    }

    public AceBuilder aceBuilder(AceBuilder accessListEntryBuilder, String ruleName, MatchesBuilder matchesBuilder, ActionsBuilder actionsBuilder) {
        return accessListEntryBuilder.setRuleName(ruleName).setMatches(matchesBuilder.build()).setActions(actionsBuilder.build());
    }

    public AccessListEntriesBuilder accessListEntriesBuidler(AccessListEntriesBuilder accessListEntriesBuilder, AceBuilder aceBuilder) {
        ArrayList<Ace> aceList = new ArrayList<Ace>();
        aceList.add(aceBuilder.build());
        return accessListEntriesBuilder.setAce(aceList);
    }

    public AclBuilder aclBuilder(AclBuilder aclBuilder, String aclName, AccessListEntriesBuilder accessListEntriesBuilder) {
        return aclBuilder.setAclName(aclName).setAclType(Ipv4Acl.class).setAccessListEntries(accessListEntriesBuilder.build());
    }

    public AccessListsBuilder accessListsbuilder(AccessListsBuilder accessListsBuilder, AclBuilder aclBuilder) {
        ArrayList<Acl> aclList = new ArrayList<Acl>();
        aclList.add(aclBuilder.build());
        return accessListsBuilder.setAcl(aclList);
    }

    public AccessListsBuilder accessListsBuilder(boolean renderRsp) {
        String ruleName = RULENAME;
        String sfcName = SFCNAME;
        MatchesBuilder matchesBuilder = this.matchesBuilder(new MatchesBuilder(), 80);
        ActionsBuilder actionsBuilder = this.actionsBuilder(new ActionsBuilder(), sfcName, renderRsp);
        AceBuilder accessListEntryBuilder = this.aceBuilder(new AceBuilder(), ruleName, matchesBuilder, actionsBuilder);
        AccessListEntriesBuilder accessListEntriesBuilder = this.accessListEntriesBuidler(new AccessListEntriesBuilder(), accessListEntryBuilder);
        AclBuilder accessListBuilder = this.aclBuilder(new AclBuilder(), ACLNAME, accessListEntriesBuilder);
        AccessListsBuilder accessListsBuilder = this.accessListsbuilder(new AccessListsBuilder(), accessListBuilder);
        return accessListsBuilder;
    }
}

