/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netvirt.openstack.netvirt.sfc.workaround;

import com.google.common.base.Preconditions;
import java.util.List;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.netvirt.openstack.netvirt.api.NodeCacheManager;
import org.opendaylight.netvirt.openstack.netvirt.api.OvsdbTables;
import org.opendaylight.netvirt.openstack.netvirt.api.Southbound;
import org.opendaylight.netvirt.openstack.netvirt.sfc.INetvirtSfcOF13Provider;
import org.opendaylight.netvirt.openstack.netvirt.sfc.ISfcClassifierService;
import org.opendaylight.netvirt.openstack.netvirt.sfc.NshUtils;
import org.opendaylight.netvirt.openstack.netvirt.sfc.SfcUtils;
import org.opendaylight.netvirt.utils.mdsal.utils.MdsalUtils;
import org.opendaylight.netvirt.utils.servicehelper.ServiceHelper;
import org.opendaylight.sfc.provider.api.SfcProviderRenderedPathAPI;
import org.opendaylight.sfc.provider.api.SfcProviderServiceForwarderAPI;
import org.opendaylight.sfc.provider.api.SfcProviderServiceFunctionAPI;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.RspName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SfName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SffName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.CreateRenderedPathInput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.CreateRenderedPathInputBuilder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.rendered.service.path.first.hop.info.RenderedServicePathFirstHop;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.rendered.service.paths.RenderedServicePath;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.rendered.service.paths.rendered.service.path.RenderedServicePathHop;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sf.rev140701.service.functions.ServiceFunction;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sff.rev140701.service.function.forwarders.ServiceFunctionForwarder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfp.rev140701.service.function.paths.ServiceFunctionPath;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.data.plane.locator.locator.type.Ip;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.Acl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.Ace;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.Matches;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netvirt.sfc.acl.rev150105.RedirectToSfc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netvirt.sfc.classifier.rev150105.classifiers.classifier.Bridges;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netvirt.sfc.classifier.rev150105.classifiers.classifier.bridges.Bridge;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netvirt.sfc.classifier.rev150105.classifiers.classifier.sffs.Sff;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.OvsdbBridgeAugmentation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.OvsdbNodeAugmentation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.OvsdbTerminationPointAugmentation;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.node.TerminationPoint;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetvirtSfcWorkaroundOF13Provider
implements INetvirtSfcOF13Provider {
    private static final Logger LOG = LoggerFactory.getLogger(NetvirtSfcWorkaroundOF13Provider.class);
    private volatile NodeCacheManager nodeCacheManager;
    private volatile Southbound southbound;
    private volatile ISfcClassifierService sfcClassifierService;
    private static final short SFC_TABLE = 150;
    private MdsalUtils mdsalUtils;
    private SfcUtils sfcUtils;
    private DataBroker dataBroker;
    private static final String VXGPE = "vxgpe";
    public static final String TUNNEL_ENDPOINT_KEY = "local_ip";
    private Boolean addSfFlows;

    public NetvirtSfcWorkaroundOF13Provider(DataBroker dataBroker, MdsalUtils mdsalUtils, SfcUtils sfcUtils, Boolean addSfFlows) {
        Preconditions.checkNotNull((Object)dataBroker, (Object)"Input dataBroker cannot be NULL!");
        Preconditions.checkNotNull((Object)mdsalUtils, (Object)"Input mdsalUtils cannot be NULL!");
        Preconditions.checkNotNull((Object)sfcUtils, (Object)"Input sfcUtils cannot be NULL!");
        this.dataBroker = dataBroker;
        this.mdsalUtils = mdsalUtils;
        this.sfcUtils = sfcUtils;
        this.addSfFlows = addSfFlows;
    }

    @Override
    public void setSfcClassifierService(ISfcClassifierService sfcClassifierService) {
        this.sfcClassifierService = sfcClassifierService;
    }

    @Override
    public void addClassifierRules(Bridge bridge, Acl acl) {
    }

    @Override
    public void addClassifierRules(Bridges bridges, Acl acl) {
        Preconditions.checkNotNull((Object)bridges, (Object)"Input bridges cannot be NULL!");
        Preconditions.checkNotNull((Object)acl, (Object)"Input acl cannot be NULL!");
    }

    @Override
    public void removeClassifierRules(Sff sff, Acl acl) {
    }

    @Override
    public void addClassifierRules(Acl acl) {
        for (Ace ace : acl.getAccessListEntries().getAce()) {
            this.processAclEntry(ace);
        }
    }

    @Override
    public void removeClassifierRules(Acl acl) {
        for (Ace ace : acl.getAccessListEntries().getAce()) {
            RenderedServicePath rsp = this.getRenderedServicePath(ace);
            if (rsp == null) {
                LOG.warn("Failed to get renderedServicePatch for entry: {}", (Object)ace);
                return;
            }
            this.sfcClassifierService.clearFlows(this.dataBroker, rsp.getName().getValue());
        }
    }

    @Override
    public void removeRsp(RenderedServicePath change) {
        this.sfcClassifierService.clearFlows(this.dataBroker, change.getName().getValue());
    }

    @Override
    public void addRsp(RenderedServicePath change) {
        this.handleRenderedServicePath(change);
    }

    @Override
    public void updateRsp(RenderedServicePath change) {
        LOG.info("updateRsp not implemented yet");
    }

    private void processAclEntry(Ace entry) {
        Matches matches = entry.getMatches();
        Preconditions.checkNotNull((Object)matches, (Object)"ACL Entry cannot be null!");
        RenderedServicePath rsp = this.getRenderedServicePath(entry);
        if (rsp == null) {
            LOG.warn("Failed to get renderedServicePatch for entry: {}", (Object)entry);
            return;
        }
        this.handleRenderedServicePath(rsp, entry);
    }

    private void handleRenderedServicePath(RenderedServicePath rsp) {
        LOG.info("handleRenderedServicePath: RSP: {}", (Object)rsp);
        Ace entry = this.getAceFromRenderedServicePath(rsp);
        if (entry == null) {
            LOG.warn("handleRenderedServicePath: failed to get acl entry");
            return;
        }
        this.handleRenderedServicePath(rsp, entry);
    }

    private void handleRenderedServicePath(RenderedServicePath rsp, Ace entry) {
        LOG.info("handleRenderedServicePath: RSP: {}, Ace: {}", (Object)rsp, (Object)entry);
        Matches matches = entry.getMatches();
        if (matches == null) {
            LOG.warn("processAclEntry: matches not found");
            return;
        }
        List pathHopList = rsp.getRenderedServicePathHop();
        if (pathHopList.isEmpty()) {
            LOG.warn("handleRenderedServicePath: RSP {} has empty hops!!", (Object)rsp.getName());
            return;
        }
        LOG.info("handleRenderedServicePath: pathHopList: {}", (Object)pathHopList);
        RenderedServicePathFirstHop firstRspHop = SfcProviderRenderedPathAPI.readRenderedServicePathFirstHop((RspName)rsp.getName());
        LOG.info("handleRenderedServicePath: firstRspHop: {}", (Object)firstRspHop);
        RenderedServicePathHop firstHop = (RenderedServicePathHop)pathHopList.get(0);
        RenderedServicePathHop lastHop = (RenderedServicePathHop)pathHopList.get(pathHopList.size() - 1);
        List bridgeNodes = this.nodeCacheManager.getBridgeNodes();
        if (bridgeNodes == null || bridgeNodes.isEmpty()) {
            LOG.warn("handleRenderedServicePath: There are no bridges to process");
            return;
        }
        for (RenderedServicePathHop hop : pathHopList) {
            for (Node bridgeNode : bridgeNodes) {
                OvsdbBridgeAugmentation ovsdbBridgeAugmentation = this.southbound.getBridge(bridgeNode, "br-int");
                if (ovsdbBridgeAugmentation == null) continue;
                long vxGpeOfPort = this.getOFPort(bridgeNode, VXGPE);
                if (vxGpeOfPort == 0L) {
                    LOG.warn("handleRenderedServicePath: Could not identify gpe vtep {} -> OF ({}) on {}", new Object[]{VXGPE, vxGpeOfPort, bridgeNode});
                    continue;
                }
                long dataPathId = this.southbound.getDataPathId(bridgeNode);
                if (dataPathId == 0L) {
                    LOG.warn("handleRenderedServicePath: Could not identify datapathId on {}", (Object)bridgeNode);
                    continue;
                }
                ServiceFunction serviceFunction = SfcProviderServiceFunctionAPI.readServiceFunction((SfName)hop.getServiceFunctionName());
                if (serviceFunction == null) {
                    LOG.warn("handleRenderedServicePath: Could not identify ServiceFunction {} on {}", (Object)hop.getServiceFunctionName().getValue(), (Object)bridgeNode);
                    continue;
                }
                ServiceFunctionForwarder serviceFunctionForwarder = SfcProviderServiceForwarderAPI.readServiceFunctionForwarder((SffName)hop.getServiceFunctionForwarder());
                if (serviceFunctionForwarder == null) {
                    LOG.warn("handleRenderedServicePath: Could not identify ServiceFunctionForwarder {} on {}", (Object)hop.getServiceFunctionName().getValue(), (Object)bridgeNode);
                    continue;
                }
                this.handleSf(bridgeNode, serviceFunction, rsp);
                this.handleSff(bridgeNode, serviceFunctionForwarder, serviceFunction, hop, firstHop, lastHop, entry.getRuleName(), matches, vxGpeOfPort, rsp);
                if (firstHop != lastHop) continue;
                this.handleSff(bridgeNode, serviceFunctionForwarder, serviceFunction, hop, null, lastHop, entry.getRuleName(), matches, vxGpeOfPort, rsp);
            }
        }
    }

    private void handleSff(Node bridgeNode, ServiceFunctionForwarder serviceFunctionForwarder, ServiceFunction serviceFunction, RenderedServicePathHop hop, RenderedServicePathHop firstHop, RenderedServicePathHop lastHop, String ruleName, Matches matches, long vxGpeOfPort, RenderedServicePath rsp) {
        long dataPathId = this.southbound.getDataPathId(bridgeNode);
        if (hop == firstHop) {
            LOG.info("handleSff: first hop processing {} - {}", (Object)bridgeNode.getNodeId().getValue(), (Object)serviceFunctionForwarder.getName().getValue());
            NshUtils nshHeader = new NshUtils();
            nshHeader.setNshNsp(rsp.getPathId());
            nshHeader.setNshNsi(firstHop.getServiceIndex());
            Ip sffIp = this.sfcUtils.getSffIp(lastHop.getServiceFunctionForwarder());
            nshHeader.setNshMetaC1(NshUtils.convertIpAddressToLong(sffIp.getIp().getIpv4Address()));
            if (this.isSffOnBridge(bridgeNode, serviceFunctionForwarder)) {
                LOG.info("handleSff: sff and bridge are the same: {} - {}, skipping first sff", (Object)bridgeNode.getNodeId().getValue(), (Object)serviceFunctionForwarder.getName().getValue());
                Ip ip = this.sfcUtils.getSfIp(serviceFunction);
                nshHeader.setNshTunIpDst(ip.getIp().getIpv4Address());
                nshHeader.setNshTunUdpPort(ip.getPort());
                this.sfcClassifierService.programIngressClassifier(dataPathId, ruleName, matches, rsp.getPathId(), rsp.getStartingIndex(), nshHeader, 0L, rsp.getName().getValue(), true);
            } else {
                LOG.info("handleSff: sff and bridge are not the same: {} - {}, sending to first sff", (Object)bridgeNode.getNodeId().getValue(), (Object)serviceFunctionForwarder.getName().getValue());
                Ip ip = this.sfcUtils.getSffIp(serviceFunctionForwarder);
                nshHeader.setNshTunIpDst(ip.getIp().getIpv4Address());
                nshHeader.setNshTunUdpPort(ip.getPort());
                this.sfcClassifierService.programIngressClassifier(dataPathId, ruleName, matches, rsp.getPathId(), rsp.getStartingIndex(), nshHeader, vxGpeOfPort, rsp.getName().getValue(), true);
            }
        } else if (hop == lastHop) {
            LOG.info("handleSff: last hop processing {} - {}", (Object)bridgeNode.getNodeId().getValue(), (Object)serviceFunctionForwarder.getName().getValue());
            short lastServiceindex = (short)(lastHop.getServiceIndex().intValue() - 1);
            String sfDplPortName = this.sfcUtils.getSfDplPortId(serviceFunction);
            long sfOfPort = this.getSfPort(bridgeNode, sfDplPortName);
            this.sfcClassifierService.programEgressClassifier(dataPathId, vxGpeOfPort, rsp.getPathId(), lastServiceindex, sfOfPort, 0, rsp.getName().getValue(), true);
            this.sfcClassifierService.programEgressClassifierBypass(dataPathId, vxGpeOfPort, rsp.getPathId(), lastServiceindex, sfOfPort, 0, rsp.getName().getValue(), true);
        }
    }

    void handleSf(Node bridgeNode, ServiceFunction serviceFunction, RenderedServicePath rsp) {
        if (this.isSfOnBridge(bridgeNode, serviceFunction)) {
            LOG.info("handleSf: sf and bridge are on the same node: {} - {}, adding workaround and arp", (Object)bridgeNode.getNodeId().getValue(), (Object)serviceFunction.getName().getValue());
            long dataPathId = this.southbound.getDataPathId(bridgeNode);
            Ip ip = this.sfcUtils.getSfIp(serviceFunction);
            String sfIpAddr = String.valueOf(ip.getIp().getValue());
            int sfIpPort = ip.getPort().getValue();
            String sfDplPortName = this.sfcUtils.getSfDplPortId(serviceFunction);
            long sfOfPort = this.getSfPort(bridgeNode, sfDplPortName);
            String sfMac = this.getMacFromExternalIds(bridgeNode, sfDplPortName);
            if (sfMac == null) {
                LOG.warn("handleSff: could not find mac for {} on {}", (Object)sfDplPortName, (Object)bridgeNode);
                return;
            }
            if (this.addSfFlows.booleanValue()) {
                this.sfcClassifierService.program_sfEgress(dataPathId, sfIpPort, rsp.getName().getValue(), true);
                this.sfcClassifierService.program_sfIngress(dataPathId, sfIpPort, sfOfPort, sfIpAddr, sfDplPortName, rsp.getName().getValue(), true);
            }
            this.sfcClassifierService.programStaticArpEntry(dataPathId, 0L, sfMac, sfIpAddr, rsp.getName().getValue(), true);
        } else {
            LOG.info("handleSf: sf and bridge are not on the same node: {} - {}, do nothing", (Object)bridgeNode.getNodeId().getValue(), (Object)serviceFunction.getName().getValue());
        }
    }

    private boolean isSffOnBridge(Node bridgeNode, ServiceFunctionForwarder serviceFunctionForwarder) {
        String localIp = "";
        Ip ip = this.sfcUtils.getSffIp(serviceFunctionForwarder);
        Node ovsdbNode = this.southbound.readOvsdbNode(bridgeNode);
        if (ovsdbNode != null) {
            localIp = this.getRemoteIp(ovsdbNode);
        }
        LOG.info("isSffOnBridge: {}: {}, localIp/remoteIp: {}, sff ip: {}", new Object[]{bridgeNode.getNodeId().getValue(), localIp.equals(String.valueOf(ip.getIp().getValue())), localIp, ip.getIp().getValue()});
        return localIp.equals(String.valueOf(ip.getIp().getValue()));
    }

    private String getLocalip(Node ovsdbNode) {
        OvsdbNodeAugmentation ovsdbNodeAugmentation;
        Preconditions.checkNotNull((Object)ovsdbNode, (Object)"The ovsdbNode was null");
        String localIp = null;
        if (ovsdbNode != null && (ovsdbNodeAugmentation = (OvsdbNodeAugmentation)ovsdbNode.getAugmentation(OvsdbNodeAugmentation.class)) != null && ovsdbNodeAugmentation.getOpenvswitchOtherConfigs() != null) {
            localIp = this.southbound.getOtherConfig(ovsdbNode, OvsdbTables.OPENVSWITCH, TUNNEL_ENDPOINT_KEY);
        }
        if (localIp == null) {
            LOG.warn("local_ip was not found for node: {}", (Object)ovsdbNode);
            localIp = "";
        }
        return localIp;
    }

    private String getRemoteIp(Node ovsdbNode) {
        Preconditions.checkNotNull((Object)ovsdbNode, (Object)"The ovsdbNode was null");
        String ip = null;
        OvsdbNodeAugmentation ovsdbNodeAugmentation = (OvsdbNodeAugmentation)ovsdbNode.getAugmentation(OvsdbNodeAugmentation.class);
        if (ovsdbNodeAugmentation != null && ovsdbNodeAugmentation.getConnectionInfo() != null) {
            ip = ovsdbNodeAugmentation.getConnectionInfo().getRemoteIp().getIpv4Address().getValue();
        }
        if (ip == null) {
            LOG.warn("remote_ip was not found for node: {}", (Object)ovsdbNode);
            ip = "";
        }
        return ip;
    }

    private boolean isSfOnBridge(Node bridgeNode, ServiceFunction serviceFunction) {
        String sfDplPortName = this.sfcUtils.getSfDplPortId(serviceFunction);
        long sfOfPort = this.getSfPort(bridgeNode, sfDplPortName);
        LOG.info("isSfOnBridge: {}: {}, sfOfPort: {}", new Object[]{bridgeNode.getNodeId().getValue(), sfOfPort != 0L, sfOfPort});
        return sfOfPort != 0L;
    }

    private Ace getAceFromRenderedServicePath(RenderedServicePath rsp) {
        Preconditions.checkNotNull((Object)rsp, (Object)"RSP cannot be null");
        Ace ace = this.sfcUtils.getAce(rsp);
        return ace;
    }

    private RenderedServicePath getRenderedServicePath(Ace entry) {
        RenderedServicePath rsp = null;
        RedirectToSfc sfcRedirect = (RedirectToSfc)entry.getActions().getAugmentation(RedirectToSfc.class);
        LOG.debug("getRenderedServicePath: Processing ACL entry = {} sfcRedirect = {}", (Object)entry.getRuleName(), (Object)sfcRedirect);
        if (sfcRedirect == null) {
            LOG.warn("getRenderedServicePath: sfcRedirect is null");
            return null;
        }
        if (sfcRedirect.getRspName() != null) {
            rsp = this.getRenderedServicePathFromRsp(sfcRedirect.getRspName());
        } else if (sfcRedirect.getSfpName() != null) {
            LOG.warn("getRenderedServicePath: by sfp not handled yet");
        } else {
            rsp = this.getRenderedServicePathFromSfc(entry);
        }
        LOG.info("getRenderedServicePath: rsp: {}", (Object)rsp);
        return rsp;
    }

    private RenderedServicePath getRenderedServicePathFromRsp(String rspName) {
        return this.sfcUtils.getRsp(rspName);
    }

    private RenderedServicePath getRenderedServicePathFromSfc(Ace entry) {
        RedirectToSfc sfcRedirect = (RedirectToSfc)entry.getActions().getAugmentation(RedirectToSfc.class);
        LOG.debug("getRenderedServicePathFromSfc: Processing ACL entry = {} sfcRedirect = {}", (Object)entry.getRuleName(), (Object)sfcRedirect);
        if (sfcRedirect == null) {
            LOG.warn("getRenderedServicePathFromSfc: sfcRedirect is null");
            return null;
        }
        String sfcName = sfcRedirect.getSfcName();
        ServiceFunctionPath sfp = this.sfcUtils.getSfp(sfcName);
        if (sfp == null || sfp.getName() == null) {
            LOG.warn("There is no configured SFP with sfcName = {}; so skip installing the ACL entry!!", (Object)sfcName);
            return null;
        }
        LOG.debug("getRenderedServicePathFromSfc: Processing Redirect to SFC = {}, SFP = {}", (Object)sfcName, (Object)sfp);
        String sfpName = sfp.getName().getValue();
        RenderedServicePath rsp = this.sfcUtils.getRspforSfp(sfpName);
        String rspName = sfp.getName().getValue() + "_rsp";
        if (rsp == null) {
            if (!sfcRedirect.isRenderRsp().booleanValue()) {
                LOG.info("getRenderedServicePathFromSfc: will not create RSP");
                return null;
            }
            LOG.info("getRenderedServicePathFromSfc: No configured RSP corresponding to SFP = {}, Creating new RSP = {}", (Object)sfpName, (Object)rspName);
            CreateRenderedPathInput rspInput = new CreateRenderedPathInputBuilder().setParentServiceFunctionPath(sfpName).setName(rspName).setSymmetric(sfp.isSymmetric()).build();
            rsp = SfcProviderRenderedPathAPI.createRenderedServicePathAndState((ServiceFunctionPath)sfp, (CreateRenderedPathInput)rspInput);
            if (rsp == null) {
                LOG.warn("getRenderedServicePathFromSfc: failed to add RSP");
                return null;
            }
            if (sfp.isSymmetric().booleanValue()) {
                LOG.warn("getRenderedServicePathFromSfc: symmetric RSP is not supported yet");
            }
        }
        return rsp;
    }

    private long getSfPort(Node bridgeNode, String sfPortName) {
        return this.getOFPort(bridgeNode, sfPortName);
    }

    private long getOFPort(Node bridgeNode, String portName) {
        long ofPort = 0L;
        OvsdbTerminationPointAugmentation port = this.southbound.extractTerminationPointAugmentation(bridgeNode, portName);
        if (port != null) {
            ofPort = this.southbound.getOFPort(port);
        }
        if (ofPort == 0L) {
            for (int i = 0; i < 5; ++i) {
                LOG.info("Looking for ofPort {}, try: {}", (Object)portName, (Object)i);
                TerminationPoint tp = this.southbound.readTerminationPoint(bridgeNode, null, portName);
                if (tp != null && (port = (OvsdbTerminationPointAugmentation)tp.getAugmentation(OvsdbTerminationPointAugmentation.class)) != null) {
                    ofPort = this.southbound.getOFPort(port);
                    LOG.info("found ofPort {} - {}, try: {}", new Object[]{portName, ofPort, i});
                    break;
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    LOG.error("Interrupted while waiting for ofPort {}", (Object)portName, (Object)e);
                }
            }
        }
        return ofPort;
    }

    private String getMacFromExternalIds(Node bridgeNode, String portName) {
        String mac = null;
        OvsdbTerminationPointAugmentation port = this.southbound.getTerminationPointOfBridge(bridgeNode, portName);
        LOG.info("getMac: portName: {}, bridgeNode: {},,, port: {}", new Object[]{portName, bridgeNode, port});
        if (port != null && port.getInterfaceExternalIds() != null) {
            mac = this.southbound.getInterfaceExternalIdsValue(port, "attached-mac");
        }
        return mac;
    }

    @Override
    public void setDependencies(ServiceReference serviceReference) {
        this.nodeCacheManager = (NodeCacheManager)ServiceHelper.getGlobalInstance(NodeCacheManager.class, (Object)this);
        this.southbound = (Southbound)ServiceHelper.getGlobalInstance(Southbound.class, (Object)this);
        this.sfcClassifierService = (ISfcClassifierService)ServiceHelper.getGlobalInstance(ISfcClassifierService.class, (Object)this);
        LOG.info("sfcClassifierService= {}", (Object)this.sfcClassifierService);
    }
}

