/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netvirt.openstack.netvirt.sfc;

import com.google.common.base.Preconditions;
import org.opendaylight.netvirt.openstack.netvirt.sfc.INetvirtSfcDataProcessor;
import org.opendaylight.netvirt.openstack.netvirt.sfc.INetvirtSfcOF13Provider;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.rendered.service.paths.RenderedServicePath;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class RspDataProcessor
implements INetvirtSfcDataProcessor<RenderedServicePath> {
    private final INetvirtSfcOF13Provider provider;

    public RspDataProcessor(INetvirtSfcOF13Provider provider) {
        this.provider = (INetvirtSfcOF13Provider)Preconditions.checkNotNull((Object)provider, (Object)"Provider can not be null!");
    }

    @Override
    public void remove(InstanceIdentifier<RenderedServicePath> identifier, RenderedServicePath change) {
        Preconditions.checkNotNull((Object)change, (Object)"Removed object can not be null!");
        this.provider.removeRsp(change);
    }

    @Override
    public void update(InstanceIdentifier<RenderedServicePath> identifier, RenderedServicePath original, RenderedServicePath change) {
        Preconditions.checkNotNull((Object)original, (Object)"Updated original object can not be null!");
        Preconditions.checkNotNull((Object)original, (Object)"Updated update object can not be null!");
        this.remove(identifier, original);
        this.provider.addRsp(change);
    }

    @Override
    public void add(InstanceIdentifier<RenderedServicePath> identifier, RenderedServicePath change) {
        Preconditions.checkNotNull((Object)change, (Object)"Created object can not be null!");
        this.provider.addRsp(change);
    }
}

