/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netvirt.openstack.netvirt.sfc;

import com.google.common.base.Preconditions;
import java.util.Dictionary;
import java.util.Hashtable;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.netvirt.openstack.netvirt.providers.openflow13.AbstractServiceInstance;
import org.opendaylight.netvirt.openstack.netvirt.providers.openflow13.Service;
import org.opendaylight.netvirt.openstack.netvirt.sfc.INetvirtSfcOF13Provider;
import org.opendaylight.netvirt.openstack.netvirt.sfc.ISfcClassifierService;
import org.opendaylight.netvirt.openstack.netvirt.sfc.NetvirtSfcAclListener;
import org.opendaylight.netvirt.openstack.netvirt.sfc.NetvirtSfcClassifierListener;
import org.opendaylight.netvirt.openstack.netvirt.sfc.RspListener;
import org.opendaylight.netvirt.openstack.netvirt.sfc.SfcUtils;
import org.opendaylight.netvirt.openstack.netvirt.sfc.standalone.openflow13.NetvirtSfcStandaloneOF13Provider;
import org.opendaylight.netvirt.openstack.netvirt.sfc.workaround.NetvirtSfcWorkaroundOF13Provider;
import org.opendaylight.netvirt.openstack.netvirt.sfc.workaround.services.SfcClassifierService;
import org.opendaylight.netvirt.utils.mdsal.utils.MdsalUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netvirt.sfc.impl.config.rev160517.NetvirtSfcConfig;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetvirtSfcProvider
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NetvirtSfcProvider.class);
    private AutoCloseable aclListener;
    private AutoCloseable classifierListener;
    private AutoCloseable rspListener;
    private final Boolean addSfFlows;
    private final String of13Provider;
    private final DataBroker dataBroker;
    private final BundleContext bundleContext;
    private ServiceRegistration<?> reg;

    public NetvirtSfcProvider(DataBroker dataBroker, NetvirtSfcConfig netvirtSfcConfig, BundleContext bundleContext) {
        LOG.info("NetvirtSfcProvider started");
        this.dataBroker = dataBroker;
        this.addSfFlows = (Boolean)Preconditions.checkNotNull((Object)netvirtSfcConfig.isAddsflows(), (Object)"AddsFlow must be configured");
        this.of13Provider = (String)Preconditions.checkNotNull((Object)netvirtSfcConfig.getOf13provider(), (Object)" Provider type must be configured");
        this.bundleContext = bundleContext;
    }

    public void start() {
        LOG.info("NetvirtSfcProvider Session Initiated");
        MdsalUtils mdsalUtils = new MdsalUtils(this.dataBroker);
        SfcUtils sfcUtils = new SfcUtils(mdsalUtils);
        INetvirtSfcOF13Provider provider = this.of13Provider.equals("standalone") ? new NetvirtSfcStandaloneOF13Provider(this.dataBroker) : new NetvirtSfcWorkaroundOF13Provider(this.dataBroker, mdsalUtils, sfcUtils, this.addSfFlows);
        this.aclListener = new NetvirtSfcAclListener(provider, this.dataBroker);
        this.classifierListener = new NetvirtSfcClassifierListener(provider, this.dataBroker);
        this.rspListener = new RspListener(provider, this.dataBroker);
        this.addToPipeline(provider);
        provider.setDependencies(null);
    }

    @Override
    public void close() throws Exception {
        LOG.info("NetvirtSfcProvider Closed");
        if (this.aclListener != null) {
            this.aclListener.close();
        }
        if (this.classifierListener != null) {
            this.classifierListener.close();
        }
        if (this.rspListener != null) {
            this.rspListener.close();
        }
        if (this.reg != null) {
            this.reg.unregister();
        }
    }

    private void addToPipeline(INetvirtSfcOF13Provider provider) {
        if (provider instanceof NetvirtSfcStandaloneOF13Provider) {
            org.opendaylight.netvirt.openstack.netvirt.sfc.standalone.openflow13.services.SfcClassifierService sfcClassifierService = new org.opendaylight.netvirt.openstack.netvirt.sfc.standalone.openflow13.services.SfcClassifierService();
            this.reg = this.registerService(this.bundleContext, ISfcClassifierService.class.getName(), sfcClassifierService, (Object)Service.SFC_CLASSIFIER);
            sfcClassifierService.setDependencies(this.bundleContext, null);
        } else {
            SfcClassifierService sfcClassifierService = new SfcClassifierService();
            this.reg = this.registerService(this.bundleContext, ISfcClassifierService.class.getName(), sfcClassifierService, (Object)Service.SFC_CLASSIFIER);
            sfcClassifierService.setDependencies(this.bundleContext, null);
        }
    }

    private ServiceRegistration<?> registerService(BundleContext bundleContext, String[] interfaces, Dictionary<String, Object> properties, Object impl) {
        ServiceRegistration serviceRegistration = bundleContext.registerService(interfaces, impl, properties);
        return serviceRegistration;
    }

    private ServiceRegistration<?> registerService(BundleContext bundleContext, String interfaceClassName, Object impl, Object serviceProperty) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("serviceProperty", serviceProperty);
        ((Dictionary)properties).put("providerName", "OF13Provider");
        return this.registerService(bundleContext, new String[]{AbstractServiceInstance.class.getName(), interfaceClassName}, properties, impl);
    }
}

