/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netvirt.openstack.netvirt.sfc;

import com.google.common.base.Preconditions;
import org.opendaylight.netvirt.openstack.netvirt.sfc.INetvirtSfcDataProcessor;
import org.opendaylight.netvirt.openstack.netvirt.sfc.INetvirtSfcOF13Provider;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.Acl;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class NetvirtSfcAclDataProcessor
implements INetvirtSfcDataProcessor<Acl> {
    private final INetvirtSfcOF13Provider provider;

    public NetvirtSfcAclDataProcessor(INetvirtSfcOF13Provider provider) {
        this.provider = (INetvirtSfcOF13Provider)Preconditions.checkNotNull((Object)provider, (Object)"Provider can not be null!");
    }

    @Override
    public void remove(InstanceIdentifier<Acl> identifier, Acl change) {
        Preconditions.checkNotNull((Object)change, (Object)"Removed object can not be null!");
        this.provider.removeClassifierRules(change);
    }

    @Override
    public void update(InstanceIdentifier<Acl> identifier, Acl original, Acl change) {
        Preconditions.checkNotNull((Object)original, (Object)"Updated original object can not be null!");
        Preconditions.checkNotNull((Object)original, (Object)"Updated update object can not be null!");
        this.remove(identifier, original);
        this.provider.addClassifierRules(change);
    }

    @Override
    public void add(InstanceIdentifier<Acl> identifier, Acl change) {
        Preconditions.checkNotNull((Object)change, (Object)"Added object can not be null!");
        this.provider.addClassifierRules(change);
    }
}

