/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.trace.impl;

import com.google.common.util.concurrent.FluentFuture;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.trace.impl.AbstractTracingWriteTransaction;
import org.opendaylight.mdsal.trace.impl.CloseTracked;
import org.opendaylight.mdsal.trace.impl.CloseTrackedRegistry;
import org.opendaylight.mdsal.trace.impl.CloseTrackedTrait;
import org.opendaylight.mdsal.trace.impl.TracingBroker;

class TracingWriteTransaction
extends AbstractTracingWriteTransaction
implements CloseTracked<TracingWriteTransaction> {
    private final CloseTrackedTrait<TracingWriteTransaction> closeTracker;

    TracingWriteTransaction(DOMDataTreeWriteTransaction delegate, TracingBroker tracingBroker, CloseTrackedRegistry<TracingWriteTransaction> writeTransactionsRegistry) {
        super(delegate, tracingBroker);
        this.closeTracker = new CloseTrackedTrait<TracingWriteTransaction>(writeTransactionsRegistry, this);
    }

    @Override
    public FluentFuture<? extends CommitInfo> commit() {
        this.closeTracker.removeFromTrackedRegistry();
        return super.commit();
    }

    @Override
    public boolean cancel() {
        this.closeTracker.removeFromTrackedRegistry();
        return super.cancel();
    }

    @Override
    public @Nullable StackTraceElement[] getAllocationContextStackTrace() {
        return this.closeTracker.getAllocationContextStackTrace();
    }

    @Override
    public CloseTracked<TracingWriteTransaction> getRealCloseTracked() {
        return this;
    }
}

