/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.trace.impl;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.trace.impl.AbstractCloseTracked;
import org.opendaylight.mdsal.trace.impl.CloseTrackedRegistry;
import org.opendaylight.mdsal.trace.impl.TracingBroker;
import org.opendaylight.mdsal.trace.impl.TracingReadOnlyTransaction;
import org.opendaylight.mdsal.trace.impl.TracingReadWriteTransaction;
import org.opendaylight.mdsal.trace.impl.TracingWriteTransaction;
import org.opendaylight.yangtools.yang.common.Empty;

class TracingTransactionChain
extends AbstractCloseTracked<TracingTransactionChain>
implements DOMTransactionChain {
    private final DOMTransactionChain delegate;
    private final TracingBroker tracingBroker;
    private final CloseTrackedRegistry<TracingReadOnlyTransaction> readOnlyTransactionsRegistry;
    private final CloseTrackedRegistry<TracingWriteTransaction> writeTransactionsRegistry;
    private final CloseTrackedRegistry<TracingReadWriteTransaction> readWriteTransactionsRegistry;

    TracingTransactionChain(DOMTransactionChain delegate, TracingBroker tracingBroker, CloseTrackedRegistry<TracingTransactionChain> transactionChainsRegistry) {
        super(transactionChainsRegistry);
        this.delegate = Objects.requireNonNull(delegate);
        this.tracingBroker = Objects.requireNonNull(tracingBroker);
        boolean isDebug = transactionChainsRegistry.isDebugContextEnabled();
        String anchor = "TransactionChain@" + Integer.toHexString(this.hashCode());
        this.readOnlyTransactionsRegistry = new CloseTrackedRegistry(anchor, "newReadOnlyTransaction()", isDebug);
        this.writeTransactionsRegistry = new CloseTrackedRegistry(anchor, "newWriteOnlyTransaction()", isDebug);
        this.readWriteTransactionsRegistry = new CloseTrackedRegistry(anchor, "newReadWriteTransaction()", isDebug);
    }

    public ListenableFuture<Empty> future() {
        return this.delegate.future();
    }

    public DOMDataTreeReadTransaction newReadOnlyTransaction() {
        return new TracingReadOnlyTransaction(this.delegate.newReadOnlyTransaction(), this.readOnlyTransactionsRegistry);
    }

    public DOMDataTreeReadWriteTransaction newReadWriteTransaction() {
        return new TracingReadWriteTransaction(this.delegate.newReadWriteTransaction(), this.tracingBroker, this.readWriteTransactionsRegistry);
    }

    public DOMDataTreeWriteTransaction newWriteOnlyTransaction() {
        return new TracingWriteTransaction(this.delegate.newWriteOnlyTransaction(), this.tracingBroker, this.writeTransactionsRegistry);
    }

    public void close() {
        this.delegate.close();
        super.removeFromTrackedRegistry();
    }

    public CloseTrackedRegistry<TracingReadOnlyTransaction> getReadOnlyTransactionsRegistry() {
        return this.readOnlyTransactionsRegistry;
    }

    public CloseTrackedRegistry<TracingReadWriteTransaction> getReadWriteTransactionsRegistry() {
        return this.readWriteTransactionsRegistry;
    }

    public CloseTrackedRegistry<TracingWriteTransaction> getWriteTransactionsRegistry() {
        return this.writeTransactionsRegistry;
    }

    public final boolean equals(Object object) {
        return object == this || this.delegate.equals(object);
    }

    public final int hashCode() {
        return this.delegate.hashCode();
    }

    public final String toString() {
        return this.getClass().getName() + "; delegate=" + this.delegate;
    }
}

