/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.trace.impl;

import com.google.common.util.concurrent.FluentFuture;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.trace.impl.AbstractCloseTracked;
import org.opendaylight.mdsal.trace.impl.CloseTrackedRegistry;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

class TracingReadOnlyTransaction
extends AbstractCloseTracked<TracingReadOnlyTransaction>
implements DOMDataTreeReadTransaction {
    private final DOMDataTreeReadTransaction delegate;

    TracingReadOnlyTransaction(DOMDataTreeReadTransaction delegate, CloseTrackedRegistry<TracingReadOnlyTransaction> readOnlyTransactionsRegistry) {
        super(readOnlyTransactionsRegistry);
        this.delegate = Objects.requireNonNull(delegate);
    }

    public FluentFuture<Optional<NormalizedNode>> read(LogicalDatastoreType store, YangInstanceIdentifier path) {
        return this.delegate.read(store, path);
    }

    public FluentFuture<Boolean> exists(LogicalDatastoreType store, YangInstanceIdentifier path) {
        return this.delegate.exists(store, path);
    }

    public Object getIdentifier() {
        return this.delegate.getIdentifier();
    }

    public void close() {
        this.delegate.close();
        super.removeFromTrackedRegistry();
    }

    public final boolean equals(Object object) {
        return object == this || this.delegate.equals(object);
    }

    public final int hashCode() {
        return this.delegate.hashCode();
    }

    public final String toString() {
        return this.getClass().getName() + "; delegate=" + this.delegate;
    }
}

