/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.trace.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTree;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.trace.api.TracingDOMDataBroker;
import org.opendaylight.mdsal.trace.impl.CloseTracked;
import org.opendaylight.mdsal.trace.impl.CloseTrackedRegistry;
import org.opendaylight.mdsal.trace.impl.CloseTrackedRegistryReportEntry;
import org.opendaylight.mdsal.trace.impl.TracingReadOnlyTransaction;
import org.opendaylight.mdsal.trace.impl.TracingReadWriteTransaction;
import org.opendaylight.mdsal.trace.impl.TracingTransactionChain;
import org.opendaylight.mdsal.trace.impl.TracingWriteTransaction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsaltrace.rev160908.Config;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.DataObjectStep;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingBroker
implements TracingDOMDataBroker {
    private static final Logger LOG = LoggerFactory.getLogger(TracingBroker.class);
    private static final int STACK_TRACE_FIRST_RELEVANT_FRAME = 2;
    private final BindingCodecTree codec;
    private final DOMDataBroker delegate;
    private final List<Watch> registrationWatches = new ArrayList<Watch>();
    private final List<Watch> writeWatches = new ArrayList<Watch>();
    private final boolean isDebugging;
    private final CloseTrackedRegistry<TracingTransactionChain> transactionChainsRegistry;
    private final CloseTrackedRegistry<TracingReadOnlyTransaction> readOnlyTransactionsRegistry;
    private final CloseTrackedRegistry<TracingWriteTransaction> writeTransactionsRegistry;
    private final CloseTrackedRegistry<TracingReadWriteTransaction> readWriteTransactionsRegistry;

    public TracingBroker(DOMDataBroker delegate, Config config, BindingCodecTree codec) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.codec = Objects.requireNonNull(codec, "codec");
        this.configure(config);
        this.isDebugging = Boolean.TRUE.equals(config.getTransactionDebugContextEnabled());
        String db = "DataBroker";
        this.transactionChainsRegistry = new CloseTrackedRegistry("DataBroker", "createTransactionChain()", this.isDebugging);
        this.readOnlyTransactionsRegistry = new CloseTrackedRegistry("DataBroker", "newReadOnlyTransaction()", this.isDebugging);
        this.writeTransactionsRegistry = new CloseTrackedRegistry("DataBroker", "newWriteOnlyTransaction()", this.isDebugging);
        this.readWriteTransactionsRegistry = new CloseTrackedRegistry("DataBroker", "newReadWriteTransaction()", this.isDebugging);
    }

    private void configure(Config config) {
        this.registrationWatches.clear();
        Set paths = config.getRegistrationWatches();
        if (paths != null) {
            for (String path : paths) {
                this.watchRegistrations(path, null);
            }
        }
        this.writeWatches.clear();
        paths = config.getWriteWatches();
        if (paths != null) {
            for (String path : paths) {
                this.watchWrites(path, null);
            }
        }
    }

    public void watchRegistrations(String iidString, LogicalDatastoreType store) {
        LOG.info("Watching registrations to {} in {}", (Object)iidString, (Object)store);
        this.registrationWatches.add(new Watch(iidString, store));
    }

    public void watchWrites(String iidString, LogicalDatastoreType store) {
        LOG.info("Watching writes to {} in {}", (Object)iidString, (Object)store);
        Watch watch = new Watch(iidString, store);
        this.writeWatches.add(watch);
    }

    private boolean isRegistrationWatched(YangInstanceIdentifier iid, LogicalDatastoreType store) {
        if (this.registrationWatches.isEmpty()) {
            return true;
        }
        for (Watch regInterest : this.registrationWatches) {
            if (!regInterest.subtreesOverlap(iid, store)) continue;
            return true;
        }
        return false;
    }

    boolean isWriteWatched(YangInstanceIdentifier iid, LogicalDatastoreType store) {
        if (this.writeWatches.isEmpty()) {
            return true;
        }
        for (Watch watch : this.writeWatches) {
            if (!watch.eventIsOfInterest(iid, store)) continue;
            return true;
        }
        return false;
    }

    static void toPathString(InstanceIdentifier<? extends DataObject> iid, StringBuilder builder) {
        for (DataObjectStep pathArg : iid.getPathArguments()) {
            builder.append('/').append(pathArg.type().getSimpleName());
        }
    }

    String toPathString(YangInstanceIdentifier yiid) {
        StringBuilder sb = new StringBuilder();
        this.toPathString(yiid, sb);
        return sb.toString();
    }

    private void toPathString(YangInstanceIdentifier yiid, StringBuilder sb) {
        InstanceIdentifier iid = this.codec.getInstanceIdentifierCodec().toBinding(yiid);
        if (null == iid) {
            TracingBroker.reconstructIidPathString(yiid, sb);
        } else {
            TracingBroker.toPathString((InstanceIdentifier<? extends DataObject>)iid, sb);
        }
    }

    private static void reconstructIidPathString(YangInstanceIdentifier yiid, StringBuilder sb) {
        sb.append("<RECONSTRUCTED FROM: \"").append(yiid.toString()).append("\">");
        for (YangInstanceIdentifier.PathArgument pathArg : yiid.getPathArguments()) {
            sb.append('/').append(pathArg.getNodeType().getLocalName());
        }
    }

    String getStackSummary() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder();
        for (int i = 2; i < stack.length; ++i) {
            StackTraceElement frame = stack[i];
            sb.append("\n\t(TracingBroker)\t").append(frame.getClassName()).append('.').append(frame.getMethodName());
        }
        return sb.toString();
    }

    public DOMDataTreeReadWriteTransaction newReadWriteTransaction() {
        return new TracingReadWriteTransaction(this.delegate.newReadWriteTransaction(), this, this.readWriteTransactionsRegistry);
    }

    public DOMDataTreeWriteTransaction newWriteOnlyTransaction() {
        return new TracingWriteTransaction(this.delegate.newWriteOnlyTransaction(), this, this.writeTransactionsRegistry);
    }

    public DOMTransactionChain createTransactionChain() {
        return new TracingTransactionChain(this.delegate.createTransactionChain(), this, this.transactionChainsRegistry);
    }

    public DOMTransactionChain createMergingTransactionChain() {
        return new TracingTransactionChain(this.delegate.createMergingTransactionChain(), this, this.transactionChainsRegistry);
    }

    public DOMDataTreeReadTransaction newReadOnlyTransaction() {
        return new TracingReadOnlyTransaction(this.delegate.newReadOnlyTransaction(), this.readOnlyTransactionsRegistry);
    }

    public <T extends DOMDataBroker.Extension> T extension(Class<T> type) {
        DOMDataBroker.Extension ext = (DOMDataBroker.Extension)this.delegate.extension(type);
        if (DOMDataBroker.DataTreeChangeExtension.class.equals(type) && ext instanceof DOMDataBroker.DataTreeChangeExtension) {
            final DOMDataBroker.DataTreeChangeExtension treeChange = (DOMDataBroker.DataTreeChangeExtension)ext;
            return (T)((DOMDataBroker.Extension)type.cast(new DOMDataBroker.DataTreeChangeExtension(){

                public Registration registerTreeChangeListener(DOMDataTreeIdentifier treeId, DOMDataTreeChangeListener listener) {
                    this.notifyIfWatched("Non-clustered", treeId, listener);
                    return treeChange.registerTreeChangeListener(treeId, listener);
                }

                @Deprecated(since="13.0.0", forRemoval=true)
                public Registration registerLegacyTreeChangeListener(DOMDataTreeIdentifier treeId, DOMDataTreeChangeListener listener) {
                    this.notifyIfWatched("Non-clustered", treeId, listener);
                    return treeChange.registerLegacyTreeChangeListener(treeId, listener);
                }

                private void notifyIfWatched(String kind, DOMDataTreeIdentifier treeId, DOMDataTreeChangeListener listener) {
                    YangInstanceIdentifier rootId = treeId.path();
                    if (TracingBroker.this.isRegistrationWatched(rootId, treeId.datastore()) && LOG.isWarnEnabled()) {
                        LOG.warn("{} registration (registerDataTreeChangeListener) for {} from {}.", new Object[]{kind, TracingBroker.this.toPathString(rootId), TracingBroker.this.getStackSummary()});
                    }
                }
            }));
        }
        return (T)ext;
    }

    public boolean printOpenTransactions(PrintStream ps, int minOpenTXs) {
        if (this.transactionChainsRegistry.getAllUnique().isEmpty() && this.readOnlyTransactionsRegistry.getAllUnique().isEmpty() && this.writeTransactionsRegistry.getAllUnique().isEmpty() && this.readWriteTransactionsRegistry.getAllUnique().isEmpty()) {
            ps.println("No open transactions, great!");
            return false;
        }
        ps.println(this.getClass().getSimpleName() + " found some not yet (or never..) closed transaction[chain]s!");
        ps.println("[NB: If no stack traces are shown below, then enable transaction-debug-context-enabled in mdsaltrace_config.xml]");
        ps.println();
        boolean hasFound = this.print(this.readOnlyTransactionsRegistry, ps, "  ", minOpenTXs);
        hasFound |= this.print(this.writeTransactionsRegistry, ps, "  ", minOpenTXs);
        hasFound |= this.print(this.readWriteTransactionsRegistry, ps, "  ", minOpenTXs);
        Set<CloseTrackedRegistryReportEntry<TracingTransactionChain>> entries = this.transactionChainsRegistry.getAllUnique();
        if (!entries.isEmpty()) {
            ps.println("  " + this.transactionChainsRegistry.getAnchor() + " : " + this.transactionChainsRegistry.getCreateDescription());
        }
        for (CloseTrackedRegistryReportEntry<TracingTransactionChain> entry : entries) {
            ps.println("    " + entry.getNumberAddedNotRemoved() + "x TransactionChains opened but not closed here:");
            this.printStackTraceElements(ps, "      ", entry.getStackTraceElements());
            TracingTransactionChain txChain = (TracingTransactionChain)entry.getExampleCloseTracked().getRealCloseTracked();
            hasFound |= this.print(txChain.getReadOnlyTransactionsRegistry(), ps, "        ", minOpenTXs);
            hasFound |= this.print(txChain.getWriteTransactionsRegistry(), ps, "        ", minOpenTXs);
            hasFound |= this.print(txChain.getReadWriteTransactionsRegistry(), ps, "        ", minOpenTXs);
        }
        ps.println();
        return hasFound;
    }

    final void logEmptySet(YangInstanceIdentifier yiid) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Empty data set write to {}", (Object)this.toPathString(yiid));
        }
    }

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"}, justification="pre-formatted logs")
    static final void logOperations(Object identifier, List<?> operations) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("Transaction {} contains the following operations:", identifier);
            for (Object operation : operations) {
                LOG.warn("{}", operation);
            }
        }
    }

    private <T extends CloseTracked<T>> boolean print(CloseTrackedRegistry<T> registry, PrintStream ps, String indent, int minOpenTransactions) {
        Set<CloseTrackedRegistryReportEntry<T>> unsorted = registry.getAllUnique();
        if (unsorted.size() < minOpenTransactions) {
            return false;
        }
        ArrayList<CloseTrackedRegistryReportEntry<CloseTrackedRegistryReportEntry>> entries = new ArrayList<CloseTrackedRegistryReportEntry<CloseTrackedRegistryReportEntry>>(unsorted);
        entries.sort((o1, o2) -> Long.compare(o2.getNumberAddedNotRemoved(), o1.getNumberAddedNotRemoved()));
        if (!entries.isEmpty()) {
            ps.println(indent + registry.getAnchor() + " : " + registry.getCreateDescription());
        }
        entries.forEach(entry -> {
            ps.println(indent + "  " + entry.getNumberAddedNotRemoved() + "x transactions opened here, which are not closed:");
            this.printStackTraceElements(ps, indent + "    ", entry.getStackTraceElements());
        });
        if (!entries.isEmpty()) {
            ps.println();
        }
        return true;
    }

    private void printStackTraceElements(PrintStream ps, String indent, List<StackTraceElement> stackTraceElements) {
        boolean ellipsis = false;
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            if (this.isStackTraceElementInteresting(stackTraceElement)) {
                ps.println(indent + stackTraceElement);
                ellipsis = false;
                continue;
            }
            if (ellipsis) continue;
            ps.println(indent + "(...)");
            ellipsis = true;
        }
    }

    private boolean isStackTraceElementInteresting(StackTraceElement element) {
        String className = element.getClassName();
        return !className.startsWith(this.getClass().getPackage().getName()) && !className.startsWith(CloseTracked.class.getPackage().getName()) && !className.startsWith("Proxy") && !className.startsWith("akka") && !className.startsWith("scala") && !className.startsWith("sun.reflect") && !className.startsWith("java.lang.reflect") && !className.startsWith("org.apache.aries.blueprint") && !className.startsWith("org.osgi.util.tracker");
    }

    private class Watch {
        final String iidString;
        final LogicalDatastoreType store;

        Watch(String iidString, LogicalDatastoreType storeOrNull) {
            this.store = storeOrNull;
            this.iidString = iidString;
        }

        private String toIidCompString(YangInstanceIdentifier iid) {
            StringBuilder builder = new StringBuilder();
            TracingBroker.this.toPathString(iid, builder);
            return builder.append('/').toString();
        }

        private boolean isParent(String parent, String child) {
            int parentOffset = 0;
            if (parent.length() > 0 && parent.charAt(0) == '<') {
                parentOffset = parent.indexOf(62) + 1;
            }
            int childOffset = 0;
            if (child.length() > 0 && child.charAt(0) == '<') {
                childOffset = child.indexOf(62) + 1;
            }
            return child.startsWith(parent.substring(parentOffset), childOffset);
        }

        public boolean subtreesOverlap(YangInstanceIdentifier iid, LogicalDatastoreType store) {
            if (this.store != null && !this.store.equals((Object)store)) {
                return false;
            }
            String otherIidString = this.toIidCompString(iid);
            return this.isParent(this.iidString, otherIidString) || this.isParent(otherIidString, this.iidString);
        }

        public boolean eventIsOfInterest(YangInstanceIdentifier iid, LogicalDatastoreType store) {
            if (this.store != null && !this.store.equals((Object)store)) {
                return false;
            }
            return this.isParent(this.iidString, TracingBroker.this.toPathString(iid));
        }
    }
}

