/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.javav2.generator.yang.types;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opendaylight.mdsal.binding.javav2.generator.context.ModuleContext;
import org.opendaylight.mdsal.binding.javav2.generator.spi.TypeProvider;
import org.opendaylight.mdsal.binding.javav2.generator.util.BindingGeneratorUtil;
import org.opendaylight.mdsal.binding.javav2.generator.util.JavaIdentifier;
import org.opendaylight.mdsal.binding.javav2.generator.util.JavaIdentifierNormalizer;
import org.opendaylight.mdsal.binding.javav2.generator.util.Types;
import org.opendaylight.mdsal.binding.javav2.generator.util.generated.type.builder.GeneratedPropertyBuilderImpl;
import org.opendaylight.mdsal.binding.javav2.generator.util.generated.type.builder.GeneratedTOBuilderImpl;
import org.opendaylight.mdsal.binding.javav2.generator.yang.types.BaseYangTypes;
import org.opendaylight.mdsal.binding.javav2.generator.yang.types.TypeGenHelper;
import org.opendaylight.mdsal.binding.javav2.model.api.AccessModifier;
import org.opendaylight.mdsal.binding.javav2.model.api.ConcreteType;
import org.opendaylight.mdsal.binding.javav2.model.api.Enumeration;
import org.opendaylight.mdsal.binding.javav2.model.api.GeneratedProperty;
import org.opendaylight.mdsal.binding.javav2.model.api.GeneratedTransferObject;
import org.opendaylight.mdsal.binding.javav2.model.api.Restrictions;
import org.opendaylight.mdsal.binding.javav2.model.api.Type;
import org.opendaylight.mdsal.binding.javav2.model.api.WildcardType;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.EnumBuilder;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.mdsal.binding.javav2.spec.runtime.BindingNamespaceType;
import org.opendaylight.mdsal.binding.javav2.util.BindingMapping;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.RevisionAwareXPathImpl;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;
import org.opendaylight.yangtools.yang.parser.util.ModuleDependencySort;
import org.opendaylight.yangtools.yang.parser.util.YangValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class TypeProviderImpl
implements TypeProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TypeProviderImpl.class);
    private static final Pattern NUMBERS_PATTERN = Pattern.compile("[0-9]+\\z");
    private final SchemaContext schemaContext;
    private final Map<String, Map<Date, Map<String, Type>>> genTypeDefsContextMap;
    private final Map<SchemaPath, Type> referencedTypes;
    private final Map<Module, Set<Type>> additionalTypes;

    public TypeProviderImpl(SchemaContext schemaContext) {
        this.schemaContext = schemaContext;
        this.genTypeDefsContextMap = new HashMap<String, Map<Date, Map<String, Type>>>();
        this.referencedTypes = new HashMap<SchemaPath, Type>();
        this.additionalTypes = new HashMap<Module, Set<Type>>();
        this.resolveTypeDefsFromContext(schemaContext, this.genTypeDefsContextMap, this.additionalTypes);
    }

    public Type javaTypeForSchemaDefinitionType(TypeDefinition<?> type, SchemaNode parentNode, ModuleContext context) {
        return this.javaTypeForSchemaDefinitionType(type, parentNode, null, context);
    }

    public Type javaTypeForSchemaDefinitionType(TypeDefinition<?> type, SchemaNode parentNode, Restrictions restrictions, ModuleContext context) {
        return this.javaTypeForSchemaDefType(type, parentNode, restrictions, this.schemaContext, this.genTypeDefsContextMap, context);
    }

    public String getTypeDefaultConstruction(LeafSchemaNode node) {
        return null;
    }

    public String getConstructorPropertyName(SchemaNode node) {
        return null;
    }

    public String getParamNameFromType(TypeDefinition<?> type) {
        return null;
    }

    public Map<String, Map<Date, Map<String, Type>>> getGenTypeDefsContextMap() {
        return this.genTypeDefsContextMap;
    }

    private void resolveTypeDefsFromContext(SchemaContext schemaContext, Map<String, Map<Date, Map<String, Type>>> genTypeDefsContextMap, Map<Module, Set<Type>> additionalTypes) {
        Set modules = schemaContext.getModules();
        Preconditions.checkArgument((modules != null ? 1 : 0) != 0, (Object)"Set of Modules cannot be NULL!");
        List modulesSortedByDependency = ModuleDependencySort.sort((Iterable)modules);
        for (Module module2 : modulesSortedByDependency) {
            Map<Date, Map<String, Type>> dateTypeMap = genTypeDefsContextMap.get(module2.getName());
            if (dateTypeMap == null) {
                dateTypeMap = new HashMap<Date, Map<String, Type>>();
            }
            dateTypeMap.put(module2.getRevision(), Collections.emptyMap());
            genTypeDefsContextMap.put(module2.getName(), dateTypeMap);
        }
        modulesSortedByDependency.stream().filter(module -> module != null).forEach(module -> {
            ModuleContext context = new ModuleContext();
            String basePackageName = BindingGeneratorUtil.packageNameWithNamespacePrefix((String)BindingMapping.getRootPackageName((Module)module), (BindingNamespaceType)BindingNamespaceType.Typedef);
            List<TypeDefinition<?>> typeDefinitions = TypeGenHelper.getAllTypedefs(module);
            List<TypeDefinition<?>> listTypeDefinitions = TypeGenHelper.sortTypeDefinitionAccordingDepth(typeDefinitions);
            if (listTypeDefinitions != null) {
                for (TypeDefinition<?> typedef : listTypeDefinitions) {
                    this.typedefToGeneratedType(basePackageName, (Module)module, typedef, genTypeDefsContextMap, additionalTypes, schemaContext, context);
                }
            }
        });
    }

    public Type generatedTypeForExtendedDefinitionType(TypeDefinition<?> typeDefinition, SchemaNode parentNode) {
        Map<Date, Map<String, Type>> modulesByDate;
        Map<String, Type> genTOs;
        Module module;
        Preconditions.checkArgument((typeDefinition != null ? 1 : 0) != 0, (Object)"Type Definition cannot be NULL!");
        Preconditions.checkArgument((typeDefinition.getQName().getLocalName() != null ? 1 : 0) != 0, (Object)"Type Definitions Local Name cannot be NULL!");
        TypeDefinition<?> baseTypeDef = TypeGenHelper.baseTypeDefForExtendedType(typeDefinition);
        if (!(baseTypeDef instanceof LeafrefTypeDefinition) && !(baseTypeDef instanceof IdentityrefTypeDefinition) && (module = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)parentNode)) != null && (genTOs = (modulesByDate = this.genTypeDefsContextMap.get(module.getName())).get(module.getRevision())) != null) {
            return genTOs.get(typeDefinition.getQName().getLocalName());
        }
        return null;
    }

    public void putReferencedType(SchemaPath refTypePath, Type refType) {
        Preconditions.checkArgument((refTypePath != null ? 1 : 0) != 0, (Object)"Path reference of Enumeration Type Definition cannot be NULL!");
        Preconditions.checkArgument((refType != null ? 1 : 0) != 0, (Object)"Reference to Enumeration Type cannot be NULL!");
        this.referencedTypes.put(refTypePath, refType);
    }

    public GeneratedTOBuilder provideGeneratedTOBuilderForBitsTypeDefinition(String basePackageName, TypeDefinition<?> typeDef, String typeDefName, String moduleName, ModuleContext context) {
        Preconditions.checkArgument((typeDef != null ? 1 : 0) != 0, (Object)"typeDef cannot be NULL!");
        Preconditions.checkArgument((basePackageName != null ? 1 : 0) != 0, (Object)"Base Package Name cannot be NULL!");
        if (typeDef instanceof BitsTypeDefinition) {
            BitsTypeDefinition bitsTypeDefinition = (BitsTypeDefinition)typeDef;
            GeneratedTOBuilderImpl genTOBuilder = new GeneratedTOBuilderImpl(basePackageName, typeDefName, true, false, context);
            String typedefDescription = BindingGeneratorUtil.encodeAngleBrackets((String)typeDef.getDescription());
            genTOBuilder.setDescription(typedefDescription);
            genTOBuilder.setReference(typeDef.getReference());
            genTOBuilder.setSchemaPath((List)typeDef.getPath().getPathFromRoot());
            genTOBuilder.setModuleName(moduleName);
            genTOBuilder.setBaseType(typeDef);
            List bitList = bitsTypeDefinition.getBits();
            for (BitsTypeDefinition.Bit bit : bitList) {
                String name = bit.getName();
                GeneratedPropertyBuilder genPropertyBuilder = genTOBuilder.addProperty(JavaIdentifierNormalizer.normalizeSpecificIdentifier((String)name, (JavaIdentifier)JavaIdentifier.METHOD));
                genPropertyBuilder.setReadOnly(true);
                genPropertyBuilder.setReturnType(BaseYangTypes.BOOLEAN_TYPE);
                genTOBuilder.addEqualsIdentity(genPropertyBuilder);
                genTOBuilder.addHashIdentity(genPropertyBuilder);
                genTOBuilder.addToStringProperty(genPropertyBuilder);
            }
            return genTOBuilder;
        }
        return null;
    }

    public List<GeneratedTOBuilder> provideGeneratedTOBuildersForUnionTypeDef(String basePackageName, UnionTypeDefinition typedef, String typeDefName, SchemaNode parentNode, SchemaContext schemaContext, Map<String, Map<Date, Map<String, Type>>> genTypeDefsContextMap, ModuleContext context) {
        Preconditions.checkNotNull((Object)basePackageName, (Object)"Base Package Name cannot be NULL!");
        Preconditions.checkNotNull((Object)typedef, (Object)"Type Definition cannot be NULL!");
        Preconditions.checkNotNull((Object)typedef.getQName(), (Object)"Type definition QName cannot be NULL!");
        ArrayList<GeneratedTOBuilder> generatedTOBuilders = new ArrayList<GeneratedTOBuilder>();
        List unionTypes = typedef.getTypes();
        Module module = SchemaContextUtil.findParentModule((SchemaContext)schemaContext, (SchemaNode)parentNode);
        GeneratedTOBuilderImpl unionGenTOBuilder = new GeneratedTOBuilderImpl(basePackageName, typeDefName, true, false, context);
        String typedefDescription = BindingGeneratorUtil.encodeAngleBrackets((String)typedef.getDescription());
        unionGenTOBuilder.setDescription(typedefDescription);
        unionGenTOBuilder.setReference(typedef.getReference());
        unionGenTOBuilder.setSchemaPath((List)typedef.getPath().getPathFromRoot());
        unionGenTOBuilder.setModuleName(module.getName());
        generatedTOBuilders.add((GeneratedTOBuilder)unionGenTOBuilder);
        unionGenTOBuilder.setIsUnion(true);
        ArrayList<String> regularExpressions = new ArrayList<String>();
        for (TypeDefinition unionType : unionTypes) {
            String unionTypeName = unionType.getQName().getLocalName();
            if (unionType.getBaseType() != null) {
                TypeProviderImpl.resolveExtendedSubtypeAsUnion((GeneratedTOBuilder)unionGenTOBuilder, unionType, regularExpressions, parentNode, schemaContext, genTypeDefsContextMap);
                continue;
            }
            if (unionType instanceof UnionTypeDefinition) {
                generatedTOBuilders.add(this.resolveUnionSubtypeAsUnion((GeneratedTOBuilder)unionGenTOBuilder, (UnionTypeDefinition)unionType, unionGenTOBuilder.getFullyQualifiedName(), parentNode, schemaContext, genTypeDefsContextMap, context));
                continue;
            }
            if (unionType instanceof EnumTypeDefinition) {
                Enumeration enumeration = TypeProviderImpl.addInnerEnumerationToTypeBuilder((EnumTypeDefinition)unionType, unionTypeName, unionGenTOBuilder, context);
                TypeProviderImpl.updateUnionTypeAsProperty((GeneratedTOBuilder)unionGenTOBuilder, (Type)enumeration, unionTypeName);
                continue;
            }
            Type javaType = this.javaTypeForSchemaDefType(unionType, parentNode, null, schemaContext, genTypeDefsContextMap, context);
            TypeProviderImpl.updateUnionTypeAsProperty((GeneratedTOBuilder)unionGenTOBuilder, javaType, unionTypeName);
        }
        if (!regularExpressions.isEmpty()) {
            TypeGenHelper.addStringRegExAsConstant((GeneratedTOBuilder)unionGenTOBuilder, regularExpressions);
        }
        return generatedTOBuilders;
    }

    public Map<Module, Set<Type>> getAdditionalTypes() {
        return this.additionalTypes;
    }

    public static void addUnitsToGenTO(GeneratedTOBuilder to2, String units) {
        if (!Strings.isNullOrEmpty((String)units)) {
            to2.addConstant((Type)Types.STRING, "_UNITS", (Object)("\"" + units + "\""));
            GeneratedPropertyBuilderImpl prop = new GeneratedPropertyBuilderImpl("UNITS");
            prop.setReturnType((Type)Types.STRING);
            to2.addToStringProperty((GeneratedPropertyBuilder)prop);
        }
    }

    private Type javaTypeForSchemaDefType(TypeDefinition<?> typeDefinition, SchemaNode parentNode, Restrictions r, SchemaContext schemaContext, Map<String, Map<Date, Map<String, Type>>> genTypeDefsContextMap, ModuleContext context) {
        Preconditions.checkArgument((typeDefinition != null ? 1 : 0) != 0, (Object)"Type Definition cannot be NULL!");
        String typedefName = typeDefinition.getQName().getLocalName();
        Preconditions.checkArgument((typedefName != null ? 1 : 0) != 0, (Object)"Type Definitions Local Name cannot be NULL!");
        if (typeDefinition.getBaseType() == null) {
            Type ret;
            if (typeDefinition instanceof DecimalTypeDefinition && (ret = BaseYangTypes.BASE_YANG_TYPES_PROVIDER.javaTypeForSchemaDefinitionType(typeDefinition, parentNode, r, context)) != null) {
                return ret;
            }
            ret = this.javaTypeForLeafrefOrIdentityRef(typeDefinition, parentNode, schemaContext, genTypeDefsContextMap, context);
            if (ret != null) {
                return ret;
            }
            ret = BaseYangTypes.BASE_YANG_TYPES_PROVIDER.javaTypeForSchemaDefinitionType(typeDefinition, parentNode, null);
            if (ret == null) {
                LOG.debug("Failed to resolve Java type for {}", typeDefinition);
            }
            return ret;
        }
        Type returnType = this.javaTypeForExtendedType(typeDefinition, schemaContext, genTypeDefsContextMap, context);
        if (r != null && !r.isEmpty() && returnType instanceof GeneratedTransferObject) {
            GeneratedTransferObject gto = (GeneratedTransferObject)returnType;
            Module module = SchemaContextUtil.findParentModule((SchemaContext)schemaContext, (SchemaNode)parentNode);
            Module module1 = SchemaContextUtil.findParentModule((SchemaContext)schemaContext, typeDefinition);
            String basePackageName = BindingMapping.getRootPackageName((Module)module);
            String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)typeDefinition.getPath(), (BindingNamespaceType)BindingNamespaceType.Typedef);
            String genTOName = JavaIdentifierNormalizer.normalizeSpecificIdentifier((String)typedefName, (JavaIdentifier)JavaIdentifier.CLASS);
            String name = packageName + "." + genTOName;
            if (module.equals(module1) && !returnType.getFullyQualifiedName().equals(name)) {
                returnType = TypeProviderImpl.shadedTOWithRestrictions(gto, r, context);
            }
        }
        return returnType;
    }

    private Type typedefToGeneratedType(String basePackageName, Module module, TypeDefinition<?> typedef, Map<String, Map<Date, Map<String, Type>>> genTypeDefsContextMap, Map<Module, Set<Type>> additionalTypes, SchemaContext schemaContext, ModuleContext context) {
        String moduleName = module.getName();
        Date moduleRevision = module.getRevision();
        if (basePackageName != null && moduleName != null && typedef != null) {
            String typedefName = typedef.getQName().getLocalName();
            TypeDefinition innerTypeDefinition = typedef.getBaseType();
            if (!(innerTypeDefinition instanceof LeafrefTypeDefinition) && !(innerTypeDefinition instanceof IdentityrefTypeDefinition)) {
                GeneratedTransferObject returnType;
                if (innerTypeDefinition.getBaseType() != null) {
                    returnType = TypeGenHelper.provideGeneratedTOFromExtendedType(typedef, innerTypeDefinition, basePackageName, module.getName(), schemaContext, genTypeDefsContextMap, context);
                } else if (innerTypeDefinition instanceof UnionTypeDefinition) {
                    GeneratedTOBuilder genTOBuilder = this.provideGeneratedTOBuilderForUnionTypeDef(basePackageName, (UnionTypeDefinition)innerTypeDefinition, typedefName, (SchemaNode)typedef, schemaContext, genTypeDefsContextMap, context);
                    genTOBuilder.setTypedef(true);
                    genTOBuilder.setIsUnion(true);
                    TypeProviderImpl.addUnitsToGenTO(genTOBuilder, typedef.getUnits());
                    TypeGenHelper.makeSerializable((GeneratedTOBuilderImpl)genTOBuilder);
                    returnType = genTOBuilder.toInstance();
                } else if (innerTypeDefinition instanceof EnumTypeDefinition) {
                    EnumTypeDefinition enumTypeDef = (EnumTypeDefinition)innerTypeDefinition;
                    returnType = TypeGenHelper.provideTypeForEnum(enumTypeDef, typedefName, typedef, schemaContext, context);
                } else if (innerTypeDefinition instanceof BitsTypeDefinition) {
                    BitsTypeDefinition bitsTypeDefinition = (BitsTypeDefinition)innerTypeDefinition;
                    GeneratedTOBuilder genTOBuilder = this.provideGeneratedTOBuilderForBitsTypeDefinition(basePackageName, (TypeDefinition<?>)bitsTypeDefinition, typedefName, module.getName(), context);
                    genTOBuilder.setTypedef(true);
                    TypeProviderImpl.addUnitsToGenTO(genTOBuilder, typedef.getUnits());
                    TypeGenHelper.makeSerializable((GeneratedTOBuilderImpl)genTOBuilder);
                    returnType = genTOBuilder.toInstance();
                } else {
                    Type javaType = this.javaTypeForSchemaDefType((TypeDefinition<?>)innerTypeDefinition, (SchemaNode)typedef, null, schemaContext, genTypeDefsContextMap, context);
                    returnType = TypeGenHelper.wrapJavaTypeIntoTO(basePackageName, typedef, javaType, module.getName(), context);
                }
                if (returnType != null) {
                    Map<Date, Map<String, Type>> modulesByDate = genTypeDefsContextMap.get(moduleName);
                    Map<String, Type> typeMap = modulesByDate.get(moduleRevision);
                    if (typeMap != null) {
                        if (typeMap.isEmpty()) {
                            typeMap = new HashMap<String, Type>(4);
                            modulesByDate.put(moduleRevision, typeMap);
                        }
                        typeMap.put(typedefName, (Type)returnType);
                    }
                    return returnType;
                }
            }
        }
        return null;
    }

    private Type javaTypeForExtendedType(TypeDefinition<?> typeDefinition, SchemaContext schemaContext, Map<String, Map<Date, Map<String, Type>>> genTypeDefsContextMap, ModuleContext context) {
        String typedefName = typeDefinition.getQName().getLocalName();
        TypeDefinition<?> baseTypeDef = TypeGenHelper.baseTypeDefForExtendedType(typeDefinition);
        Type returnType = this.javaTypeForLeafrefOrIdentityRef(baseTypeDef, (SchemaNode)typeDefinition, schemaContext, genTypeDefsContextMap, context);
        if (returnType == null) {
            Module module = SchemaContextUtil.findParentModule((SchemaContext)schemaContext, typeDefinition);
            Restrictions r = BindingGeneratorUtil.getRestrictions(typeDefinition);
            if (module != null) {
                Map<Date, Map<String, Type>> modulesByDate = genTypeDefsContextMap.get(module.getName());
                Map<String, Type> genTOs = modulesByDate.get(module.getRevision());
                if (genTOs != null) {
                    returnType = genTOs.get(typedefName);
                }
                if (returnType == null) {
                    returnType = BaseYangTypes.BASE_YANG_TYPES_PROVIDER.javaTypeForSchemaDefinitionType(baseTypeDef, typeDefinition, r, context);
                }
            }
        }
        return returnType;
    }

    private Type javaTypeForLeafrefOrIdentityRef(TypeDefinition<?> typeDefinition, SchemaNode parentNode, SchemaContext schemaContext, Map<String, Map<Date, Map<String, Type>>> genTypeDefsContextMap, ModuleContext context) {
        if (typeDefinition instanceof LeafrefTypeDefinition) {
            LeafrefTypeDefinition leafref = (LeafrefTypeDefinition)typeDefinition;
            if (TypeProviderImpl.isLeafRefSelfReference(leafref, parentNode, schemaContext)) {
                throw new YangValidationException("Leafref " + leafref.toString() + " is referencing itself, incoming StackOverFlowError detected.");
            }
            return this.provideTypeForLeafref(leafref, parentNode, schemaContext, genTypeDefsContextMap, context);
        }
        if (typeDefinition instanceof IdentityrefTypeDefinition) {
            IdentityrefTypeDefinition idref = (IdentityrefTypeDefinition)typeDefinition;
            return TypeProviderImpl.provideTypeForIdentityref(idref, schemaContext);
        }
        return null;
    }

    public Type provideTypeForLeafref(LeafrefTypeDefinition leafrefType, SchemaNode parentNode, SchemaContext schemaContext, Map<String, Map<Date, Map<String, Type>>> genTypeDefsContextMap, ModuleContext context) {
        Object returnType = null;
        Preconditions.checkArgument((leafrefType != null ? 1 : 0) != 0, (Object)"Leafref Type Definition reference cannot be NULL!");
        Preconditions.checkArgument((leafrefType.getPathStatement() != null ? 1 : 0) != 0, (Object)"The Path Statement for Leafref Type Definition cannot be NULL!");
        RevisionAwareXPath xpath = leafrefType.getPathStatement();
        String strXPath = xpath.toString();
        if (strXPath != null) {
            if (strXPath.indexOf(91) == -1) {
                Module module;
                SchemaNode actualParentSchemaNode;
                if (parentNode instanceof DerivableSchemaNode && ((DerivableSchemaNode)parentNode).isAddedByUses()) {
                    Optional originalNode = ((DerivableSchemaNode)parentNode).getOriginal();
                    Preconditions.checkArgument((boolean)originalNode.isPresent(), (Object)"originalNode can not be null.");
                    actualParentSchemaNode = (SchemaNode)originalNode.get();
                    module = SchemaContextUtil.findParentModule((SchemaContext)schemaContext, (SchemaNode)((SchemaNode)originalNode.get()));
                } else {
                    actualParentSchemaNode = parentNode;
                    module = SchemaContextUtil.findParentModule((SchemaContext)schemaContext, (SchemaNode)parentNode);
                }
                Preconditions.checkArgument((module != null ? 1 : 0) != 0, (String)"Failed to find module for parent %s", (Object[])new Object[]{parentNode});
                SchemaNode dataNode = xpath.isAbsolute() ? SchemaContextUtil.findDataSchemaNode((SchemaContext)schemaContext, (Module)module, (RevisionAwareXPath)xpath) : SchemaContextUtil.findDataSchemaNodeForRelativeXPath((SchemaContext)schemaContext, (Module)module, (SchemaNode)actualParentSchemaNode, (RevisionAwareXPath)xpath);
                Preconditions.checkArgument((dataNode != null ? 1 : 0) != 0, (String)"Failed to find leafref target: %s in module %s (%s)", (Object[])new Object[]{strXPath, TypeGenHelper.getParentModule(parentNode, schemaContext).getName(), parentNode.getQName().getModule()});
                returnType = TypeProviderImpl.leafContainsEnumDefinition(dataNode) ? this.referencedTypes.get(dataNode.getPath()) : (TypeProviderImpl.leafListContainsEnumDefinition(dataNode) ? Types.listTypeFor((Type)this.referencedTypes.get(dataNode.getPath())) : this.resolveTypeFromDataSchemaNode(dataNode, schemaContext, genTypeDefsContextMap, context));
            } else {
                returnType = Types.typeForClass(Object.class);
            }
        }
        Preconditions.checkArgument((returnType != null ? 1 : 0) != 0, (String)"Failed to find leafref target: %s in module %s (%s)", (Object[])new Object[]{strXPath, TypeGenHelper.getParentModule(parentNode, schemaContext).getName(), parentNode.getQName().getModule()});
        return returnType;
    }

    private static boolean leafContainsEnumDefinition(SchemaNode dataNode) {
        LeafSchemaNode leaf;
        return dataNode instanceof LeafSchemaNode && (leaf = (LeafSchemaNode)dataNode).getType() instanceof EnumTypeDefinition;
    }

    private static boolean leafListContainsEnumDefinition(SchemaNode dataNode) {
        LeafListSchemaNode leafList;
        return dataNode instanceof LeafListSchemaNode && (leafList = (LeafListSchemaNode)dataNode).getType() instanceof EnumTypeDefinition;
    }

    private Type resolveTypeFromDataSchemaNode(SchemaNode dataNode, SchemaContext schemaContext, Map<String, Map<Date, Map<String, Type>>> genTypeDefsContextMap, ModuleContext context) {
        Type returnType = null;
        if (dataNode != null) {
            if (dataNode instanceof LeafSchemaNode) {
                LeafSchemaNode leaf = (LeafSchemaNode)dataNode;
                TypeDefinition type = leaf.getType();
                returnType = this.javaTypeForSchemaDefType(type, (SchemaNode)leaf, null, schemaContext, genTypeDefsContextMap, context);
            } else if (dataNode instanceof LeafListSchemaNode) {
                LeafListSchemaNode leafList = (LeafListSchemaNode)dataNode;
                returnType = this.javaTypeForSchemaDefType(leafList.getType(), (SchemaNode)leafList, null, schemaContext, genTypeDefsContextMap, context);
            }
        }
        return returnType;
    }

    private static Type provideTypeForIdentityref(IdentityrefTypeDefinition idref, SchemaContext schemaContext) {
        QName baseIdQName = ((IdentitySchemaNode)idref.getIdentities().iterator().next()).getQName();
        Module module = schemaContext.findModuleByNamespaceAndRevision(baseIdQName.getNamespace(), baseIdQName.getRevision());
        IdentitySchemaNode identity = null;
        for (IdentitySchemaNode id : module.getIdentities()) {
            if (!id.getQName().equals((Object)baseIdQName)) continue;
            identity = id;
        }
        Preconditions.checkArgument((identity != null ? 1 : 0) != 0, (Object)("Target identity '" + baseIdQName + "' do not exists"));
        String basePackageName = BindingMapping.getRootPackageName((Module)module);
        String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)identity.getPath(), (BindingNamespaceType)BindingNamespaceType.Identity);
        String genTypeName = JavaIdentifierNormalizer.normalizeSpecificIdentifier((String)identity.getQName().getLocalName(), (JavaIdentifier)JavaIdentifier.CLASS);
        ConcreteType baseType = Types.typeForClass(Class.class);
        WildcardType paramType = Types.wildcardTypeFor((String)packageName, (String)genTypeName, (boolean)true, (boolean)true, null);
        return Types.parameterizedTypeFor((Type)baseType, (Type[])new Type[]{paramType});
    }

    private static GeneratedTransferObject shadedTOWithRestrictions(GeneratedTransferObject gto, Restrictions r, ModuleContext context) {
        GeneratedTOBuilderImpl gtob = new GeneratedTOBuilderImpl(gto.getPackageName(), gto.getName(), context);
        GeneratedTransferObject parent = gto.getSuperType();
        if (parent != null) {
            gtob.setExtendsType(parent);
        }
        gtob.setRestrictions(r);
        for (GeneratedProperty gp : gto.getProperties()) {
            GeneratedPropertyBuilder gpb = gtob.addProperty(gp.getName());
            gpb.setValue(gp.getValue());
            gpb.setReadOnly(gp.isReadOnly());
            gpb.setAccessModifier(gp.getAccessModifier());
            gpb.setReturnType(gp.getReturnType());
            gpb.setFinal(gp.isFinal());
            gpb.setStatic(gp.isStatic());
        }
        return gtob.toInstance();
    }

    private static void updateUnionTypeAsProperty(GeneratedTOBuilder unionGenTransObject, Type type, String propertyName) {
        if (unionGenTransObject != null && type != null && !unionGenTransObject.containsProperty(propertyName)) {
            GeneratedPropertyBuilder propBuilder = unionGenTransObject.addProperty(JavaIdentifierNormalizer.normalizeSpecificIdentifier((String)propertyName, (JavaIdentifier)JavaIdentifier.METHOD));
            propBuilder.setReturnType(type);
            unionGenTransObject.addEqualsIdentity(propBuilder);
            unionGenTransObject.addHashIdentity(propBuilder);
            unionGenTransObject.addToStringProperty(propBuilder);
        }
    }

    private GeneratedTOBuilder resolveUnionSubtypeAsUnion(GeneratedTOBuilder parentUnionGenTOBuilder, UnionTypeDefinition unionSubtype, String basePackageName, SchemaNode parentNode, SchemaContext schemaContext, Map<String, Map<Date, Map<String, Type>>> genTypeDefsContextMap, ModuleContext context) {
        String newTOBuilderName = TypeProviderImpl.provideAvailableNameForGenTOBuilder(parentUnionGenTOBuilder.getName());
        GeneratedTOBuilder subUnionGenTOBUilder = this.provideGeneratedTOBuilderForUnionTypeDef(basePackageName, unionSubtype, newTOBuilderName, parentNode, schemaContext, genTypeDefsContextMap, context);
        GeneratedPropertyBuilder propertyBuilder = parentUnionGenTOBuilder.addProperty(JavaIdentifierNormalizer.normalizeSpecificIdentifier((String)newTOBuilderName, (JavaIdentifier)JavaIdentifier.METHOD));
        propertyBuilder.setReturnType((Type)subUnionGenTOBUilder);
        parentUnionGenTOBuilder.addEqualsIdentity(propertyBuilder);
        parentUnionGenTOBuilder.addToStringProperty(propertyBuilder);
        return subUnionGenTOBUilder;
    }

    public GeneratedTOBuilder provideGeneratedTOBuilderForUnionTypeDef(String basePackageName, UnionTypeDefinition typedef, String typeDefName, SchemaNode parentNode, SchemaContext schemaContext, Map<String, Map<Date, Map<String, Type>>> genTypeDefsContextMap, ModuleContext context) {
        List<GeneratedTOBuilder> builders = this.provideGeneratedTOBuildersForUnionTypeDef(basePackageName, typedef, typeDefName, parentNode, schemaContext, genTypeDefsContextMap, context);
        Preconditions.checkState((!builders.isEmpty() ? 1 : 0) != 0, (String)"No GeneratedTOBuilder objects generated from union %s", (Object[])new Object[]{typedef});
        GeneratedTOBuilder resultTOBuilder = builders.remove(0);
        for (GeneratedTOBuilder genTOBuilder : builders) {
            resultTOBuilder.addEnclosingTransferObject(genTOBuilder);
        }
        GeneratedPropertyBuilder genPropBuilder = ((GeneratedPropertyBuilder)resultTOBuilder.addProperty("value").setReturnType((Type)Types.CHAR_ARRAY)).setReadOnly(false);
        resultTOBuilder.addEqualsIdentity(genPropBuilder);
        resultTOBuilder.addHashIdentity(genPropBuilder);
        resultTOBuilder.addToStringProperty(genPropBuilder);
        this.provideGeneratedTOBuilderForUnionBuilder(SchemaContextUtil.findParentModule((SchemaContext)schemaContext, (SchemaNode)parentNode), resultTOBuilder);
        return resultTOBuilder;
    }

    private GeneratedTOBuilder provideGeneratedTOBuilderForUnionBuilder(Module parentModule, GeneratedTOBuilder genTOBuilder) {
        String outerCls = Types.getOuterClassName((Type)genTOBuilder);
        StringBuilder name = outerCls != null ? new StringBuilder(outerCls) : new StringBuilder();
        name.append(genTOBuilder.getName());
        name.append("Builder");
        GeneratedTOBuilderImpl unionBuilder = new GeneratedTOBuilderImpl(Types.getOuterClassPackageName((Type)genTOBuilder), name.toString(), true);
        unionBuilder.setIsUnionBuilder(true);
        MethodSignatureBuilder method = unionBuilder.addMethod("getDefaultInstance");
        method.setReturnType((Type)genTOBuilder);
        method.addParameter((Type)Types.STRING, "defaultValue");
        method.setAccessModifier(AccessModifier.PUBLIC);
        method.setStatic(true);
        Set<Type> types = this.getAdditionalTypes().get(parentModule);
        if (types == null) {
            this.getAdditionalTypes().put(parentModule, Sets.newHashSet((Object[])new Type[]{unionBuilder.toInstance()}));
        } else {
            types.add((Type)unionBuilder.toInstance());
        }
        return unionBuilder;
    }

    private static void resolveExtendedSubtypeAsUnion(GeneratedTOBuilder parentUnionGenTOBuilder, TypeDefinition<?> unionSubtype, List<String> regularExpressions, SchemaNode parentNode, SchemaContext schemaContext, Map<String, Map<Date, Map<String, Type>>> genTypeDefsContextMap) {
        String unionTypeName = unionSubtype.getQName().getLocalName();
        Type genTO = TypeProviderImpl.findGenTO(unionTypeName, unionSubtype, schemaContext, genTypeDefsContextMap);
        if (genTO != null) {
            TypeProviderImpl.updateUnionTypeAsProperty(parentUnionGenTOBuilder, genTO, unionTypeName);
        } else {
            Type javaType;
            TypeDefinition<?> baseType = TypeGenHelper.baseTypeDefForExtendedType(unionSubtype);
            if (unionTypeName.equals(baseType.getQName().getLocalName()) && (javaType = BaseYangTypes.BASE_YANG_TYPES_PROVIDER.javaTypeForSchemaDefinitionType(baseType, parentNode, null)) != null) {
                TypeProviderImpl.updateUnionTypeAsProperty(parentUnionGenTOBuilder, javaType, unionTypeName);
            }
            if (baseType instanceof StringTypeDefinition) {
                regularExpressions.addAll(TypeGenHelper.resolveRegExpressionsFromTypedef(unionSubtype));
            }
        }
    }

    private static String provideAvailableNameForGenTOBuilder(String name) {
        Matcher mtch = NUMBERS_PATTERN.matcher(name);
        if (mtch.find()) {
            int newSuffix = Integer.valueOf(name.substring(mtch.start())) + 1;
            return name.substring(0, mtch.start()) + newSuffix;
        }
        return name + 1;
    }

    private static Type findGenTO(String searchedTypeName, SchemaNode parentNode, SchemaContext schemaContext, Map<String, Map<Date, Map<String, Type>>> genTypeDefsContextMap) {
        Map<Date, Map<String, Type>> modulesByDate;
        Map<String, Type> genTOs;
        Module typeModule = SchemaContextUtil.findParentModule((SchemaContext)schemaContext, (SchemaNode)parentNode);
        if (typeModule != null && typeModule.getName() != null && (genTOs = (modulesByDate = genTypeDefsContextMap.get(typeModule.getName())).get(typeModule.getRevision())) != null) {
            return genTOs.get(searchedTypeName);
        }
        return null;
    }

    private static Enumeration addInnerEnumerationToTypeBuilder(EnumTypeDefinition enumTypeDef, String enumName, GeneratedTypeBuilderBase<?> typeBuilder, ModuleContext context) {
        Preconditions.checkArgument((enumTypeDef != null ? 1 : 0) != 0, (Object)"EnumTypeDefinition reference cannot be NULL!");
        Preconditions.checkArgument((enumTypeDef.getQName().getLocalName() != null ? 1 : 0) != 0, (Object)"Local Name in EnumTypeDefinition QName cannot be NULL!");
        Preconditions.checkArgument((typeBuilder != null ? 1 : 0) != 0, (Object)"Generated Type Builder reference cannot be NULL!");
        EnumBuilder enumBuilder = typeBuilder.addEnumeration(enumName, context);
        String enumTypedefDescription = BindingGeneratorUtil.encodeAngleBrackets((String)enumTypeDef.getDescription());
        enumBuilder.setDescription(enumTypedefDescription);
        enumBuilder.updateEnumPairsFromEnumTypeDef(enumTypeDef);
        return enumBuilder.toInstance((Type)enumBuilder);
    }

    private static boolean isLeafRefSelfReference(LeafrefTypeDefinition leafref, SchemaNode parentNode, SchemaContext schemaContext) {
        RevisionAwareXPath leafRefXPath = leafref.getPathStatement();
        RevisionAwareXPathImpl leafRefStrippedXPath = new RevisionAwareXPathImpl(leafRefXPath.toString().replaceAll("\\[(.*?)\\]", ""), leafRefXPath.isAbsolute());
        Iterator iterator2 = parentNode.getPath().getPathFromRoot().iterator();
        boolean isAugmenting = false;
        DataNodeContainer current = null;
        while (iterator2.hasNext() && !isAugmenting) {
            QName next2 = (QName)iterator2.next();
            DataSchemaNode dataChildByName = current == null ? schemaContext.getDataChildByName(next2) : current.getDataChildByName(next2);
            if (dataChildByName == null) {
                return false;
            }
            isAugmenting = dataChildByName.isAugmenting();
            if (!(dataChildByName instanceof DataNodeContainer)) continue;
            current = (DataNodeContainer)dataChildByName;
        }
        if (isAugmenting) {
            return false;
        }
        Module parentModule = TypeGenHelper.getParentModule(parentNode, schemaContext);
        SchemaNode leafRefValueNode = !leafRefStrippedXPath.isAbsolute() ? SchemaContextUtil.findDataSchemaNodeForRelativeXPath((SchemaContext)schemaContext, (Module)parentModule, (SchemaNode)parentNode, (RevisionAwareXPath)leafRefStrippedXPath) : SchemaContextUtil.findDataSchemaNode((SchemaContext)schemaContext, (Module)parentModule, (RevisionAwareXPath)leafRefStrippedXPath);
        return leafRefValueNode != null && leafRefValueNode.equals(parentNode);
    }
}

