/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.javav2.generator.yang.types;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringEscapeUtils;
import org.opendaylight.mdsal.binding.javav2.generator.context.ModuleContext;
import org.opendaylight.mdsal.binding.javav2.generator.util.BindingGeneratorUtil;
import org.opendaylight.mdsal.binding.javav2.generator.util.Types;
import org.opendaylight.mdsal.binding.javav2.generator.util.generated.type.builder.EnumerationBuilderImpl;
import org.opendaylight.mdsal.binding.javav2.generator.util.generated.type.builder.GeneratedPropertyBuilderImpl;
import org.opendaylight.mdsal.binding.javav2.generator.util.generated.type.builder.GeneratedTOBuilderImpl;
import org.opendaylight.mdsal.binding.javav2.generator.yang.types.BaseYangTypes;
import org.opendaylight.mdsal.binding.javav2.generator.yang.types.TypeProviderImpl;
import org.opendaylight.mdsal.binding.javav2.model.api.ConcreteType;
import org.opendaylight.mdsal.binding.javav2.model.api.Enumeration;
import org.opendaylight.mdsal.binding.javav2.model.api.GeneratedTransferObject;
import org.opendaylight.mdsal.binding.javav2.model.api.Restrictions;
import org.opendaylight.mdsal.binding.javav2.model.api.Type;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.javav2.spec.runtime.BindingNamespaceType;
import org.opendaylight.mdsal.binding.javav2.util.BindingMapping;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.ActionNodeContainer;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;

@Beta
final class TypeGenHelper {
    private TypeGenHelper() {
        throw new UnsupportedOperationException("Util class");
    }

    static TypeDefinition<?> baseTypeDefForExtendedType(TypeDefinition<?> extendTypeDef) {
        Preconditions.checkArgument((extendTypeDef != null ? 1 : 0) != 0, (Object)"Type Definition reference cannot be NULL!");
        TypeDefinition ret = extendTypeDef;
        while (ret.getBaseType() != null) {
            ret = ret.getBaseType();
        }
        return ret;
    }

    static GeneratedTransferObject provideGeneratedTOFromExtendedType(TypeDefinition<?> typedef, TypeDefinition<?> innerExtendedType, String basePackageName, String moduleName, SchemaContext schemaContext, Map<String, Map<Date, Map<String, Type>>> genTypeDefsContextMap, ModuleContext context) {
        Type type;
        Preconditions.checkArgument((innerExtendedType != null ? 1 : 0) != 0, (Object)"Extended type cannot be NULL!");
        Preconditions.checkArgument((basePackageName != null ? 1 : 0) != 0, (Object)"String with base package name cannot be NULL!");
        String typedefName = typedef.getQName().getLocalName();
        String innerTypeDef = innerExtendedType.getQName().getLocalName();
        GeneratedTOBuilderImpl genTOBuilder = new GeneratedTOBuilderImpl(basePackageName, typedefName, context);
        String typedefDescription = BindingGeneratorUtil.encodeAngleBrackets((String)typedef.getDescription());
        genTOBuilder.setDescription(typedefDescription);
        genTOBuilder.setReference(typedef.getReference());
        genTOBuilder.setSchemaPath((List)typedef.getPath().getPathFromRoot());
        genTOBuilder.setModuleName(moduleName);
        genTOBuilder.setTypedef(true);
        Restrictions r = BindingGeneratorUtil.getRestrictions(typedef);
        genTOBuilder.setRestrictions(r);
        if (typedef.getStatus() == Status.DEPRECATED) {
            genTOBuilder.addAnnotation("", "Deprecated");
        }
        if (TypeGenHelper.baseTypeDefForExtendedType(innerExtendedType) instanceof UnionTypeDefinition) {
            genTOBuilder.setIsUnion(true);
        }
        Map<Date, Map<String, Type>> modulesByDate = null;
        Map<String, Type> typeMap = null;
        Module parentModule = SchemaContextUtil.findParentModule((SchemaContext)schemaContext, innerExtendedType);
        if (parentModule != null) {
            modulesByDate = genTypeDefsContextMap.get(parentModule.getName());
            typeMap = modulesByDate.get(parentModule.getRevision());
        }
        if (typeMap != null && (type = (Type)typeMap.get(innerTypeDef)) instanceof GeneratedTransferObject) {
            genTOBuilder.setExtendsType((GeneratedTransferObject)type);
        }
        TypeProviderImpl.addUnitsToGenTO((GeneratedTOBuilder)genTOBuilder, typedef.getUnits());
        TypeGenHelper.makeSerializable(genTOBuilder);
        return genTOBuilder.toInstance();
    }

    static GeneratedTransferObject wrapJavaTypeIntoTO(String basePackageName, TypeDefinition<?> typedef, Type javaType, String moduleName, ModuleContext context) {
        Preconditions.checkNotNull((Object)javaType, (Object)"javaType cannot be null");
        String propertyName = "value";
        GeneratedTOBuilderImpl genTOBuilder = TypeGenHelper.typedefToTransferObject(basePackageName, typedef, moduleName, context);
        genTOBuilder.setRestrictions(BindingGeneratorUtil.getRestrictions(typedef));
        GeneratedPropertyBuilder genPropBuilder = genTOBuilder.addProperty("value");
        genPropBuilder.setReturnType(javaType);
        genTOBuilder.addEqualsIdentity(genPropBuilder);
        genTOBuilder.addHashIdentity(genPropBuilder);
        genTOBuilder.addToStringProperty(genPropBuilder);
        if (typedef.getStatus() == Status.DEPRECATED) {
            genTOBuilder.addAnnotation("", "Deprecated");
        }
        if (javaType instanceof ConcreteType && "String".equals(javaType.getName()) && typedef.getBaseType() != null) {
            List<String> regExps = TypeGenHelper.resolveRegExpressionsFromTypedef(typedef);
            TypeGenHelper.addStringRegExAsConstant((GeneratedTOBuilder)genTOBuilder, regExps);
        }
        TypeProviderImpl.addUnitsToGenTO((GeneratedTOBuilder)genTOBuilder, typedef.getUnits());
        genTOBuilder.setTypedef(true);
        TypeGenHelper.makeSerializable(genTOBuilder);
        return genTOBuilder.toInstance();
    }

    static List<String> resolveRegExpressionsFromTypedef(TypeDefinition<?> typedef) {
        Preconditions.checkArgument((typedef != null ? 1 : 0) != 0, (Object)"typedef can't be null");
        List patternConstraints = typedef instanceof StringTypeDefinition ? ((StringTypeDefinition)typedef).getPatternConstraints() : ImmutableList.of();
        ArrayList<String> regExps = new ArrayList<String>(patternConstraints.size());
        Iterator iterator2 = patternConstraints.iterator();
        while (iterator2.hasNext()) {
            PatternConstraint patternConstraint = (PatternConstraint)iterator2.next();
            String regEx = patternConstraint.getRegularExpression();
            String modifiedRegEx = StringEscapeUtils.escapeJava((String)regEx);
            regExps.add(modifiedRegEx);
        }
        return regExps;
    }

    static List<TypeDefinition<?>> sortTypeDefinitionAccordingDepth(Collection<TypeDefinition<?>> unsortedTypeDefinitions) {
        ArrayList sortedTypeDefinition = new ArrayList();
        TreeMap<Integer, List> typeDefinitionsDepths = new TreeMap<Integer, List>();
        for (TypeDefinition<?> unsortedTypeDefinition : unsortedTypeDefinitions) {
            int depth = TypeGenHelper.getTypeDefinitionDepth(unsortedTypeDefinition);
            List typeDefinitionsConcreteDepth = typeDefinitionsDepths.computeIfAbsent(depth, k -> new ArrayList());
            typeDefinitionsConcreteDepth.add(unsortedTypeDefinition);
        }
        typeDefinitionsDepths.values().forEach(sortedTypeDefinition::addAll);
        return sortedTypeDefinition;
    }

    static void addStringRegExAsConstant(GeneratedTOBuilder genTOBuilder, List<String> regularExpressions) {
        if (genTOBuilder == null) {
            throw new IllegalArgumentException("Generated transfer object builder can't be null");
        }
        if (regularExpressions == null) {
            throw new IllegalArgumentException("List of regular expressions can't be null");
        }
        if (!regularExpressions.isEmpty()) {
            genTOBuilder.addConstant((Type)Types.listTypeFor((Type)BaseYangTypes.STRING_TYPE), "PATTERN_CONSTANTS", regularExpressions);
        }
    }

    private static int getTypeDefinitionDepth(TypeDefinition<?> typeDefinition) {
        if (typeDefinition == null) {
            return 1;
        }
        TypeDefinition baseType = typeDefinition.getBaseType();
        if (baseType == null) {
            return 1;
        }
        int depth = 1;
        if (baseType.getBaseType() != null) {
            depth += TypeGenHelper.getTypeDefinitionDepth(baseType);
        } else if (baseType instanceof UnionTypeDefinition) {
            List childTypeDefinitions = ((UnionTypeDefinition)baseType).getTypes();
            int maxChildDepth = 0;
            int childDepth = 1;
            for (TypeDefinition childTypeDefinition : childTypeDefinitions) {
                if ((childDepth += TypeGenHelper.getTypeDefinitionDepth(childTypeDefinition)) <= maxChildDepth) continue;
                maxChildDepth = childDepth;
            }
            return maxChildDepth;
        }
        return depth;
    }

    static List<TypeDefinition<?>> getAllTypedefs(Module module) {
        ArrayList ret = new ArrayList();
        TypeGenHelper.fillRecursively(ret, (DataNodeContainer)module);
        Set notifications = module.getNotifications();
        for (Object notificationDefinition : notifications) {
            TypeGenHelper.fillRecursively(ret, (DataNodeContainer)notificationDefinition);
        }
        Set rpcs = module.getRpcs();
        for (RpcDefinition rpcDefinition : rpcs) {
            ContainerSchemaNode output;
            ret.addAll(rpcDefinition.getTypeDefinitions());
            ContainerSchemaNode input2 = rpcDefinition.getInput();
            if (input2 != null) {
                TypeGenHelper.fillRecursively(ret, (DataNodeContainer)input2);
            }
            if ((output = rpcDefinition.getOutput()) == null) continue;
            TypeGenHelper.fillRecursively(ret, (DataNodeContainer)output);
        }
        Collection potentials = module.getChildNodes();
        for (DataSchemaNode potential : potentials) {
            if (!(potential instanceof ActionNodeContainer)) continue;
            Set actions = ((ActionNodeContainer)potential).getActions();
            for (ActionDefinition action : actions) {
                ContainerSchemaNode output;
                ContainerSchemaNode input3 = action.getInput();
                if (input3 != null) {
                    TypeGenHelper.fillRecursively(ret, (DataNodeContainer)input3);
                }
                if ((output = action.getOutput()) == null) continue;
                TypeGenHelper.fillRecursively(ret, (DataNodeContainer)output);
            }
        }
        return ret;
    }

    private static void fillRecursively(List<TypeDefinition<?>> list, DataNodeContainer container) {
        Collection childNodes = container.getChildNodes();
        if (childNodes != null) {
            childNodes.stream().filter(childNode -> !childNode.isAugmenting()).forEach(childNode -> {
                Set cases;
                if (childNode instanceof ContainerSchemaNode) {
                    TypeGenHelper.fillRecursively(list, (DataNodeContainer)((ContainerSchemaNode)childNode));
                } else if (childNode instanceof ListSchemaNode) {
                    TypeGenHelper.fillRecursively(list, (DataNodeContainer)((ListSchemaNode)childNode));
                } else if (childNode instanceof ChoiceSchemaNode && (cases = ((ChoiceSchemaNode)childNode).getCases()) != null) {
                    for (ChoiceCaseNode caseNode : cases) {
                        TypeGenHelper.fillRecursively(list, (DataNodeContainer)caseNode);
                    }
                }
            });
        }
        list.addAll(container.getTypeDefinitions());
        Set groupings = container.getGroupings();
        if (groupings != null) {
            for (GroupingDefinition grouping : groupings) {
                TypeGenHelper.fillRecursively(list, (DataNodeContainer)grouping);
            }
        }
    }

    static void makeSerializable(GeneratedTOBuilderImpl gto) {
        gto.addImplementsType((Type)Types.typeForClass(Serializable.class));
        GeneratedPropertyBuilderImpl prop = new GeneratedPropertyBuilderImpl("serialVersionUID");
        prop.setValue(Long.toString(BindingGeneratorUtil.computeDefaultSUID((GeneratedTypeBuilderBase)gto)));
        gto.setSUID((GeneratedPropertyBuilder)prop);
    }

    static Enumeration provideTypeForEnum(EnumTypeDefinition enumTypeDef, String enumName, SchemaNode parentNode, SchemaContext schemaContext, ModuleContext context) {
        Preconditions.checkArgument((enumTypeDef != null ? 1 : 0) != 0, (Object)"EnumTypeDefinition reference cannot be NULL!");
        Preconditions.checkArgument((enumTypeDef.getQName().getLocalName() != null ? 1 : 0) != 0, (Object)"Local Name in EnumTypeDefinition QName cannot be NULL!");
        Module module = SchemaContextUtil.findParentModule((SchemaContext)schemaContext, (SchemaNode)parentNode);
        String basePackageName = BindingMapping.getRootPackageName((Module)module);
        String packageName = parentNode instanceof TypeDefinition ? BindingGeneratorUtil.packageNameWithNamespacePrefix((String)BindingMapping.getRootPackageName((Module)module), (BindingNamespaceType)BindingNamespaceType.Typedef) : basePackageName;
        EnumerationBuilderImpl enumBuilder = new EnumerationBuilderImpl(packageName, enumName, context);
        String enumTypedefDescription = BindingGeneratorUtil.encodeAngleBrackets((String)enumTypeDef.getDescription());
        enumBuilder.setDescription(enumTypedefDescription);
        enumBuilder.setReference(enumTypeDef.getReference());
        enumBuilder.setModuleName(module.getName());
        enumBuilder.setSchemaPath((List)enumTypeDef.getPath().getPathFromRoot());
        enumBuilder.updateEnumPairsFromEnumTypeDef(enumTypeDef);
        return enumBuilder.toInstance(null);
    }

    private static GeneratedTOBuilderImpl typedefToTransferObject(String basePackageName, TypeDefinition<?> typedef, String moduleName, ModuleContext context) {
        String typeDefTOName = typedef.getQName().getLocalName();
        if (basePackageName != null && typeDefTOName != null) {
            GeneratedTOBuilderImpl newType = new GeneratedTOBuilderImpl(basePackageName, typeDefTOName, context);
            String typedefDescription = BindingGeneratorUtil.encodeAngleBrackets((String)typedef.getDescription());
            newType.setDescription(typedefDescription);
            newType.setReference(typedef.getReference());
            newType.setSchemaPath((List)typedef.getPath().getPathFromRoot());
            newType.setModuleName(moduleName);
            return newType;
        }
        return null;
    }

    static Module getParentModule(SchemaNode node, SchemaContext schemaContext) {
        QName qname = (QName)node.getPath().getPathFromRoot().iterator().next();
        URI namespace = qname.getNamespace();
        Date revision = qname.getRevision();
        return schemaContext.findModuleByNamespaceAndRevision(namespace, revision);
    }
}

