/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.javav2.generator.yang.types;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import org.opendaylight.mdsal.binding.javav2.generator.context.ModuleContext;
import org.opendaylight.mdsal.binding.javav2.generator.spi.TypeProvider;
import org.opendaylight.mdsal.binding.javav2.generator.util.JavaIdentifier;
import org.opendaylight.mdsal.binding.javav2.generator.util.JavaIdentifierNormalizer;
import org.opendaylight.mdsal.binding.javav2.generator.util.Types;
import org.opendaylight.mdsal.binding.javav2.model.api.Restrictions;
import org.opendaylight.mdsal.binding.javav2.model.api.Type;
import org.opendaylight.mdsal.binding.javav2.spec.base.InstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;

public final class BaseYangTypes {
    private static final Map<String, Type> TYPE_MAP;
    public static final Type BINARY_TYPE;
    public static final Type BOOLEAN_TYPE;
    public static final Type DECIMAL64_TYPE;
    public static final Type EMPTY_TYPE;
    public static final Type ENUM_TYPE;
    public static final Type INSTANCE_IDENTIFIER;
    public static final Type INT8_TYPE;
    public static final Type INT16_TYPE;
    public static final Type INT32_TYPE;
    public static final Type INT64_TYPE;
    public static final Type STRING_TYPE;
    public static final Type UINT8_TYPE;
    public static final Type UINT16_TYPE;
    public static final Type UINT32_TYPE;
    public static final Type UINT64_TYPE;
    public static final Type UNION_TYPE;
    public static final TypeProvider BASE_YANG_TYPES_PROVIDER;

    private BaseYangTypes() {
        throw new UnsupportedOperationException();
    }

    private static <T extends Number> Restrictions singleRangeRestrictions(T min2, T max2) {
        return Types.getDefaultRestrictions(min2, max2);
    }

    static {
        BINARY_TYPE = Types.primitiveType((String)"byte[]", null);
        BOOLEAN_TYPE = Types.typeForClass(Boolean.class);
        DECIMAL64_TYPE = Types.typeForClass(BigDecimal.class);
        EMPTY_TYPE = Types.typeForClass(Boolean.class);
        ENUM_TYPE = Types.typeForClass(Enum.class);
        INSTANCE_IDENTIFIER = Types.parameterizedTypeFor((Type)Types.typeForClass(InstanceIdentifier.class), (Type[])new Type[0]);
        INT8_TYPE = Types.typeForClass(Byte.class);
        INT16_TYPE = Types.typeForClass(Short.class);
        INT32_TYPE = Types.typeForClass(Integer.class);
        INT64_TYPE = Types.typeForClass(Long.class);
        STRING_TYPE = Types.typeForClass(String.class);
        UINT8_TYPE = Types.typeForClass(Short.class, (Restrictions)BaseYangTypes.singleRangeRestrictions((short)0, (short)255));
        UINT16_TYPE = Types.typeForClass(Integer.class, (Restrictions)BaseYangTypes.singleRangeRestrictions(0, 65535));
        UINT32_TYPE = Types.typeForClass(Long.class, (Restrictions)BaseYangTypes.singleRangeRestrictions(0L, 0xFFFFFFFFL));
        UINT64_TYPE = Types.typeForClass(BigInteger.class, (Restrictions)BaseYangTypes.singleRangeRestrictions(BigInteger.ZERO, new BigInteger("18446744073709551615")));
        UNION_TYPE = new UnionType();
        ImmutableMap.Builder b = ImmutableMap.builder();
        b.put((Object)"binary", (Object)BINARY_TYPE);
        b.put((Object)"boolean", (Object)BOOLEAN_TYPE);
        b.put((Object)"decimal64", (Object)DECIMAL64_TYPE);
        b.put((Object)"empty", (Object)EMPTY_TYPE);
        b.put((Object)"enumeration", (Object)ENUM_TYPE);
        b.put((Object)"instance-identifier", (Object)INSTANCE_IDENTIFIER);
        b.put((Object)"int8", (Object)INT8_TYPE);
        b.put((Object)"int16", (Object)INT16_TYPE);
        b.put((Object)"int32", (Object)INT32_TYPE);
        b.put((Object)"int64", (Object)INT64_TYPE);
        b.put((Object)"string", (Object)STRING_TYPE);
        b.put((Object)"uint8", (Object)UINT8_TYPE);
        b.put((Object)"uint16", (Object)UINT16_TYPE);
        b.put((Object)"uint32", (Object)UINT32_TYPE);
        b.put((Object)"uint64", (Object)UINT64_TYPE);
        b.put((Object)"union", (Object)UNION_TYPE);
        TYPE_MAP = b.build();
        BASE_YANG_TYPES_PROVIDER = new TypeProvider(){

            public Type javaTypeForSchemaDefinitionType(TypeDefinition<?> type, SchemaNode parentNode, ModuleContext context) {
                if (type != null) {
                    return (Type)TYPE_MAP.get(type.getQName().getLocalName());
                }
                return null;
            }

            public Type javaTypeForSchemaDefinitionType(TypeDefinition<?> type, SchemaNode parentNode, Restrictions restrictions, ModuleContext context) {
                String typeName;
                switch (typeName = type.getQName().getLocalName()) {
                    case "binary": {
                        return restrictions == null ? Types.BYTE_ARRAY : Types.primitiveType((String)"byte[]", (Restrictions)restrictions);
                    }
                    case "decimal64": {
                        return Types.typeForClass(BigDecimal.class, (Restrictions)restrictions, (ModuleContext)context);
                    }
                    case "enumeration": {
                        return Types.typeForClass(Enum.class, (Restrictions)restrictions, (ModuleContext)context);
                    }
                    case "int8": {
                        return Types.typeForClass(Byte.class, (Restrictions)restrictions, (ModuleContext)context);
                    }
                    case "int16": {
                        return Types.typeForClass(Short.class, (Restrictions)restrictions, (ModuleContext)context);
                    }
                    case "int32": {
                        return Types.typeForClass(Integer.class, (Restrictions)restrictions, (ModuleContext)context);
                    }
                    case "int64": {
                        return Types.typeForClass(Long.class, (Restrictions)restrictions, (ModuleContext)context);
                    }
                    case "string": {
                        return Types.typeForClass(String.class, (Restrictions)restrictions, (ModuleContext)context);
                    }
                    case "uint8": {
                        return Types.typeForClass(Short.class, (Restrictions)restrictions, (ModuleContext)context);
                    }
                    case "uint16": {
                        return Types.typeForClass(Integer.class, (Restrictions)restrictions, (ModuleContext)context);
                    }
                    case "uint32": {
                        return Types.typeForClass(Long.class, (Restrictions)restrictions, (ModuleContext)context);
                    }
                    case "uint64": {
                        return Types.typeForClass(BigInteger.class, (Restrictions)restrictions, (ModuleContext)context);
                    }
                    case "union": {
                        return UNION_TYPE;
                    }
                }
                return this.javaTypeForSchemaDefinitionType(type, parentNode, context);
            }

            public String getTypeDefaultConstruction(LeafSchemaNode node) {
                return null;
            }

            public String getConstructorPropertyName(SchemaNode node) {
                return null;
            }

            public String getParamNameFromType(TypeDefinition<?> type) {
                return JavaIdentifierNormalizer.normalizeSpecificIdentifier((String)type.getQName().getLocalName(), (JavaIdentifier)JavaIdentifier.METHOD);
            }
        };
    }

    public static final class UnionType
    implements Type {
        public String getPackageName() {
            return "org.opendaylight.mdsal.gen.javav2";
        }

        public String getName() {
            return "Union";
        }

        public String getFullyQualifiedName() {
            return "Union";
        }
    }
}

