/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.javav2.generator.impl.util;

import com.google.common.annotations.Beta;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.StringTokenizer;
import org.opendaylight.mdsal.binding.javav2.generator.util.Types;
import org.opendaylight.mdsal.binding.javav2.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.javav2.model.api.ParameterizedType;
import org.opendaylight.mdsal.binding.javav2.model.api.Type;
import org.opendaylight.mdsal.binding.javav2.model.api.WildcardType;
import org.opendaylight.yangtools.yang.common.QName;

@Beta
public final class YangTextTemplate {
    private static final CharMatcher NEWLINE_OR_TAB = CharMatcher.anyOf((CharSequence)"\n\t");
    private static final String DOT = ".";
    private static final String COMMA = ",";
    private static final char NEW_LINE = '\n';
    private static final CharMatcher NL_MATCHER = CharMatcher.is((char)'\n');
    private static final CharMatcher AMP_MATCHER = CharMatcher.is((char)'&');
    private static final Splitter NL_SPLITTER = Splitter.on((CharMatcher)NL_MATCHER);

    private YangTextTemplate() {
        throw new UnsupportedOperationException("Util class");
    }

    public static String formatSchemaPath(String moduleName, Iterable<QName> schemaPath) {
        StringBuilder sb = new StringBuilder();
        sb.append(moduleName);
        QName currentElement = (QName)Iterables.getFirst(schemaPath, null);
        for (QName pathElement : schemaPath) {
            sb.append('/');
            if (!currentElement.getNamespace().equals(pathElement.getNamespace())) {
                currentElement = pathElement;
                sb.append(pathElement);
                continue;
            }
            sb.append(pathElement.getLocalName());
        }
        return sb.toString();
    }

    public static String formatToParagraph(String text2, int nextLineIndent) {
        if (Strings.isNullOrEmpty((String)text2)) {
            return "";
        }
        boolean isFirstElementOnNewLineEmptyChar = false;
        StringBuilder sb = new StringBuilder();
        StringBuilder lineBuilder = new StringBuilder();
        String lineIndent = Strings.repeat((String)" ", (int)nextLineIndent);
        String textToFormat = NEWLINE_OR_TAB.removeFrom((CharSequence)text2);
        String formattedText = textToFormat.replaceAll(" +", " ");
        StringTokenizer tokenizer = new StringTokenizer(formattedText, " ", true);
        while (tokenizer.hasMoreElements()) {
            String nextElement = tokenizer.nextElement().toString();
            if (lineBuilder.length() + nextElement.length() > 80) {
                for (int i = lineBuilder.length() - 1; i >= 0 && lineBuilder.charAt(i) != ' '; --i) {
                    lineBuilder.setLength(i);
                }
                while (lineBuilder.charAt(0) == ' ') {
                    lineBuilder.deleteCharAt(0);
                }
                sb.append((CharSequence)lineBuilder).append('\n');
                lineBuilder.setLength(0);
                if (nextLineIndent > 0) {
                    sb.append(lineIndent);
                }
                if (" ".equals(nextElement)) {
                    isFirstElementOnNewLineEmptyChar = true;
                }
            }
            if (isFirstElementOnNewLineEmptyChar) {
                isFirstElementOnNewLineEmptyChar = false;
                continue;
            }
            lineBuilder.append(nextElement);
        }
        return sb.append((CharSequence)lineBuilder).append('\n').toString();
    }

    public static String formatToAugmentPath(Iterable<QName> schemaPath) {
        StringBuilder sb = new StringBuilder();
        for (QName pathElement : schemaPath) {
            sb.append('/').append(pathElement.getLocalName());
        }
        return sb.toString();
    }

    public static void putTypeIntoImports(GeneratedType parentGenType, Type type, Map<String, String> imports) {
        ParameterizedType paramType;
        Type[] params;
        Preconditions.checkArgument((parentGenType != null ? 1 : 0) != 0, (Object)"Parent Generated Type parameter MUST be specified and cannot be NULL!");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type parameter MUST be specified and cannot be NULL!");
        Preconditions.checkArgument((parentGenType.getPackageName() != null ? 1 : 0) != 0, (Object)"Parent Generated Type cannot have Package Name referenced as NULL!");
        String typeName = (String)Preconditions.checkNotNull((Object)type.getName());
        String typePackageName = (String)Preconditions.checkNotNull((Object)type.getPackageName());
        String parentTypeName = (String)Preconditions.checkNotNull((Object)parentGenType.getName());
        if (typeName.equals(parentTypeName) || typePackageName.startsWith("java.lang") || typePackageName.isEmpty()) {
            return;
        }
        if (!imports.containsKey(typeName)) {
            imports.put(typeName, typePackageName);
        }
        if (type instanceof ParameterizedType && (params = (paramType = (ParameterizedType)type).getActualTypeArguments()) != null) {
            for (Type param2 : params) {
                YangTextTemplate.putTypeIntoImports(parentGenType, param2, imports);
            }
        }
    }

    public static String getExplicitType(GeneratedType parentGenType, Type type, Map<String, String> imports) {
        StringBuilder builder;
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type parameter MUST be specified and cannot be NULL!");
        Preconditions.checkArgument((imports != null ? 1 : 0) != 0, (Object)"Imports Map cannot be NULL!");
        String typePackageName = (String)Preconditions.checkNotNull((Object)type.getPackageName());
        String typeName = (String)Preconditions.checkNotNull((Object)type.getName());
        String importedPackageName = imports.get(typeName);
        if (typePackageName.equals(importedPackageName)) {
            builder = new StringBuilder(typeName);
            YangTextTemplate.addActualTypeParameters(builder, type, parentGenType, imports);
            if ("Void".equals(builder.toString())) {
                return "void";
            }
        } else {
            builder = new StringBuilder();
            if (!typePackageName.isEmpty()) {
                builder.append(typePackageName + DOT + typeName);
            } else {
                builder.append(type.getName());
            }
            if (type.equals(Types.voidType())) {
                return "void";
            }
            YangTextTemplate.addActualTypeParameters(builder, type, parentGenType, imports);
        }
        return builder.toString();
    }

    private static StringBuilder addActualTypeParameters(StringBuilder builder, Type type, GeneratedType parentGenType, Map<String, String> imports) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type[] pTypes = pType.getActualTypeArguments();
            builder.append("<");
            builder.append(YangTextTemplate.getParameters(parentGenType, pTypes, imports));
            builder.append(">");
        }
        return builder;
    }

    private static String getParameters(GeneratedType parentGenType, Type[] pTypes, Map<String, String> availableImports) {
        if (pTypes == null || pTypes.length == 0) {
            return "?";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < pTypes.length; ++i) {
            Type t = pTypes[i];
            String separator = COMMA;
            if (i == pTypes.length - 1) {
                separator = "";
            }
            String wildcardParam = "";
            if (t.equals(Types.voidType())) {
                builder.append("java.lang.Void").append(separator);
                continue;
            }
            if (t instanceof WildcardType) {
                wildcardParam = "? extends ";
            }
            builder.append(wildcardParam).append(YangTextTemplate.getExplicitType(parentGenType, t, availableImports) + separator);
        }
        return builder.toString();
    }

    public static String wrapToDocumentation(String text2) {
        if (text2.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("/**");
        sb.append('\n');
        Iterable lineSplitText = NL_SPLITTER.split((CharSequence)text2);
        for (String t : lineSplitText) {
            sb.append(" *");
            if (t.isEmpty()) {
                sb.append(" ");
                sb.append(t);
            }
            sb.append('\n');
        }
        sb.append(" */");
        return sb.toString();
    }

    public static String encodeJavadocSymbols(String description) {
        if (Strings.isNullOrEmpty((String)description)) {
            return description;
        }
        String ret = description.replace("*/", "&#42;&#47;");
        return AMP_MATCHER.replaceFrom((CharSequence)ret, (CharSequence)"&amp;");
    }
}

