/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.javav2.generator.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.opendaylight.mdsal.binding.javav2.generator.context.ModuleContext;
import org.opendaylight.mdsal.binding.javav2.generator.impl.AuxiliaryGenUtils;
import org.opendaylight.mdsal.binding.javav2.generator.impl.GenHelperUtil;
import org.opendaylight.mdsal.binding.javav2.generator.spi.TypeProvider;
import org.opendaylight.mdsal.binding.javav2.generator.util.BindingGeneratorUtil;
import org.opendaylight.mdsal.binding.javav2.generator.util.BindingTypes;
import org.opendaylight.mdsal.binding.javav2.generator.util.Types;
import org.opendaylight.mdsal.binding.javav2.model.api.GeneratedTransferObject;
import org.opendaylight.mdsal.binding.javav2.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.javav2.model.api.Type;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.mdsal.binding.javav2.spec.runtime.BindingNamespaceType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.ActionNodeContainer;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.OperationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;

@Beta
final class RpcActionGenHelper {
    private static final QName CONTEXT_REFERENCE = QName.create((String)"urn:opendaylight:yang:extension:yang-ext", (String)"2013-07-09", (String)"context-reference").intern();

    private RpcActionGenHelper() {
        throw new UnsupportedOperationException("Util class");
    }

    private static Optional<QName> getRoutingContext(DataSchemaNode schemaNode) {
        for (UnknownSchemaNode extension2 : schemaNode.getUnknownSchemaNodes()) {
            if (!CONTEXT_REFERENCE.equals((Object)extension2.getNodeType())) continue;
            return Optional.fromNullable((Object)extension2.getQName());
        }
        return Optional.absent();
    }

    private static void resolveActions(DataNodeContainer parent, Module module, SchemaContext schemaContext, boolean verboseClassComments, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, Map<Module, ModuleContext> genCtx, TypeProvider typeProvider, BindingNamespaceType namespaceType) {
        Preconditions.checkNotNull((Object)parent, (Object)"Parent should not be NULL.");
        Collection potentials = parent.getChildNodes();
        for (DataSchemaNode potential : potentials) {
            if (!GenHelperUtil.resolveDataSchemaNodesCheck(module, schemaContext, potential)) continue;
            BindingNamespaceType namespaceType1 = namespaceType;
            if (namespaceType.equals((Object)BindingNamespaceType.Data) && potential instanceof GroupingDefinition) {
                namespaceType1 = BindingNamespaceType.Grouping;
            }
            if (potential instanceof ActionNodeContainer) {
                Set actions = ((ActionNodeContainer)potential).getActions();
                for (ActionDefinition action : actions) {
                    genCtx.get(module).addTopLevelNodeType(RpcActionGenHelper.resolveOperation(potential, (OperationDefinition)action, module, schemaContext, verboseClassComments, genTypeBuilders, genCtx, typeProvider, true, namespaceType1));
                }
            }
            if (!(potential instanceof DataNodeContainer)) continue;
            RpcActionGenHelper.resolveActions((DataNodeContainer)potential, module, schemaContext, verboseClassComments, genTypeBuilders, genCtx, typeProvider, namespaceType1);
        }
    }

    static Map<Module, ModuleContext> actionMethodsToGenType(Module module, Map<Module, ModuleContext> genCtx, SchemaContext schemaContext, boolean verboseClassComments, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, TypeProvider typeProvider) {
        AuxiliaryGenUtils.checkModuleAndModuleName(module);
        RpcActionGenHelper.resolveActions((DataNodeContainer)module, module, schemaContext, verboseClassComments, genTypeBuilders, genCtx, typeProvider, BindingNamespaceType.Data);
        return genCtx;
    }

    static Map<Module, ModuleContext> rpcMethodsToGenType(Module module, Map<Module, ModuleContext> genCtx, SchemaContext schemaContext, boolean verboseClassComments, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, TypeProvider typeProvider) {
        AuxiliaryGenUtils.checkModuleAndModuleName(module);
        Set rpcDefinitions = module.getRpcs();
        Preconditions.checkState((rpcDefinitions != null ? 1 : 0) != 0, (Object)("Set of RPCs from module " + module.getName() + " cannot be NULL."));
        if (rpcDefinitions.isEmpty()) {
            return genCtx;
        }
        for (RpcDefinition rpc : rpcDefinitions) {
            DataSchemaNode parent = null;
            ContainerSchemaNode input2 = rpc.getInput();
            boolean isAction = false;
            if (input2 != null) {
                for (DataSchemaNode schemaNode : input2.getChildNodes()) {
                    if (!RpcActionGenHelper.getRoutingContext(schemaNode).isPresent()) continue;
                    isAction = true;
                    break;
                }
            }
            if (isAction) {
                genCtx.get(module).addTopLevelNodeType(RpcActionGenHelper.resolveOperation(parent, (OperationDefinition)rpc, module, schemaContext, verboseClassComments, genTypeBuilders, genCtx, typeProvider, true, BindingNamespaceType.Data));
                continue;
            }
            genCtx.get(module).addTopLevelNodeType(RpcActionGenHelper.resolveOperation(parent, (OperationDefinition)rpc, module, schemaContext, verboseClassComments, genTypeBuilders, genCtx, typeProvider, false, BindingNamespaceType.Data));
        }
        return genCtx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static GeneratedTypeBuilder resolveOperation(DataSchemaNode parent, OperationDefinition operation, Module module, SchemaContext schemaContext, boolean verboseClassComments, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, Map<Module, ModuleContext> genCtx, TypeProvider typeProvider, boolean isAction, BindingNamespaceType namespaceType) {
        String operationName = operation.getQName().getLocalName();
        StringBuilder sb = new StringBuilder(operationName).append('_');
        if (isAction) {
            sb.append("Action");
        } else {
            sb.append("Rpc");
        }
        GeneratedTypeBuilder interfaceBuilder = GenHelperUtil.moduleTypeBuilder(module, sb.toString(), verboseClassComments, genCtx.get(module));
        String basePackageName = interfaceBuilder.getPackageName();
        interfaceBuilder.setDescription(AuxiliaryGenUtils.createDescription((SchemaNode)operation, interfaceBuilder.getFullyQualifiedName(), schemaContext, verboseClassComments, namespaceType));
        String operationComment = BindingGeneratorUtil.encodeAngleBrackets((String)operation.getDescription());
        MethodSignatureBuilder operationMethod = interfaceBuilder.addMethod("invoke");
        ContainerSchemaNode input2 = operation.getInput();
        GeneratedTypeBuilder inType = RpcActionGenHelper.resolveOperationNode(interfaceBuilder, module, operation.getInput(), basePackageName, schemaContext, operationName, verboseClassComments, typeProvider, genTypeBuilders, genCtx, true, namespaceType);
        AuxiliaryGenUtils.annotateDeprecatedIfNecessary(operation.getStatus(), inType);
        inType.setParentTypeForBuilder((Type)interfaceBuilder);
        genCtx.get(module).addChildNodeType((SchemaNode)input2, inType);
        ContainerSchemaNode output = operation.getOutput();
        GeneratedTypeBuilder outType = RpcActionGenHelper.resolveOperationNode(interfaceBuilder, module, operation.getOutput(), basePackageName, schemaContext, operationName, verboseClassComments, typeProvider, genTypeBuilders, genCtx, false, namespaceType);
        AuxiliaryGenUtils.annotateDeprecatedIfNecessary(operation.getStatus(), outType);
        outType.setParentTypeForBuilder((Type)interfaceBuilder);
        genCtx.get(module).addChildNodeType((SchemaNode)output, outType);
        GeneratedType inTypeInstance = inType.toInstance();
        operationMethod.addParameter((Type)inTypeInstance, "input");
        if (isAction) {
            if (parent == null) throw new UnsupportedOperationException("Not implemented yet.");
            GeneratedTypeBuilder parentType = genCtx.get(module).getChildNode(parent.getPath());
            Preconditions.checkState((parentType != null ? 1 : 0) != 0, (Object)("Parent generated type for " + parent + " data schema node must have been generated already"));
            AuxiliaryGenUtils.annotateDeprecatedIfNecessary(parent.getStatus(), parentType);
            if (parent instanceof ListSchemaNode) {
                GeneratedTransferObject keyType = null;
                for (MethodSignatureBuilder method : parentType.getMethodDefinitions()) {
                    if (!method.getName().equals("getKey")) continue;
                    keyType = (GeneratedTransferObject)method.toInstance((Type)parentType).getReturnType();
                }
                operationMethod.addParameter((Type)Types.parameterizedTypeFor((Type)BindingTypes.KEYED_INSTANCE_IDENTIFIER, (Type[])new Type[]{parentType, keyType}), "kii");
                interfaceBuilder.addImplementsType((Type)Types.parameterizedTypeFor((Type)BindingTypes.LIST_ACTION, (Type[])new Type[]{parentType, inType, outType}));
            } else {
                operationMethod.addParameter((Type)Types.parameterizedTypeFor((Type)BindingTypes.INSTANCE_IDENTIFIER, (Type[])new Type[]{parentType}), "ii");
                interfaceBuilder.addImplementsType((Type)Types.parameterizedTypeFor((Type)BindingTypes.ACTION, (Type[])new Type[]{parentType, inType, outType}));
            }
        } else {
            interfaceBuilder.addImplementsType((Type)Types.parameterizedTypeFor((Type)BindingTypes.RPC, (Type[])new Type[]{inType, outType}));
        }
        interfaceBuilder.addImplementsType((Type)BindingTypes.TREE_NODE);
        operationMethod.addParameter((Type)Types.parameterizedTypeFor((Type)BindingTypes.RPC_CALLBACK, (Type[])new Type[]{outType}), "callback");
        operationMethod.setComment(operationComment);
        operationMethod.setReturnType((Type)Types.VOID);
        return interfaceBuilder;
    }

    private static GeneratedTypeBuilder resolveOperationNode(GeneratedTypeBuilder parent, Module module, ContainerSchemaNode operationNode, String basePackageName, SchemaContext schemaContext, String operationName, boolean verboseClassComments, TypeProvider typeProvider, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, Map<Module, ModuleContext> genCtx, boolean isInput, BindingNamespaceType namespaceType) {
        GeneratedTypeBuilder nodeType = GenHelperUtil.addRawInterfaceDefinition(basePackageName, (SchemaNode)operationNode, schemaContext, operationName, "", verboseClassComments, genTypeBuilders, namespaceType, genCtx.get(module));
        GenHelperUtil.addImplementedInterfaceFromUses((DataNodeContainer)operationNode, nodeType, genCtx);
        nodeType.addImplementsType((Type)Types.parameterizedTypeFor((Type)BindingTypes.TREE_CHILD_NODE, (Type[])new Type[]{parent, Types.parameterizedTypeFor((Type)BindingTypes.ITEM, (Type[])new Type[]{parent})}));
        if (isInput) {
            nodeType.addImplementsType((Type)Types.parameterizedTypeFor((Type)BindingTypes.INPUT, (Type[])new Type[]{nodeType}));
        } else {
            nodeType.addImplementsType((Type)Types.parameterizedTypeFor((Type)BindingTypes.OUTPUT, (Type[])new Type[]{nodeType}));
        }
        nodeType.addImplementsType((Type)Types.parameterizedTypeFor((Type)BindingTypes.INSTANTIABLE, (Type[])new Type[]{nodeType}));
        nodeType.addImplementsType((Type)BindingTypes.augmentable((Type)nodeType));
        GenHelperUtil.resolveDataSchemaNodes(module, basePackageName, nodeType, nodeType, operationNode.getChildNodes(), genCtx, schemaContext, verboseClassComments, genTypeBuilders, typeProvider, namespaceType);
        MethodSignatureBuilder nodeMethod = nodeType.addMethod("implementedInterface");
        nodeMethod.setReturnType((Type)Types.parameterizedTypeFor((Type)Types.CLASS, (Type[])new Type[]{nodeType}));
        nodeMethod.addAnnotation("", "Override");
        GenHelperUtil.processUsesImplements(operationNode, module, schemaContext, genCtx, namespaceType);
        return nodeType;
    }
}

