/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.javav2.generator.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.mdsal.binding.javav2.generator.context.ModuleContext;
import org.opendaylight.mdsal.binding.javav2.generator.impl.AuxiliaryGenUtils;
import org.opendaylight.mdsal.binding.javav2.generator.impl.GenHelperUtil;
import org.opendaylight.mdsal.binding.javav2.generator.impl.RpcActionGenHelper;
import org.opendaylight.mdsal.binding.javav2.generator.spi.TypeProvider;
import org.opendaylight.mdsal.binding.javav2.generator.util.BindingTypes;
import org.opendaylight.mdsal.binding.javav2.generator.yang.types.TypeProviderImpl;
import org.opendaylight.mdsal.binding.javav2.model.api.Type;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.javav2.spec.runtime.BindingNamespaceType;
import org.opendaylight.mdsal.binding.javav2.util.BindingMapping;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationNodeContainer;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.util.DataNodeIterator;

@Beta
final class ModuleToGenType {
    private ModuleToGenType() {
        throw new UnsupportedOperationException("Utility class");
    }

    static Map<Module, ModuleContext> generate(Module module, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, SchemaContext schemaContext, TypeProvider typeProvider, Map<Module, ModuleContext> genCtx, boolean verboseClassComments) {
        genCtx.put(module, new ModuleContext());
        genCtx = ModuleToGenType.allTypeDefinitionsToGenTypes(module, genCtx, typeProvider);
        genCtx = GenHelperUtil.groupingsToGenTypes(module, module.getGroupings(), genCtx, schemaContext, verboseClassComments, genTypeBuilders, typeProvider);
        genCtx = ModuleToGenType.allIdentitiesToGenTypes(module, schemaContext, genCtx, verboseClassComments, genTypeBuilders, typeProvider);
        if (!module.getChildNodes().isEmpty()) {
            GeneratedTypeBuilder moduleType = GenHelperUtil.moduleToDataType(module, genCtx, verboseClassComments);
            genCtx.get(module).addModuleNode(moduleType);
            String basePackageName = BindingMapping.getRootPackageName((Module)module);
            GenHelperUtil.resolveDataSchemaNodes(module, basePackageName, moduleType, moduleType, module.getChildNodes(), genCtx, schemaContext, verboseClassComments, genTypeBuilders, typeProvider, BindingNamespaceType.Data);
            GenHelperUtil.processUsesImplements(module, module, schemaContext, genCtx, BindingNamespaceType.Data);
        }
        genCtx = ModuleToGenType.notificationsToGenType(module, genCtx, schemaContext, genTypeBuilders, verboseClassComments, typeProvider);
        genCtx = ModuleToGenType.actionsAndRPCMethodsToGenType(module, genCtx, schemaContext, verboseClassComments, genTypeBuilders, typeProvider);
        return genCtx;
    }

    private static Map<Module, ModuleContext> allTypeDefinitionsToGenTypes(Module module, Map<Module, ModuleContext> genCtx, TypeProvider typeProvider) {
        Preconditions.checkArgument((module != null ? 1 : 0) != 0, (Object)"Module reference cannot be NULL.");
        Preconditions.checkArgument((module.getName() != null ? 1 : 0) != 0, (Object)"Module name cannot be NULL.");
        DataNodeIterator it = new DataNodeIterator((DataNodeContainer)module);
        List typeDefinitions = it.allTypedefs();
        Preconditions.checkState((typeDefinitions != null ? 1 : 0) != 0, (Object)"Type Definitions for module \u00abmodule.name\u00bb cannot be NULL.");
        typeDefinitions.stream().filter(typedef -> typedef != null).forEach(typedef -> {
            Type type = ((TypeProviderImpl)typeProvider).generatedTypeForExtendedDefinitionType((TypeDefinition<?>)typedef, (SchemaNode)typedef);
            if (type != null) {
                ModuleContext ctx = (ModuleContext)genCtx.get(module);
                ctx.addTypedefType(typedef.getPath(), type);
                ctx.addTypeToSchema(type, typedef);
            }
        });
        return genCtx;
    }

    private static Map<Module, ModuleContext> actionsAndRPCMethodsToGenType(Module module, Map<Module, ModuleContext> genCtx, SchemaContext schemaContext, boolean verboseClassComments, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, TypeProvider typeProvider) {
        genCtx = RpcActionGenHelper.rpcMethodsToGenType(module, genCtx, schemaContext, verboseClassComments, genTypeBuilders, typeProvider);
        genCtx = RpcActionGenHelper.actionMethodsToGenType(module, genCtx, schemaContext, verboseClassComments, genTypeBuilders, typeProvider);
        return genCtx;
    }

    private static Map<Module, ModuleContext> allIdentitiesToGenTypes(Module module, SchemaContext schemaContext, Map<Module, ModuleContext> genCtx, boolean verboseClassComments, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, TypeProvider typeProvider) {
        Set schemaIdentities = module.getIdentities();
        String basePackageName = BindingMapping.getRootPackageName((Module)module);
        if (schemaIdentities != null && !schemaIdentities.isEmpty()) {
            for (IdentitySchemaNode identity : schemaIdentities) {
                GenHelperUtil.identityToGenType(module, basePackageName, identity, schemaContext, genCtx, verboseClassComments);
            }
        }
        return genCtx;
    }

    private static Map<Module, ModuleContext> notificationsToGenType(Module module, Map<Module, ModuleContext> genCtx, SchemaContext schemaContext, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, boolean verboseClassComments, TypeProvider typeProvider) {
        Preconditions.checkArgument((module != null ? 1 : 0) != 0, (Object)"Module reference cannot be NULL.");
        Preconditions.checkArgument((module.getName() != null ? 1 : 0) != 0, (Object)"Module name cannot be NULL.");
        Set notifications = module.getNotifications();
        if (notifications.isEmpty()) {
            return genCtx;
        }
        GeneratedTypeBuilder listenerInterface = GenHelperUtil.moduleTypeBuilder(module, "Listener", verboseClassComments, genCtx.get(module));
        listenerInterface.addImplementsType((Type)BindingTypes.NOTIFICATION_LISTENER);
        String basePackageName = BindingMapping.getRootPackageName((Module)module);
        for (NotificationDefinition notification : notifications) {
            if (notification == null) continue;
            GenHelperUtil.resolveNotification(listenerInterface, null, basePackageName, notification, module, schemaContext, verboseClassComments, genTypeBuilders, typeProvider, genCtx);
            GenHelperUtil.processUsesImplements(notification, module, schemaContext, genCtx, BindingNamespaceType.Data);
        }
        Collection potentials = module.getChildNodes();
        Set tiedNotifications = null;
        for (DataSchemaNode potential : potentials) {
            if (!(potential instanceof NotificationNodeContainer)) continue;
            tiedNotifications = ((NotificationNodeContainer)potential).getNotifications();
            for (NotificationDefinition tiedNotification : tiedNotifications) {
                if (tiedNotification == null) continue;
                GenHelperUtil.resolveNotification(listenerInterface, potential.getQName().getLocalName(), basePackageName, tiedNotification, module, schemaContext, verboseClassComments, genTypeBuilders, typeProvider, genCtx);
                GenHelperUtil.processUsesImplements(tiedNotification, module, schemaContext, genCtx, BindingNamespaceType.Data);
            }
        }
        if (tiedNotifications != null) {
            listenerInterface.setDescription(AuxiliaryGenUtils.createDescription((Set<? extends SchemaNode>)ImmutableSet.builder().addAll((Iterable)notifications).addAll(tiedNotifications).build(), module, verboseClassComments));
        } else {
            listenerInterface.setDescription(AuxiliaryGenUtils.createDescription(notifications, module, verboseClassComments));
        }
        genCtx.get(module).addTopLevelNodeType(listenerInterface);
        return genCtx;
    }
}

