/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.javav2.generator.impl;

import com.google.common.annotations.Beta;
import org.opendaylight.mdsal.binding.javav2.generator.api.ClassLoadingStrategy;
import org.opendaylight.mdsal.binding.javav2.model.api.Type;
import org.opendaylight.yangtools.util.ClassLoaderUtils;

@Beta
public abstract class GeneratedClassLoadingStrategy
implements ClassLoadingStrategy {
    private static final GeneratedClassLoadingStrategy TCCL_STRATEGY = new TCCLClassLoadingStrategy();

    public Class<?> loadClass(Type type) throws ClassNotFoundException {
        return this.loadClass(type.getFullyQualifiedName());
    }

    public abstract Class<?> loadClass(String var1) throws ClassNotFoundException;

    public static ClassLoadingStrategy getTCCLClassLoadingStrategy() {
        return TCCL_STRATEGY;
    }

    private static final class TCCLClassLoadingStrategy
    extends GeneratedClassLoadingStrategy {
        private TCCLClassLoadingStrategy() {
        }

        @Override
        public Class<?> loadClass(String fullyQualifiedName) throws ClassNotFoundException {
            return ClassLoaderUtils.loadClassWithTCCL((String)fullyQualifiedName);
        }
    }
}

