/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.javav2.generator.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opendaylight.mdsal.binding.javav2.generator.context.ModuleContext;
import org.opendaylight.mdsal.binding.javav2.generator.impl.AuxiliaryGenUtils;
import org.opendaylight.mdsal.binding.javav2.generator.spi.TypeProvider;
import org.opendaylight.mdsal.binding.javav2.generator.util.BindingGeneratorUtil;
import org.opendaylight.mdsal.binding.javav2.generator.util.BindingTypes;
import org.opendaylight.mdsal.binding.javav2.generator.util.JavaIdentifier;
import org.opendaylight.mdsal.binding.javav2.generator.util.JavaIdentifierNormalizer;
import org.opendaylight.mdsal.binding.javav2.generator.util.ReferencedTypeImpl;
import org.opendaylight.mdsal.binding.javav2.generator.util.Types;
import org.opendaylight.mdsal.binding.javav2.generator.util.generated.type.builder.GeneratedPropertyBuilderImpl;
import org.opendaylight.mdsal.binding.javav2.generator.util.generated.type.builder.GeneratedTOBuilderImpl;
import org.opendaylight.mdsal.binding.javav2.generator.util.generated.type.builder.GeneratedTypeBuilderImpl;
import org.opendaylight.mdsal.binding.javav2.generator.yang.types.GroupingDefinitionDependencySort;
import org.opendaylight.mdsal.binding.javav2.generator.yang.types.TypeProviderImpl;
import org.opendaylight.mdsal.binding.javav2.model.api.AccessModifier;
import org.opendaylight.mdsal.binding.javav2.model.api.ConcreteType;
import org.opendaylight.mdsal.binding.javav2.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.javav2.model.api.ParameterizedType;
import org.opendaylight.mdsal.binding.javav2.model.api.Restrictions;
import org.opendaylight.mdsal.binding.javav2.model.api.Type;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.EnumBuilder;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.mdsal.binding.javav2.spec.base.BaseIdentity;
import org.opendaylight.mdsal.binding.javav2.spec.runtime.BindingNamespaceType;
import org.opendaylight.mdsal.binding.javav2.util.BindingMapping;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AnyDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;
import org.opendaylight.yangtools.yang.model.util.SchemaNodeUtils;

@Beta
final class GenHelperUtil {
    private GenHelperUtil() {
        throw new UnsupportedOperationException("Util class");
    }

    static GeneratedTypeBuilder moduleToDataType(Module module, Map<Module, ModuleContext> genCtx, boolean verboseClassComments) {
        Preconditions.checkArgument((module != null ? 1 : 0) != 0, (Object)"Module reference cannot be NULL.");
        GeneratedTypeBuilder moduleDataTypeBuilder = GenHelperUtil.moduleTypeBuilder(module, "Data", verboseClassComments, genCtx.get(module));
        GenHelperUtil.addImplementedInterfaceFromUses((DataNodeContainer)module, moduleDataTypeBuilder, genCtx);
        moduleDataTypeBuilder.addImplementsType((Type)BindingTypes.TREE_ROOT);
        moduleDataTypeBuilder.addComment(module.getDescription());
        moduleDataTypeBuilder.setDescription(AuxiliaryGenUtils.createDescription(module, verboseClassComments));
        moduleDataTypeBuilder.setReference(module.getReference());
        return moduleDataTypeBuilder;
    }

    static GeneratedTypeBuilder moduleTypeBuilder(Module module, String postfix, boolean verboseClassComments, ModuleContext context) {
        Preconditions.checkArgument((module != null ? 1 : 0) != 0, (Object)"Module reference cannot be NULL.");
        String packageName = BindingMapping.getRootPackageName((Module)module);
        String moduleName = module.getName() + '_' + postfix;
        GeneratedTypeBuilderImpl moduleBuilder = new GeneratedTypeBuilderImpl(packageName, moduleName, context);
        moduleBuilder.setDescription(AuxiliaryGenUtils.createDescription(module, verboseClassComments));
        moduleBuilder.setReference(module.getReference());
        moduleBuilder.setModuleName(moduleName);
        return moduleBuilder;
    }

    static GeneratedTypeBuilder addImplementedInterfaceFromUses(DataNodeContainer dataNodeContainer, GeneratedTypeBuilder builder, Map<Module, ModuleContext> genCtx) {
        for (UsesNode usesNode : dataNodeContainer.getUses()) {
            GeneratedType genType = GenHelperUtil.findGroupingByPath(usesNode.getGroupingPath(), genCtx).toInstance();
            if (genType == null) {
                throw new IllegalStateException("Grouping " + usesNode.getGroupingPath() + "is not resolved for " + builder.getName());
            }
            builder.addImplementsType((Type)genType);
        }
        return builder;
    }

    static GeneratedTypeBuilder findGroupingByPath(SchemaPath path, Map<Module, ModuleContext> genCtx) {
        for (ModuleContext ctx : genCtx.values()) {
            GeneratedTypeBuilder result2 = ctx.getGrouping(path);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    static GeneratedTOBuilder findIdentityByQname(QName qname, Map<Module, ModuleContext> genCtx) {
        for (ModuleContext ctx : genCtx.values()) {
            GeneratedTOBuilder result2 = (GeneratedTOBuilder)ctx.getIdentities().get(qname);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    static GeneratedTypeBuilder resolveDataSchemaNodes(Module module, String basePackageName, GeneratedTypeBuilder parent, GeneratedTypeBuilder childOf, Iterable<DataSchemaNode> schemaNodes, Map<Module, ModuleContext> genCtx, SchemaContext schemaContext, boolean verboseClassComments, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, TypeProvider typeProvider, BindingNamespaceType namespaceType) {
        if (schemaNodes != null && parent != null) {
            for (DataSchemaNode schemaNode : schemaNodes) {
                if (!GenHelperUtil.resolveDataSchemaNodesCheck(module, schemaContext, schemaNode)) continue;
                GenHelperUtil.addSchemaNodeToBuilderAsMethod(basePackageName, schemaNode, parent, childOf, module, genCtx, schemaContext, verboseClassComments, genTypeBuilders, typeProvider, namespaceType);
            }
        }
        return parent;
    }

    static boolean resolveDataSchemaNodesCheck(Module module, SchemaContext schemaContext, DataSchemaNode schemaNode) {
        QName qname;
        Module originalModule;
        if (!schemaNode.isAugmenting()) {
            return true;
        }
        return schemaNode.isAugmenting() && module.equals(originalModule = schemaContext.findModuleByNamespaceAndRevision((qname = schemaNode.getPath().getLastComponent()).getNamespace(), qname.getRevision()));
    }

    static GeneratedTypeBuilder addDefaultInterfaceDefinition(String basePackageName, SchemaNode schemaNode, Module module, Map<Module, ModuleContext> genCtx, SchemaContext schemaContext, boolean verboseClassComments, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, TypeProvider typeProvider, BindingNamespaceType namespaceType) {
        return GenHelperUtil.addDefaultInterfaceDefinition(basePackageName, schemaNode, null, module, genCtx, schemaContext, verboseClassComments, genTypeBuilders, typeProvider, namespaceType);
    }

    private static QName createQNameFromSuperNode(Module module, Object node, SchemaNode superChildNode) {
        QName childNodeQName = null;
        if (node instanceof Module) {
            childNodeQName = QName.create((URI)((Module)node).getNamespace(), (Date)((Module)node).getRevision(), (String)superChildNode.getQName().getLocalName());
        } else if (node instanceof SchemaNode) {
            childNodeQName = QName.create((QName)((SchemaNode)node).getQName(), (String)superChildNode.getQName().getLocalName());
        } else if (node instanceof AugmentationSchema) {
            childNodeQName = QName.create((URI)module.getNamespace(), (Date)module.getRevision(), (String)superChildNode.getQName().getLocalName());
        } else {
            throw new IllegalArgumentException("Not support node type:" + node.toString());
        }
        return childNodeQName;
    }

    private static void addUsesImplements(SchemaNode superNode, Module superModule, Object node, Module module, SchemaContext schemaContext, Map<Module, ModuleContext> genCtx, BindingNamespaceType namespaceType) {
        if (superNode instanceof DataNodeContainer) {
            for (DataSchemaNode superChildNode : ((DataNodeContainer)superNode).getChildNodes()) {
                if (!(superChildNode instanceof DataNodeContainer) && !(superChildNode instanceof ChoiceSchemaNode)) continue;
                QName childQName = GenHelperUtil.createQNameFromSuperNode(module, node, (SchemaNode)superChildNode);
                DataSchemaNode childNode = ((DataNodeContainer)node).getDataChildByName(childQName);
                Preconditions.checkNotNull((Object)childNode, (Object)(node.toString() + "->" + childQName.toString()));
                GeneratedTypeBuilder type = genCtx.get(module).getChildNode(childNode.getPath());
                GeneratedTypeBuilder superType = genCtx.get(superModule).getChildNode(superChildNode.getPath());
                Preconditions.checkNotNull((Object)type, (Object)(module.toString() + "->" + childNode.getPath().toString()));
                Preconditions.checkNotNull((Object)superType, (Object)(superModule.toString() + "->" + superChildNode.getPath().toString()));
                type.addImplementsType((Type)superType);
                if (superChildNode instanceof ListSchemaNode && !((ListSchemaNode)superChildNode).getKeyDefinition().isEmpty()) {
                    if (namespaceType.equals((Object)BindingNamespaceType.Grouping)) {
                        genCtx.get(module).getKeyType(childNode.getPath()).addImplementsType((Type)genCtx.get(superModule).getKeyType(superChildNode.getPath()));
                    } else if (namespaceType.equals((Object)BindingNamespaceType.Data)) {
                        genCtx.get(module).getKeyGenTO(childNode.getPath()).addImplementsType((Type)genCtx.get(superModule).getKeyType(superChildNode.getPath()));
                    }
                }
                GenHelperUtil.addUsesImplements((SchemaNode)superChildNode, superModule, childNode, module, schemaContext, genCtx, namespaceType);
            }
        } else if (superNode instanceof ChoiceSchemaNode) {
            for (ChoiceCaseNode superCaseNode : ((ChoiceSchemaNode)superNode).getCases()) {
                QName childQName = GenHelperUtil.createQNameFromSuperNode(module, node, (SchemaNode)superCaseNode);
                ChoiceCaseNode caseNode = ((ChoiceSchemaNode)node).getCaseNodeByName(childQName);
                Preconditions.checkNotNull((Object)caseNode, (Object)(node.toString() + "->" + childQName.toString()));
                GeneratedTypeBuilder type = genCtx.get(module).getCase(caseNode.getPath());
                GeneratedTypeBuilder superType = genCtx.get(superModule).getCase(superCaseNode.getPath());
                Preconditions.checkNotNull((Object)type, (Object)(module.toString() + "->" + caseNode.getPath().toString()));
                Preconditions.checkNotNull((Object)superType, (Object)(superModule.toString() + "->" + superCaseNode.getPath().toString()));
                type.addImplementsType((Type)superType);
                GenHelperUtil.addUsesImplements((SchemaNode)superCaseNode, superModule, caseNode, module, schemaContext, genCtx, namespaceType);
            }
        } else {
            throw new IllegalArgumentException("Not support super node :" + superNode.toString());
        }
    }

    private static GroupingDefinition findGroupingNodeFromUses(Module module, SchemaContext schemaContext, Object parentNode, UsesNode usesNode) {
        SchemaNode groupingNode;
        if (parentNode instanceof Module) {
            Module superModule = schemaContext.findModuleByNamespaceAndRevision(usesNode.getGroupingPath().getLastComponent().getModule().getNamespace(), usesNode.getGroupingPath().getLastComponent().getModule().getRevision());
            groupingNode = superModule.getGroupings().stream().filter(grouping -> grouping.getPath().equals((Object)usesNode.getGroupingPath())).findFirst().orElse(null);
        } else {
            Iterable prefixedPath = usesNode.getGroupingPath().getPathFromRoot();
            QName current = (QName)prefixedPath.iterator().next();
            Module targetModule = schemaContext.findModuleByNamespaceAndRevision(current.getNamespace(), current.getRevision());
            Preconditions.checkArgument((targetModule != null ? 1 : 0) != 0, (String)"Cannot find target module for %s and %s.", (Object[])new Object[]{current.getNamespace(), current.getRevision()});
            groupingNode = (SchemaNode)targetModule.getGroupings().stream().filter(grouping -> grouping.getPath().equals((Object)usesNode.getGroupingPath())).collect(Collectors.toList()).get(0);
            if (groupingNode == null) {
                groupingNode = SchemaContextUtil.findDataSchemaNode((SchemaContext)schemaContext, (SchemaPath)usesNode.getGroupingPath());
            }
        }
        Preconditions.checkNotNull((Object)groupingNode, (Object)(module.toString() + "->" + usesNode.getGroupingPath().toString()));
        Preconditions.checkState((boolean)(groupingNode instanceof GroupingDefinition), (Object)(module.toString() + "->" + usesNode.getGroupingPath().toString()));
        return (GroupingDefinition)groupingNode;
    }

    static Map<Module, ModuleContext> processUsesImplements(Object node, Module module, SchemaContext schemaContext, Map<Module, ModuleContext> genCtx, BindingNamespaceType namespaceType) {
        if (node instanceof DataNodeContainer) {
            for (UsesNode usesNode : ((DataNodeContainer)node).getUses()) {
                GroupingDefinition grouping = GenHelperUtil.findGroupingNodeFromUses(module, schemaContext, node, usesNode);
                Module superModule = SchemaContextUtil.findParentModule((SchemaContext)schemaContext, (SchemaNode)grouping);
                GenHelperUtil.addUsesImplements((SchemaNode)grouping, superModule, node, module, schemaContext, genCtx, namespaceType);
            }
        }
        return genCtx;
    }

    static GeneratedTypeBuilder findChildNodeByPath(SchemaPath path, Map<Module, ModuleContext> genCtx) {
        for (ModuleContext ctx : genCtx.values()) {
            GeneratedTypeBuilder result2 = ctx.getChildNode(path);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    static GeneratedTypeBuilder findCaseByPath(SchemaPath path, Map<Module, ModuleContext> genCtx) {
        for (ModuleContext ctx : genCtx.values()) {
            GeneratedTypeBuilder result2 = ctx.getCase(path);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    static Map<Module, ModuleContext> addRawAugmentGenTypeDefinition(Module module, String augmentPackageName, Type targetTypeRef, SchemaNode targetNode, List<AugmentationSchema> schemaPathAugmentListEntry, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, Map<Module, ModuleContext> genCtx, SchemaContext schemaContext, boolean verboseClassComments, TypeProvider typeProvider, BindingNamespaceType namespaceType) {
        AugmentationSchema augSchema = schemaPathAugmentListEntry.get(0);
        Map augmentBuilders = genTypeBuilders.computeIfAbsent(augmentPackageName, k -> new HashMap());
        String augIdentifier = null;
        Iterator<AugmentationSchema> iterator2 = schemaPathAugmentListEntry.iterator();
        if (iterator2.hasNext()) {
            AugmentationSchema aug = iterator2.next();
            augIdentifier = AuxiliaryGenUtils.getAugmentIdentifier(aug.getUnknownSchemaNodes());
        }
        if (augIdentifier == null) {
            augIdentifier = module.getName() + '_' + targetNode.getQName().getLocalName();
        }
        GeneratedTypeBuilderImpl augTypeBuilder = new GeneratedTypeBuilderImpl(augmentPackageName, augIdentifier, true, false, genCtx.get(module));
        augTypeBuilder.addImplementsType((Type)BindingTypes.TREE_NODE);
        augTypeBuilder.addImplementsType((Type)Types.parameterizedTypeFor((Type)BindingTypes.INSTANTIABLE, (Type[])new Type[]{augTypeBuilder}));
        augTypeBuilder.addImplementsType((Type)Types.augmentationTypeFor((Type)targetTypeRef));
        augTypeBuilder.setBasePackageName(BindingMapping.getRootPackageName((Module)module));
        augTypeBuilder.setWithBuilder(true);
        AuxiliaryGenUtils.annotateDeprecatedIfNecessary(augSchema.getStatus(), (GeneratedTypeBuilder)augTypeBuilder);
        for (AugmentationSchema aug : schemaPathAugmentListEntry) {
            GenHelperUtil.addImplementedInterfaceFromUses((DataNodeContainer)aug, (GeneratedTypeBuilder)augTypeBuilder, genCtx);
            GenHelperUtil.augSchemaNodeToMethods(module, BindingMapping.getRootPackageName((Module)module), (GeneratedTypeBuilder)augTypeBuilder, (GeneratedTypeBuilder)augTypeBuilder, aug.getChildNodes(), genCtx, schemaContext, verboseClassComments, typeProvider, genTypeBuilders, namespaceType);
        }
        augmentBuilders.put(augTypeBuilder.getName(), augTypeBuilder);
        if (!augSchema.getChildNodes().isEmpty()) {
            genCtx.get(module).addTypeToAugmentation((GeneratedTypeBuilder)augTypeBuilder, augSchema);
            genCtx.get(module).addTargetToAugmentation((GeneratedTypeBuilder)augTypeBuilder, augSchema.getTargetPath());
        }
        genCtx.get(module).addAugmentType((GeneratedTypeBuilder)augTypeBuilder);
        return genCtx;
    }

    private static GeneratedTypeBuilder augSchemaNodeToMethods(Module module, String basePackageName, GeneratedTypeBuilder typeBuilder, GeneratedTypeBuilder childOf, Iterable<DataSchemaNode> schemaNodes, Map<Module, ModuleContext> genCtx, SchemaContext schemaContext, boolean verboseClassComments, TypeProvider typeProvider, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, BindingNamespaceType namespaceType) {
        if (schemaNodes != null && typeBuilder != null) {
            for (DataSchemaNode schemaNode : schemaNodes) {
                if (schemaNode.isAugmenting()) continue;
                GenHelperUtil.addSchemaNodeToBuilderAsMethod(basePackageName, schemaNode, typeBuilder, childOf, module, genCtx, schemaContext, verboseClassComments, genTypeBuilders, typeProvider, namespaceType);
            }
        }
        return typeBuilder;
    }

    private static GeneratedTypeBuilder addDefaultInterfaceDefinition(String basePackageName, SchemaNode schemaNode, Type parent, Module module, Map<Module, ModuleContext> genCtx, SchemaContext schemaContext, boolean verboseClassComments, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, TypeProvider typeProvider, BindingNamespaceType namespaceType) {
        String suffix = "";
        if (schemaNode instanceof GroupingDefinition) {
            suffix = "grouping";
        } else if (namespaceType.equals((Object)BindingNamespaceType.Grouping)) {
            suffix = "data";
        }
        GeneratedTypeBuilder it = GenHelperUtil.addRawInterfaceDefinition(basePackageName, schemaNode, schemaContext, "", suffix, verboseClassComments, genTypeBuilders, namespaceType, genCtx.get(module));
        if (namespaceType.equals((Object)BindingNamespaceType.Data)) {
            if (parent == null) {
                it.addImplementsType((Type)BindingTypes.TREE_NODE);
            } else if (parent instanceof ListSchemaNode) {
                it.addImplementsType((Type)Types.parameterizedTypeFor((Type)BindingTypes.TREE_CHILD_NODE, (Type[])new Type[]{parent, Types.parameterizedTypeFor((Type)BindingTypes.IDENTIFIABLE_ITEM, (Type[])new Type[]{parent})}));
            } else {
                it.addImplementsType((Type)Types.parameterizedTypeFor((Type)BindingTypes.TREE_CHILD_NODE, (Type[])new Type[]{parent, Types.parameterizedTypeFor((Type)BindingTypes.ITEM, (Type[])new Type[]{parent})}));
                it.addImplementsType((Type)Types.parameterizedTypeFor((Type)BindingTypes.INSTANTIABLE, (Type[])new Type[]{it}));
            }
            if (!(schemaNode instanceof GroupingDefinition)) {
                it.addImplementsType((Type)BindingTypes.augmentable((Type)it));
            }
        } else {
            it.addImplementsType((Type)BindingTypes.TREE_NODE);
        }
        if (schemaNode instanceof DataNodeContainer) {
            GenHelperUtil.groupingsToGenTypes(module, ((DataNodeContainer)schemaNode).getGroupings(), genCtx, schemaContext, verboseClassComments, genTypeBuilders, typeProvider);
            it = GenHelperUtil.addImplementedInterfaceFromUses((DataNodeContainer)schemaNode, it, genCtx);
        }
        return it;
    }

    static GeneratedTypeBuilder resolveNotification(GeneratedTypeBuilder listenerInterface, String parentName, String basePackageName, NotificationDefinition notification, Module module, SchemaContext schemaContext, boolean verboseClassComments, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, TypeProvider typeProvider, Map<Module, ModuleContext> genCtx) {
        GeneratedTypeBuilder notificationInterface = GenHelperUtil.addDefaultInterfaceDefinition(basePackageName, (SchemaNode)notification, null, module, genCtx, schemaContext, verboseClassComments, genTypeBuilders, typeProvider, BindingNamespaceType.Data);
        AuxiliaryGenUtils.annotateDeprecatedIfNecessary(notification.getStatus(), notificationInterface);
        notificationInterface.addImplementsType((Type)BindingTypes.NOTIFICATION);
        genCtx.get(module).addChildNodeType((SchemaNode)notification, notificationInterface);
        GenHelperUtil.resolveDataSchemaNodes(module, basePackageName, notificationInterface, notificationInterface, notification.getChildNodes(), genCtx, schemaContext, verboseClassComments, genTypeBuilders, typeProvider, BindingNamespaceType.Data);
        StringBuilder sb = new StringBuilder("on_");
        if (parentName != null) {
            sb.append(parentName).append('_');
        }
        sb.append(notificationInterface.getName());
        ((MethodSignatureBuilder)((MethodSignatureBuilder)listenerInterface.addMethod(JavaIdentifierNormalizer.normalizeSpecificIdentifier((String)sb.toString(), (JavaIdentifier)JavaIdentifier.METHOD)).setAccessModifier(AccessModifier.PUBLIC)).addParameter((Type)notificationInterface, "notification").setComment(BindingGeneratorUtil.encodeAngleBrackets((String)notification.getDescription()))).setReturnType((Type)Types.VOID);
        return listenerInterface;
    }

    static GeneratedTypeBuilder addRawInterfaceDefinition(String basePackageName, SchemaNode schemaNode, SchemaContext schemaContext, String prefix, String suffix, boolean verboseClassComments, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, BindingNamespaceType namespaceType, ModuleContext context) {
        Preconditions.checkArgument((schemaNode != null ? 1 : 0) != 0, (Object)"Data Schema Node cannot be NULL.");
        Preconditions.checkArgument((basePackageName != null ? 1 : 0) != 0, (Object)"Base package Name for Generated Type cannot be NULL.");
        String schemaNodeName = schemaNode.getQName().getLocalName();
        Preconditions.checkArgument((schemaNodeName != null ? 1 : 0) != 0, (Object)"Local Name of QName for Data Schema Node cannot be NULL.");
        if (prefix != null && !prefix.isEmpty()) {
            schemaNodeName = prefix + '_' + schemaNodeName;
        }
        if (suffix != null && !suffix.isEmpty()) {
            schemaNodeName = schemaNodeName + '_' + suffix;
        }
        String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)schemaNode.getPath(), (BindingNamespaceType)namespaceType);
        GeneratedTypeBuilderImpl newType = new GeneratedTypeBuilderImpl(packageName, schemaNodeName, context);
        Module module = SchemaContextUtil.findParentModule((SchemaContext)schemaContext, (SchemaNode)schemaNode);
        AuxiliaryGenUtils.qNameConstant(newType, "QNAME", schemaNode.getQName());
        newType.addComment(schemaNode.getDescription());
        newType.setDescription(AuxiliaryGenUtils.createDescription(schemaNode, newType.getFullyQualifiedName(), schemaContext, verboseClassComments, namespaceType));
        newType.setReference(schemaNode.getReference());
        newType.setSchemaPath((List)schemaNode.getPath().getPathFromRoot());
        newType.setModuleName(module.getName());
        newType.setBasePackageName(BindingMapping.getRootPackageName((Module)module));
        newType.setWithBuilder(AuxiliaryGenUtils.hasBuilderClass(schemaNode, namespaceType));
        if (!genTypeBuilders.containsKey(packageName)) {
            HashMap<String, GeneratedTypeBuilderImpl> builders = new HashMap<String, GeneratedTypeBuilderImpl>();
            builders.put(newType.getName(), newType);
            genTypeBuilders.put(packageName, builders);
        } else {
            Map<String, GeneratedTypeBuilder> builders = genTypeBuilders.get(packageName);
            if (!builders.containsKey(newType.getName())) {
                builders.put(newType.getName(), (GeneratedTypeBuilder)newType);
            }
        }
        return newType;
    }

    private static void addSchemaNodeToBuilderAsMethod(String basePackageName, DataSchemaNode node, GeneratedTypeBuilder typeBuilder, GeneratedTypeBuilder childOf, Module module, Map<Module, ModuleContext> genCtx, SchemaContext schemaContext, boolean verboseClassComments, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, TypeProvider typeProvider, BindingNamespaceType namespaceType) {
        if (node != null && typeBuilder != null) {
            if (node instanceof ContainerSchemaNode) {
                GenHelperUtil.containerToGenType(module, basePackageName, typeBuilder, childOf, (ContainerSchemaNode)node, schemaContext, verboseClassComments, genCtx, genTypeBuilders, typeProvider, namespaceType);
            } else if (node instanceof LeafListSchemaNode) {
                GenHelperUtil.resolveLeafListSchemaNode(schemaContext, typeBuilder, (LeafListSchemaNode)node, module, typeProvider, genCtx);
            } else if (node instanceof LeafSchemaNode) {
                GenHelperUtil.resolveLeafSchemaNodeAsMethod("", schemaContext, typeBuilder, genCtx, (LeafSchemaNode)node, module, typeProvider);
            } else if (node instanceof ListSchemaNode) {
                GenHelperUtil.listToGenType(module, basePackageName, typeBuilder, childOf, (ListSchemaNode)node, schemaContext, verboseClassComments, genCtx, genTypeBuilders, typeProvider, namespaceType);
            } else if (node instanceof ChoiceSchemaNode) {
                GenHelperUtil.choiceToGenType(module, schemaContext, verboseClassComments, basePackageName, typeBuilder, (ChoiceSchemaNode)node, genTypeBuilders, genCtx, typeProvider, namespaceType);
            } else if (node instanceof AnyXmlSchemaNode || node instanceof AnyDataSchemaNode) {
                GenHelperUtil.resolveAnyNodeAsMethod(schemaContext, typeBuilder, genCtx, node, module, typeProvider);
            }
        }
    }

    private static void choiceToGenType(Module module, SchemaContext schemaContext, boolean verboseClasssComments, String basePackageName, GeneratedTypeBuilder parent, ChoiceSchemaNode choiceNode, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, Map<Module, ModuleContext> genCtx, TypeProvider typeProvider, BindingNamespaceType namespaceType) {
        Preconditions.checkArgument((basePackageName != null ? 1 : 0) != 0, (Object)"Base Package Name cannot be NULL.");
        Preconditions.checkArgument((choiceNode != null ? 1 : 0) != 0, (Object)"Choice Schema Node cannot be NULL.");
        GeneratedTypeBuilder choiceTypeBuilder = GenHelperUtil.addRawInterfaceDefinition(basePackageName, (SchemaNode)choiceNode, schemaContext, "", "", verboseClasssComments, genTypeBuilders, namespaceType, genCtx.get(module));
        AuxiliaryGenUtils.constructGetter(parent, choiceNode.getQName().getLocalName(), choiceNode.getDescription(), (Type)choiceTypeBuilder, choiceNode.getStatus());
        if (namespaceType.equals((Object)BindingNamespaceType.Data)) {
            choiceTypeBuilder.addImplementsType((Type)Types.parameterizedTypeFor((Type)BindingTypes.INSTANTIABLE, (Type[])new Type[]{choiceTypeBuilder}));
        }
        AuxiliaryGenUtils.annotateDeprecatedIfNecessary(choiceNode.getStatus(), choiceTypeBuilder);
        genCtx.get(module).addChildNodeType((SchemaNode)choiceNode, choiceTypeBuilder);
        GenHelperUtil.generateTypesFromChoiceCases(module, schemaContext, genCtx, basePackageName, (Type)choiceTypeBuilder.toInstance(), choiceNode, verboseClasssComments, typeProvider, genTypeBuilders, namespaceType);
    }

    private static void containerToGenType(Module module, String basePackageName, GeneratedTypeBuilder parent, GeneratedTypeBuilder childOf, ContainerSchemaNode node, SchemaContext schemaContext, boolean verboseClassComments, Map<Module, ModuleContext> genCtx, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, TypeProvider typeProvider, BindingNamespaceType namespaceType) {
        GeneratedTypeBuilder genType = GenHelperUtil.processDataSchemaNode(module, basePackageName, childOf, (DataSchemaNode)node, schemaContext, verboseClassComments, genCtx, genTypeBuilders, typeProvider, namespaceType);
        if (genType != null) {
            StringBuilder getterName = new StringBuilder(node.getQName().getLocalName());
            AuxiliaryGenUtils.constructGetter(parent, getterName.toString(), node.getDescription(), (Type)genType, node.getStatus());
            GenHelperUtil.resolveDataSchemaNodes(module, basePackageName, genType, genType, node.getChildNodes(), genCtx, schemaContext, verboseClassComments, genTypeBuilders, typeProvider, namespaceType);
            GenHelperUtil.processUsesImplements(node, module, schemaContext, genCtx, namespaceType);
        }
    }

    private static void listToGenType(Module module, String basePackageName, GeneratedTypeBuilder parent, GeneratedTypeBuilder childOf, ListSchemaNode node, SchemaContext schemaContext, boolean verboseClassComments, Map<Module, ModuleContext> genCtx, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, TypeProvider typeProvider, BindingNamespaceType namespaceType) {
        GeneratedTypeBuilder genType = GenHelperUtil.processDataSchemaNode(module, basePackageName, childOf, (DataSchemaNode)node, schemaContext, verboseClassComments, genCtx, genTypeBuilders, typeProvider, namespaceType);
        if (genType != null) {
            String nodeName = node.getQName().getLocalName();
            ParameterizedType getterReturnType = Types.listTypeFor((Type)genType);
            if (namespaceType.equals((Object)BindingNamespaceType.Grouping)) {
                getterReturnType = Types.listTypeFor((Type)Types.wildcardTypeFor((String)genType.getPackageName(), (String)genType.getName(), (boolean)true, (boolean)true, null));
            }
            AuxiliaryGenUtils.constructGetter(parent, nodeName, node.getDescription(), (Type)getterReturnType, node.getStatus());
            List listKeys = node.getKeyDefinition();
            String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)node.getPath(), (BindingNamespaceType)BindingNamespaceType.Key) + '.' + nodeName;
            if (namespaceType.equals((Object)BindingNamespaceType.Grouping)) {
                GeneratedTypeBuilder genTypeBuilder = AuxiliaryGenUtils.resolveListKeyTypeBuilder(packageName, node, genCtx.get(module));
                for (DataSchemaNode schemaNode : node.getChildNodes()) {
                    if (!GenHelperUtil.resolveDataSchemaNodesCheck(module, schemaContext, schemaNode)) continue;
                    GenHelperUtil.addSchemaNodeToListTypeBuilders(nodeName, basePackageName, schemaNode, genType, genTypeBuilder, listKeys, module, typeProvider, schemaContext, genCtx, genTypeBuilders, verboseClassComments, namespaceType);
                }
                if (genTypeBuilder != null) {
                    GenHelperUtil.typeBuildersToGenTypes(module, genType, (Type)genTypeBuilder.toInstance(), genCtx, namespaceType);
                    genCtx.get(module).addKeyType(node.getPath(), genTypeBuilder);
                }
                GenHelperUtil.processUsesImplements(node, module, schemaContext, genCtx, namespaceType);
            } else {
                GeneratedTOBuilder genTOBuilder = AuxiliaryGenUtils.resolveListKeyTOBuilder(packageName, node, genCtx.get(module));
                for (DataSchemaNode schemaNode : node.getChildNodes()) {
                    if (!GenHelperUtil.resolveDataSchemaNodesCheck(module, schemaContext, schemaNode)) continue;
                    GenHelperUtil.addSchemaNodeToListBuilders(nodeName, basePackageName, schemaNode, genType, genTOBuilder, listKeys, module, typeProvider, schemaContext, genCtx, genTypeBuilders, verboseClassComments, namespaceType);
                }
                GenHelperUtil.processUsesImplements(node, module, schemaContext, genCtx, namespaceType);
                if (genTOBuilder != null) {
                    GeneratedPropertyBuilderImpl prop = new GeneratedPropertyBuilderImpl("serialVersionUID");
                    prop.setValue(Long.toString(BindingGeneratorUtil.computeDefaultSUID((GeneratedTypeBuilderBase)genTOBuilder)));
                    genTOBuilder.setSUID((GeneratedPropertyBuilder)prop);
                    GenHelperUtil.typeBuildersToGenTypes(module, genType, (Type)genTOBuilder.toInstance(), genCtx, namespaceType);
                    genCtx.get(module).addGeneratedTOBuilder(node.getPath(), genTOBuilder);
                }
            }
        }
    }

    private static void typeBuildersToGenTypes(Module module, GeneratedTypeBuilder typeBuilder, Type keyType, Map<Module, ModuleContext> genCtx, BindingNamespaceType namespaceType) {
        Preconditions.checkArgument((typeBuilder != null ? 1 : 0) != 0, (Object)"Generated Type Builder cannot be NULL.");
        if (keyType != null) {
            Type returnKeyType = keyType;
            if (namespaceType.equals((Object)BindingNamespaceType.Grouping)) {
                returnKeyType = Types.wildcardTypeFor((String)keyType.getPackageName(), (String)keyType.getName(), (boolean)true, (boolean)true, null);
            }
            AuxiliaryGenUtils.constructGetter(typeBuilder, "key", "Returns Primary Key of Yang List Type", returnKeyType, Status.CURRENT);
        }
    }

    private static Type resolveLeafSchemaNodeAsMethod(String nodeName, SchemaContext schemaContext, GeneratedTypeBuilder typeBuilder, Map<Module, ModuleContext> genCtx, LeafSchemaNode leaf, Module module, TypeProvider typeProvider) {
        String leafGetterName;
        String leafDesc;
        Restrictions restrictions;
        if (leaf == null || typeBuilder == null) {
            return null;
        }
        String leafName = leaf.getQName().getLocalName();
        if (leafName == null) {
            return null;
        }
        Module parentModule = SchemaContextUtil.findParentModule((SchemaContext)schemaContext, (SchemaNode)leaf);
        Type returnType = null;
        TypeDefinition typeDef = leaf.getType();
        if (leaf.isAddedByUses()) {
            Preconditions.checkState((boolean)(leaf instanceof DerivableSchemaNode));
            if (AuxiliaryGenUtils.isInnerType(leaf, typeDef)) {
                restrictions = BindingGeneratorUtil.getRestrictions((TypeDefinition)typeDef);
                returnType = typeProvider.javaTypeForSchemaDefinitionType(GenHelperUtil.getBaseOrDeclaredType(typeDef), (SchemaNode)leaf, restrictions, genCtx.get(module));
            } else if (typeDef.getBaseType() == null && (typeDef instanceof EnumTypeDefinition || typeDef instanceof UnionTypeDefinition || typeDef instanceof BitsTypeDefinition)) {
                LeafSchemaNode originalLeaf = (LeafSchemaNode)((DerivableSchemaNode)leaf).getOriginal().orNull();
                Preconditions.checkNotNull((Object)originalLeaf);
                returnType = genCtx.get(SchemaContextUtil.findParentModule((SchemaContext)schemaContext, (SchemaNode)originalLeaf)).getInnerType(typeDef.getPath());
            } else {
                restrictions = BindingGeneratorUtil.getRestrictions((TypeDefinition)typeDef);
                returnType = typeProvider.javaTypeForSchemaDefinitionType(typeDef, (SchemaNode)leaf, restrictions, genCtx.get(module));
            }
        } else if (AuxiliaryGenUtils.isInnerType(leaf, typeDef)) {
            GeneratedTOBuilder genTOBuilder;
            if (typeDef instanceof EnumTypeDefinition) {
                returnType = typeProvider.javaTypeForSchemaDefinitionType(typeDef, (SchemaNode)leaf, genCtx.get(module));
                EnumTypeDefinition enumTypeDef = (EnumTypeDefinition)typeDef;
                EnumBuilder enumBuilder = AuxiliaryGenUtils.resolveInnerEnumFromTypeDefinition(enumTypeDef, leaf.getQName(), genCtx, typeBuilder, module);
                if (enumBuilder != null) {
                    returnType = enumBuilder.toInstance((Type)typeBuilder);
                }
                ((TypeProviderImpl)typeProvider).putReferencedType(leaf.getPath(), returnType);
            } else if (typeDef instanceof UnionTypeDefinition) {
                genTOBuilder = AuxiliaryGenUtils.addTOToTypeBuilder(typeDef, typeBuilder, (DataSchemaNode)leaf, parentModule, typeProvider, schemaContext, genCtx.get(module), genCtx);
                if (genTOBuilder != null) {
                    returnType = AuxiliaryGenUtils.createReturnTypeForUnion(genTOBuilder, typeDef, typeBuilder, parentModule, typeProvider);
                }
            } else if (typeDef instanceof BitsTypeDefinition) {
                genTOBuilder = AuxiliaryGenUtils.addTOToTypeBuilder(typeDef, typeBuilder, (DataSchemaNode)leaf, parentModule, typeProvider, schemaContext, genCtx.get(module), genCtx);
                if (genTOBuilder != null) {
                    returnType = genTOBuilder.toInstance();
                }
            } else {
                restrictions = BindingGeneratorUtil.getRestrictions((TypeDefinition)typeDef);
                returnType = typeProvider.javaTypeForSchemaDefinitionType(GenHelperUtil.getBaseOrDeclaredType(typeDef), (SchemaNode)leaf, restrictions, genCtx.get(module));
            }
        } else {
            restrictions = BindingGeneratorUtil.getRestrictions((TypeDefinition)typeDef);
            returnType = typeProvider.javaTypeForSchemaDefinitionType(typeDef, (SchemaNode)leaf, restrictions, genCtx.get(module));
        }
        if (returnType == null) {
            return null;
        }
        if (typeDef instanceof EnumTypeDefinition) {
            ((TypeProviderImpl)typeProvider).putReferencedType(leaf.getPath(), returnType);
        }
        if ((leafDesc = leaf.getDescription()) == null) {
            leafDesc = "";
        }
        if ("key".equals(leafName.toLowerCase())) {
            StringBuilder sb = new StringBuilder(leafName).append('_').append("RESERVED_WORD");
            leafGetterName = sb.toString();
        } else {
            leafGetterName = leafName;
        }
        AuxiliaryGenUtils.constructGetter(typeBuilder, leafGetterName, leafDesc, returnType, leaf.getStatus());
        return returnType;
    }

    private static boolean resolveLeafListSchemaNode(SchemaContext schemaContext, GeneratedTypeBuilder typeBuilder, LeafListSchemaNode node, Module module, TypeProvider typeProvider, Map<Module, ModuleContext> genCtx) {
        Restrictions restrictions;
        if (node == null || typeBuilder == null) {
            return false;
        }
        QName nodeName = node.getQName();
        TypeDefinition typeDef = node.getType();
        Module parentModule = SchemaContextUtil.findParentModule((SchemaContext)schemaContext, (SchemaNode)node);
        Type returnType = null;
        if (typeDef.getBaseType() == null) {
            GeneratedTOBuilder genTOBuilder;
            if (typeDef instanceof EnumTypeDefinition) {
                returnType = typeProvider.javaTypeForSchemaDefinitionType(typeDef, (SchemaNode)node, genCtx.get(module));
                EnumTypeDefinition enumTypeDef = (EnumTypeDefinition)typeDef;
                EnumBuilder enumBuilder = AuxiliaryGenUtils.resolveInnerEnumFromTypeDefinition(enumTypeDef, nodeName, genCtx, typeBuilder, module);
                returnType = new ReferencedTypeImpl(enumBuilder.getPackageName(), enumBuilder.getName(), true, null);
                ((TypeProviderImpl)typeProvider).putReferencedType(node.getPath(), returnType);
            } else if (typeDef instanceof UnionTypeDefinition) {
                genTOBuilder = AuxiliaryGenUtils.addTOToTypeBuilder(typeDef, typeBuilder, (DataSchemaNode)node, parentModule, typeProvider, schemaContext, genCtx.get(module), genCtx);
                if (genTOBuilder != null) {
                    returnType = AuxiliaryGenUtils.createReturnTypeForUnion(genTOBuilder, typeDef, typeBuilder, parentModule, typeProvider);
                }
            } else if (typeDef instanceof BitsTypeDefinition) {
                genTOBuilder = AuxiliaryGenUtils.addTOToTypeBuilder(typeDef, typeBuilder, (DataSchemaNode)node, parentModule, typeProvider, schemaContext, genCtx.get(module), genCtx);
                returnType = genTOBuilder.toInstance();
            } else {
                restrictions = BindingGeneratorUtil.getRestrictions((TypeDefinition)typeDef);
                returnType = typeProvider.javaTypeForSchemaDefinitionType(typeDef, (SchemaNode)node, restrictions, genCtx.get(module));
            }
        } else {
            restrictions = BindingGeneratorUtil.getRestrictions((TypeDefinition)typeDef);
            returnType = typeProvider.javaTypeForSchemaDefinitionType(typeDef, (SchemaNode)node, restrictions, genCtx.get(module));
        }
        ParameterizedType listType = Types.listTypeFor((Type)returnType);
        AuxiliaryGenUtils.constructGetter(typeBuilder, nodeName.getLocalName(), node.getDescription(), (Type)listType, node.getStatus());
        return true;
    }

    private static void generateTypesFromChoiceCases(Module module, SchemaContext schemaContext, Map<Module, ModuleContext> genCtx, String basePackageName, Type refChoiceType, ChoiceSchemaNode choiceNode, boolean verboseClassComments, TypeProvider typeProvider, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, BindingNamespaceType namespaceType) {
        Preconditions.checkArgument((basePackageName != null ? 1 : 0) != 0, (Object)"Base Package Name cannot be NULL.");
        Preconditions.checkArgument((refChoiceType != null ? 1 : 0) != 0, (Object)"Referenced Choice Type cannot be NULL.");
        Preconditions.checkArgument((choiceNode != null ? 1 : 0) != 0, (Object)"ChoiceNode cannot be NULL.");
        Set caseNodes = choiceNode.getCases();
        if (caseNodes == null) {
            return;
        }
        for (ChoiceCaseNode caseNode : caseNodes) {
            if (caseNode == null || !GenHelperUtil.resolveDataSchemaNodesCheck(module, schemaContext, (DataSchemaNode)caseNode)) continue;
            GeneratedTypeBuilder caseTypeBuilder = GenHelperUtil.addDefaultInterfaceDefinition(basePackageName, (SchemaNode)caseNode, module, genCtx, schemaContext, verboseClassComments, genTypeBuilders, typeProvider, namespaceType);
            caseTypeBuilder.addImplementsType(refChoiceType);
            caseTypeBuilder.setParentTypeForBuilder(refChoiceType);
            AuxiliaryGenUtils.annotateDeprecatedIfNecessary(caseNode.getStatus(), caseTypeBuilder);
            genCtx.get(module).addCaseType(caseNode.getPath(), caseTypeBuilder);
            genCtx.get(module).addChoiceToCaseMapping(refChoiceType, (Type)caseTypeBuilder, caseNode);
            Collection caseChildNodes = caseNode.getChildNodes();
            if (caseChildNodes == null) continue;
            SchemaPath choiceNodeParentPath = choiceNode.getPath().getParent();
            if (!Iterables.isEmpty((Iterable)choiceNodeParentPath.getPathFromRoot())) {
                SchemaNode parent = SchemaContextUtil.findDataSchemaNode((SchemaContext)schemaContext, (SchemaPath)choiceNodeParentPath);
                if (parent instanceof AugmentationSchema) {
                    AugmentationSchema augSchema = (AugmentationSchema)parent;
                    SchemaPath targetPath = augSchema.getTargetPath();
                    SchemaNode targetSchemaNode = SchemaContextUtil.findDataSchemaNode((SchemaContext)schemaContext, (SchemaPath)targetPath);
                    if (targetSchemaNode instanceof DataSchemaNode && ((DataSchemaNode)targetSchemaNode).isAddedByUses()) {
                        if (targetSchemaNode instanceof DerivableSchemaNode) {
                            targetSchemaNode = (SchemaNode)((DerivableSchemaNode)targetSchemaNode).getOriginal().orNull();
                        }
                        if (targetSchemaNode == null) {
                            throw new IllegalStateException("Failed to find target node from grouping for augmentation " + augSchema + " in module " + module.getName());
                        }
                    }
                    parent = targetSchemaNode;
                }
                Preconditions.checkState((parent != null ? 1 : 0) != 0, (String)"Could not find Choice node parent %s", (Object[])new Object[]{choiceNodeParentPath});
                GeneratedTypeBuilder childOfType = GenHelperUtil.findChildNodeByPath(parent.getPath(), genCtx);
                if (childOfType == null) {
                    childOfType = GenHelperUtil.findGroupingByPath(parent.getPath(), genCtx);
                }
                GenHelperUtil.resolveDataSchemaNodes(module, basePackageName, caseTypeBuilder, childOfType, caseChildNodes, genCtx, schemaContext, verboseClassComments, genTypeBuilders, typeProvider, namespaceType);
            } else {
                GeneratedTypeBuilder moduleType = genCtx.get(module).getModuleNode();
                Preconditions.checkNotNull((Object)moduleType, (Object)"Module type can not be null.");
                GenHelperUtil.resolveDataSchemaNodes(module, basePackageName, caseTypeBuilder, moduleType, caseChildNodes, genCtx, schemaContext, verboseClassComments, genTypeBuilders, typeProvider, namespaceType);
            }
            GenHelperUtil.processUsesImplements(caseNode, module, schemaContext, genCtx, namespaceType);
        }
    }

    private static Type resolveAnyNodeAsMethod(SchemaContext schemaContext, GeneratedTypeBuilder typeBuilder, Map<Module, ModuleContext> genCtx, DataSchemaNode node, Module module, TypeProvider typeProvider) {
        String anyName = node.getQName().getLocalName();
        if (anyName == null) {
            return null;
        }
        String anyDesc = node.getDescription();
        if (anyDesc == null) {
            anyDesc = "";
        }
        ConcreteType returnType = Types.DOCUMENT;
        AuxiliaryGenUtils.constructGetter(typeBuilder, anyName, anyDesc, (Type)returnType, node.getStatus());
        return returnType;
    }

    private static void addSchemaNodeToListBuilders(String nodeName, String basePackageName, DataSchemaNode schemaNode, GeneratedTypeBuilder typeBuilder, GeneratedTOBuilder genTOBuilder, List<QName> listKeys, Module module, TypeProvider typeProvider, SchemaContext schemaContext, Map<Module, ModuleContext> genCtx, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, boolean verboseClassComments, BindingNamespaceType namespaceType) {
        Preconditions.checkArgument((schemaNode != null ? 1 : 0) != 0, (Object)"Data Schema Node cannot be NULL.");
        Preconditions.checkArgument((typeBuilder != null ? 1 : 0) != 0, (Object)"Generated Type Builder cannot be NULL.");
        if (schemaNode instanceof LeafSchemaNode) {
            LeafSchemaNode leaf = (LeafSchemaNode)schemaNode;
            QName leafQName = leaf.getQName();
            Type type = GenHelperUtil.resolveLeafSchemaNodeAsMethod(nodeName, schemaContext, typeBuilder, genCtx, leaf, module, typeProvider);
            if (listKeys.contains(leafQName)) {
                if (type == null) {
                    GenHelperUtil.resolveLeafSchemaNodeAsProperty(nodeName, schemaContext, typeProvider, genCtx, genTOBuilder, leaf, true, module);
                } else {
                    AuxiliaryGenUtils.resolveLeafSchemaNodeAsProperty(nodeName, genTOBuilder, leaf, type, true);
                }
            }
        } else if (schemaNode instanceof LeafListSchemaNode) {
            GenHelperUtil.resolveLeafListSchemaNode(schemaContext, typeBuilder, (LeafListSchemaNode)schemaNode, module, typeProvider, genCtx);
        } else if (schemaNode instanceof ContainerSchemaNode) {
            GenHelperUtil.containerToGenType(module, basePackageName, typeBuilder, typeBuilder, (ContainerSchemaNode)schemaNode, schemaContext, verboseClassComments, genCtx, genTypeBuilders, typeProvider, namespaceType);
        } else if (schemaNode instanceof ListSchemaNode) {
            GenHelperUtil.listToGenType(module, basePackageName, typeBuilder, typeBuilder, (ListSchemaNode)schemaNode, schemaContext, verboseClassComments, genCtx, genTypeBuilders, typeProvider, namespaceType);
        } else if (schemaNode instanceof ChoiceSchemaNode) {
            GenHelperUtil.choiceToGenType(module, schemaContext, verboseClassComments, basePackageName, typeBuilder, (ChoiceSchemaNode)schemaNode, genTypeBuilders, genCtx, typeProvider, namespaceType);
        }
    }

    private static void addSchemaNodeToListTypeBuilders(String nodeName, String basePackageName, DataSchemaNode schemaNode, GeneratedTypeBuilder typeBuilder, GeneratedTypeBuilder genTypeBuilder, List<QName> listKeys, Module module, TypeProvider typeProvider, SchemaContext schemaContext, Map<Module, ModuleContext> genCtx, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, boolean verboseClassComments, BindingNamespaceType namespaceType) {
        Preconditions.checkArgument((schemaNode != null ? 1 : 0) != 0, (Object)"Data Schema Node cannot be NULL.");
        Preconditions.checkArgument((typeBuilder != null ? 1 : 0) != 0, (Object)"Generated Type Builder cannot be NULL.");
        if (schemaNode instanceof LeafSchemaNode) {
            LeafSchemaNode leaf = (LeafSchemaNode)schemaNode;
            QName leafQName = leaf.getQName();
            Type type = GenHelperUtil.resolveLeafSchemaNodeAsMethod(nodeName, schemaContext, typeBuilder, genCtx, leaf, module, typeProvider);
            if (listKeys.contains(leafQName)) {
                GenHelperUtil.resolveLeafSchemaNodeAsMethod(nodeName, schemaContext, genTypeBuilder, genCtx, leaf, module, typeProvider);
            }
        } else if (schemaNode instanceof LeafListSchemaNode) {
            GenHelperUtil.resolveLeafListSchemaNode(schemaContext, typeBuilder, (LeafListSchemaNode)schemaNode, module, typeProvider, genCtx);
        } else if (schemaNode instanceof ContainerSchemaNode) {
            GenHelperUtil.containerToGenType(module, basePackageName, typeBuilder, typeBuilder, (ContainerSchemaNode)schemaNode, schemaContext, verboseClassComments, genCtx, genTypeBuilders, typeProvider, namespaceType);
        } else if (schemaNode instanceof ListSchemaNode) {
            GenHelperUtil.listToGenType(module, basePackageName, typeBuilder, typeBuilder, (ListSchemaNode)schemaNode, schemaContext, verboseClassComments, genCtx, genTypeBuilders, typeProvider, namespaceType);
        } else if (schemaNode instanceof ChoiceSchemaNode) {
            GenHelperUtil.choiceToGenType(module, schemaContext, verboseClassComments, basePackageName, typeBuilder, (ChoiceSchemaNode)schemaNode, genTypeBuilders, genCtx, typeProvider, namespaceType);
        }
    }

    private static boolean resolveLeafSchemaNodeAsProperty(String nodeName, SchemaContext schemaContext, TypeProvider typeProvider, Map<Module, ModuleContext> genCtx, GeneratedTOBuilder toBuilder, LeafSchemaNode leaf, boolean isReadOnly, Module module) {
        if (leaf != null && toBuilder != null) {
            Type returnType;
            TypeDefinition typeDef = leaf.getType();
            if (typeDef instanceof UnionTypeDefinition) {
                QName qname = typeDef.getQName();
                Module unionModule = schemaContext.findModuleByNamespaceAndRevision(qname.getNamespace(), qname.getRevision());
                ModuleContext mc = genCtx.get(unionModule);
                returnType = (Type)mc.getTypedefs().get(typeDef.getPath());
            } else if (typeDef instanceof EnumTypeDefinition && typeDef.getBaseType() == null) {
                LeafSchemaNode originalLeaf = (LeafSchemaNode)SchemaNodeUtils.getRootOriginalIfPossible((SchemaNode)leaf);
                QName qname = originalLeaf.getQName();
                Module enumModule = schemaContext.findModuleByNamespaceAndRevision(qname.getNamespace(), qname.getRevision());
                returnType = genCtx.get(enumModule).getInnerType(originalLeaf.getType().getPath());
            } else {
                returnType = typeProvider.javaTypeForSchemaDefinitionType(typeDef, (SchemaNode)leaf, genCtx.get(module));
            }
            return AuxiliaryGenUtils.resolveLeafSchemaNodeAsProperty(nodeName, toBuilder, leaf, returnType, isReadOnly);
        }
        return false;
    }

    private static TypeDefinition<?> getBaseOrDeclaredType(TypeDefinition<?> typeDef) {
        TypeDefinition baseType = typeDef.getBaseType();
        return baseType != null && baseType.getBaseType() != null ? baseType : typeDef;
    }

    private static GeneratedTypeBuilder processDataSchemaNode(Module module, String basePackageName, GeneratedTypeBuilder childOf, DataSchemaNode node, SchemaContext schemaContext, boolean verboseClassComments, Map<Module, ModuleContext> genCtx, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, TypeProvider typeProvider, BindingNamespaceType namespaceType) {
        GeneratedTypeBuilder genType = GenHelperUtil.addDefaultInterfaceDefinition(basePackageName, (SchemaNode)node, (Type)childOf, module, genCtx, schemaContext, verboseClassComments, genTypeBuilders, typeProvider, namespaceType);
        genType.addComment(node.getDescription());
        AuxiliaryGenUtils.annotateDeprecatedIfNecessary(node.getStatus(), genType);
        genType.setDescription(AuxiliaryGenUtils.createDescription((SchemaNode)node, genType.getFullyQualifiedName(), schemaContext, verboseClassComments, namespaceType));
        genType.setModuleName(module.getName());
        genType.setReference(node.getReference());
        genType.setSchemaPath((List)node.getPath().getPathFromRoot());
        genType.setParentTypeForBuilder((Type)childOf);
        if (node instanceof DataNodeContainer) {
            genCtx.get(module).addChildNodeType((SchemaNode)node, genType);
        }
        return genType;
    }

    static Map<Module, ModuleContext> groupingsToGenTypes(Module module, Collection<GroupingDefinition> groupings, Map<Module, ModuleContext> genCtx, SchemaContext schemaContext, boolean verboseClassComments, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, TypeProvider typeProvider) {
        String basePackageName = BindingMapping.getRootPackageName((Module)module);
        List<GroupingDefinition> groupingsSortedByDependencies = new GroupingDefinitionDependencySort().sort(groupings);
        for (GroupingDefinition grouping : groupingsSortedByDependencies) {
            genCtx = GenHelperUtil.groupingToGenType(basePackageName, grouping, module, genCtx, schemaContext, verboseClassComments, genTypeBuilders, typeProvider);
        }
        return genCtx;
    }

    private static Map<Module, ModuleContext> groupingToGenType(String basePackageName, GroupingDefinition grouping, Module module, Map<Module, ModuleContext> genCtx, SchemaContext schemaContext, boolean verboseClassComments, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, TypeProvider typeProvider) {
        GeneratedTypeBuilder genType = GenHelperUtil.addDefaultInterfaceDefinition(basePackageName, (SchemaNode)grouping, module, genCtx, schemaContext, verboseClassComments, genTypeBuilders, typeProvider, BindingNamespaceType.Grouping);
        AuxiliaryGenUtils.annotateDeprecatedIfNecessary(grouping.getStatus(), genType);
        genCtx.get(module).addGroupingType(grouping, genType);
        GenHelperUtil.resolveDataSchemaNodes(module, basePackageName, genType, genType, grouping.getChildNodes(), genCtx, schemaContext, verboseClassComments, genTypeBuilders, typeProvider, BindingNamespaceType.Grouping);
        genCtx = GenHelperUtil.processUsesImplements(grouping, module, schemaContext, genCtx, BindingNamespaceType.Grouping);
        return genCtx;
    }

    static Map<Module, ModuleContext> identityToGenType(Module module, String basePackageName, IdentitySchemaNode identity, SchemaContext schemaContext, Map<Module, ModuleContext> genCtx, boolean verboseClassComments) {
        GenHelperUtil.resolveIdentitySchemaNode(basePackageName, schemaContext, identity, module, verboseClassComments, genCtx);
        return genCtx;
    }

    private static GeneratedTOBuilder resolveIdentitySchemaNode(String basePackageName, SchemaContext schemaContext, IdentitySchemaNode identity, Module module, boolean verboseClassComments, Map<Module, ModuleContext> genCtx) {
        Preconditions.checkNotNull((Object)identity, (Object)"Identity can not be null!");
        GeneratedTOBuilder newType = GenHelperUtil.findIdentityByQname(identity.getQName(), genCtx);
        if (newType == null) {
            Module parentModule = SchemaContextUtil.findParentModule((SchemaContext)schemaContext, (SchemaNode)identity);
            Preconditions.checkState((boolean)module.equals(parentModule), (Object)"If the type is null ,it must be in the same module, otherwise it must has beenresolved by an imported module.");
            String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)identity.getPath(), (BindingNamespaceType)BindingNamespaceType.Identity);
            newType = new GeneratedTOBuilderImpl(packageName, identity.getQName().getLocalName(), true, false, genCtx.get(module));
            Set baseIdentities = identity.getBaseIdentities();
            if (baseIdentities.size() == 0) {
                GeneratedTOBuilderImpl gto = new GeneratedTOBuilderImpl(BaseIdentity.class.getPackage().getName(), BaseIdentity.class.getSimpleName(), genCtx.get(module));
                newType.setExtendsType(gto.toInstance());
            } else {
                IdentitySchemaNode baseIdentity = (IdentitySchemaNode)baseIdentities.iterator().next();
                GeneratedTOBuilder baseType = GenHelperUtil.resolveIdentitySchemaNode(basePackageName, schemaContext, baseIdentity, module, verboseClassComments, genCtx);
                newType.setExtendsType(baseType.toInstance());
            }
            newType.setAbstract(true);
            newType.addComment(identity.getDescription());
            newType.setDescription(AuxiliaryGenUtils.createDescription((SchemaNode)identity, newType.getFullyQualifiedName(), schemaContext, verboseClassComments, BindingNamespaceType.Identity));
            newType.setReference(identity.getReference());
            newType.setModuleName(module.getName());
            newType.setSchemaPath((List)identity.getPath().getPathFromRoot());
            AuxiliaryGenUtils.qNameConstant(newType, "QNAME", identity.getQName());
            genCtx.get(module).addIdentityType(identity.getQName(), newType);
        }
        return newType;
    }
}

