/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.javav2.generator.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.mdsal.binding.javav2.generator.api.BindingGenerator;
import org.opendaylight.mdsal.binding.javav2.generator.context.ModuleContext;
import org.opendaylight.mdsal.binding.javav2.generator.impl.AugmentToGenType;
import org.opendaylight.mdsal.binding.javav2.generator.impl.ModuleToGenType;
import org.opendaylight.mdsal.binding.javav2.generator.spi.TypeProvider;
import org.opendaylight.mdsal.binding.javav2.generator.yang.types.TypeProviderImpl;
import org.opendaylight.mdsal.binding.javav2.model.api.Type;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.parser.util.ModuleDependencySort;

@Beta
public class BindingGeneratorImpl
implements BindingGenerator {
    private final boolean verboseClassComments;
    private Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders = new HashMap<String, Map<String, GeneratedTypeBuilder>>();
    private Map<Module, ModuleContext> genCtx = new HashMap<Module, ModuleContext>();
    private TypeProvider typeProvider;

    public BindingGeneratorImpl(boolean verboseClassComments) {
        this.verboseClassComments = verboseClassComments;
    }

    public List<Type> generateTypes(SchemaContext context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"Schema Context reference cannot be NULL.");
        Preconditions.checkState((context.getModules() != null ? 1 : 0) != 0, (Object)"Schema Context does not contain defined modules.");
        Set modules = context.getModules();
        return this.generateTypes(context, modules);
    }

    public List<Type> generateTypes(SchemaContext context, Set<Module> modules) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"Schema Context reference cannot be NULL.");
        Preconditions.checkState((context.getModules() != null ? 1 : 0) != 0, (Object)"Schema Context does not contain defined modules.");
        Preconditions.checkArgument((modules != null ? 1 : 0) != 0, (Object)"Set of Modules cannot be NULL.");
        this.typeProvider = new TypeProviderImpl(context);
        List contextModules = ModuleDependencySort.sort((Iterable)context.getModules());
        this.genTypeBuilders = new HashMap<String, Map<String, GeneratedTypeBuilder>>();
        for (Module contextModule : contextModules) {
            this.genCtx = ModuleToGenType.generate(contextModule, this.genTypeBuilders, context, this.typeProvider, this.genCtx, this.verboseClassComments);
            this.genCtx.get(contextModule).cleanPackagesMap();
        }
        for (Module contextModule : contextModules) {
            this.genCtx = AugmentToGenType.generate(contextModule, context, this.typeProvider, this.genCtx, this.genTypeBuilders, this.verboseClassComments);
            this.genCtx.get(contextModule).cleanPackagesMap();
        }
        ArrayList<Type> filteredGenTypes = new ArrayList<Type>();
        for (Module m : modules) {
            ModuleContext ctx = (ModuleContext)Preconditions.checkNotNull((Object)this.genCtx.get(m), (String)"Module context not found for module %s", (Object[])new Object[]{m});
            filteredGenTypes.addAll(ctx.getGeneratedTypes());
            Set<Type> additionalTypes = ((TypeProviderImpl)this.typeProvider).getAdditionalTypes().get(m);
            if (additionalTypes == null) continue;
            filteredGenTypes.addAll(additionalTypes);
        }
        return filteredGenTypes;
    }

    public Map<Module, ModuleContext> getModuleContexts(SchemaContext schemaContext) {
        this.generateTypes(schemaContext);
        return this.genCtx;
    }
}

