/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.javav2.generator.impl;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.opendaylight.mdsal.binding.javav2.generator.context.ModuleContext;
import org.opendaylight.mdsal.binding.javav2.generator.impl.txt.yangTemplateForModule;
import org.opendaylight.mdsal.binding.javav2.generator.impl.txt.yangTemplateForNode;
import org.opendaylight.mdsal.binding.javav2.generator.impl.txt.yangTemplateForNodes;
import org.opendaylight.mdsal.binding.javav2.generator.impl.util.YangTextTemplate;
import org.opendaylight.mdsal.binding.javav2.generator.spi.TypeProvider;
import org.opendaylight.mdsal.binding.javav2.generator.util.BindingGeneratorUtil;
import org.opendaylight.mdsal.binding.javav2.generator.util.JavaIdentifier;
import org.opendaylight.mdsal.binding.javav2.generator.util.JavaIdentifierNormalizer;
import org.opendaylight.mdsal.binding.javav2.generator.util.Types;
import org.opendaylight.mdsal.binding.javav2.generator.util.YangSnippetCleaner;
import org.opendaylight.mdsal.binding.javav2.generator.util.generated.type.builder.GeneratedTOBuilderImpl;
import org.opendaylight.mdsal.binding.javav2.generator.util.generated.type.builder.GeneratedTypeBuilderImpl;
import org.opendaylight.mdsal.binding.javav2.generator.yang.types.TypeProviderImpl;
import org.opendaylight.mdsal.binding.javav2.model.api.Constant;
import org.opendaylight.mdsal.binding.javav2.model.api.Type;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.EnumBuilder;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.mdsal.binding.javav2.spec.runtime.BindingNamespaceType;
import org.opendaylight.mdsal.binding.javav2.util.BindingMapping;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.OperationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;

@Beta
final class AuxiliaryGenUtils {
    private static final Splitter BSDOT_SPLITTER = Splitter.on((String)".");
    private static final char NEW_LINE = '\n';
    private static final Pattern UNICODE_CHAR_PATTERN = Pattern.compile("\\\\+u");
    private static final String AUGMENT_IDENTIFIER_NAME = "augment-identifier";
    private static final String YANG_EXT_NAMESPACE = "urn:opendaylight:yang:extension:yang-ext";

    private AuxiliaryGenUtils() {
        throw new UnsupportedOperationException("Util class");
    }

    static void annotateDeprecatedIfNecessary(Status status, GeneratedTypeBuilder builder) {
        if (status == Status.DEPRECATED) {
            builder.addAnnotation("", "Deprecated");
        }
    }

    public static boolean hasBuilderClass(SchemaNode schemaNode, BindingNamespaceType namespaceType) {
        return namespaceType.equals((Object)BindingNamespaceType.Data) && (schemaNode instanceof ContainerSchemaNode || schemaNode instanceof ListSchemaNode || schemaNode instanceof RpcDefinition || schemaNode instanceof NotificationDefinition || schemaNode instanceof ChoiceCaseNode);
    }

    static Constant qNameConstant(GeneratedTypeBuilderBase<?> toBuilder, String constantName, QName name) {
        return toBuilder.addConstant((Type)Types.typeForClass(QName.class), constantName, (Object)name);
    }

    static MethodSignatureBuilder constructGetter(GeneratedTypeBuilder interfaceBuilder, String schemaNodeName, String comment, Type returnType, Status status) {
        MethodSignatureBuilder getMethod = interfaceBuilder.addMethod(AuxiliaryGenUtils.getterMethodName(schemaNodeName, returnType));
        if (status == Status.DEPRECATED) {
            getMethod.addAnnotation("", "Deprecated");
        }
        getMethod.setComment(BindingGeneratorUtil.encodeAngleBrackets((String)comment));
        getMethod.setReturnType(returnType);
        return getMethod;
    }

    private static String getterMethodName(String localName, Type returnType) {
        StringBuilder method = new StringBuilder();
        if (Types.BOOLEAN.equals(returnType)) {
            method.append("is");
        } else {
            method.append("get");
        }
        return method.append(JavaIdentifierNormalizer.normalizeSpecificIdentifier((String)localName, (JavaIdentifier)JavaIdentifier.CLASS)).toString();
    }

    static String createDescription(SchemaNode schemaNode, String fullyQualifiedName, SchemaContext schemaContext, boolean verboseClassComments, BindingNamespaceType namespaceType) {
        StringBuilder sb = new StringBuilder();
        String nodeDescription = BindingGeneratorUtil.encodeAngleBrackets((String)schemaNode.getDescription());
        String formattedDescription = YangTextTemplate.formatToParagraph(nodeDescription, 0);
        if (!Strings.isNullOrEmpty((String)formattedDescription)) {
            sb.append(formattedDescription);
            sb.append('\n');
        }
        Module module = SchemaContextUtil.findParentModule((SchemaContext)schemaContext, (SchemaNode)schemaNode);
        if (verboseClassComments) {
            sb.append("<p>");
            sb.append("This class represents the following YANG schema fragment defined in module <b>");
            sb.append(module.getName());
            sb.append("</b>");
            sb.append('\n');
            sb.append("<pre>");
            sb.append('\n');
            String formedYang = YangSnippetCleaner.clean((String)yangTemplateForNode.render(schemaNode, module).body());
            sb.append(BindingGeneratorUtil.encodeAngleBrackets((String)formedYang));
            sb.append("</pre>");
            sb.append('\n');
            sb.append("The schema path to identify an instance is");
            sb.append('\n');
            sb.append("<i>");
            sb.append(YangTextTemplate.formatSchemaPath(module.getName(), schemaNode.getPath().getPathFromRoot()));
            sb.append("</i>");
            sb.append('\n');
            if (AuxiliaryGenUtils.hasBuilderClass(schemaNode, namespaceType) && !(schemaNode instanceof OperationDefinition)) {
                StringBuilder linkToBuilderClass = new StringBuilder();
                String basePackageName = BindingMapping.getRootPackageName((Module)module);
                linkToBuilderClass.append(BindingGeneratorUtil.replacePackageTopNamespace((String)basePackageName, (String)fullyQualifiedName, (BindingNamespaceType)namespaceType, (BindingNamespaceType)BindingNamespaceType.Builder)).append("Builder");
                sb.append('\n');
                sb.append("<p>To create instances of this class use {@link " + linkToBuilderClass + "}.");
                sb.append('\n');
                sb.append("@see ");
                sb.append((CharSequence)linkToBuilderClass);
                sb.append('\n');
                if (schemaNode instanceof ListSchemaNode) {
                    StringBuilder linkToKeyClass = new StringBuilder();
                    String[] namespace = (String[])Iterables.toArray((Iterable)BSDOT_SPLITTER.split((CharSequence)fullyQualifiedName), String.class);
                    String className = namespace[namespace.length - 1];
                    linkToKeyClass.append(BindingGeneratorUtil.packageNameForSubGeneratedType((String)basePackageName, (SchemaNode)schemaNode, (BindingNamespaceType)BindingNamespaceType.Key)).append('.').append(className).append("Key");
                    List keyDef = ((ListSchemaNode)schemaNode).getKeyDefinition();
                    if (keyDef != null && !keyDef.isEmpty()) {
                        sb.append("@see ");
                        sb.append((CharSequence)linkToKeyClass);
                    }
                    sb.append('\n');
                }
            }
        }
        return AuxiliaryGenUtils.replaceAllIllegalChars(sb);
    }

    static String createDescription(Module module, boolean verboseClassComments) {
        StringBuilder sb = new StringBuilder();
        String moduleDescription = BindingGeneratorUtil.encodeAngleBrackets((String)module.getDescription());
        String formattedDescription = YangTextTemplate.formatToParagraph(moduleDescription, 0);
        if (!Strings.isNullOrEmpty((String)formattedDescription)) {
            sb.append(formattedDescription);
            sb.append('\n');
        }
        if (verboseClassComments) {
            sb.append("<p>");
            sb.append("This class represents the following YANG schema fragment defined in module <b>");
            sb.append(module.getName());
            sb.append("</b>");
            sb.append('\n');
            sb.append("<pre>");
            sb.append('\n');
            String formedYang = YangSnippetCleaner.clean((String)yangTemplateForModule.render(module).body());
            sb.append(BindingGeneratorUtil.encodeAngleBrackets((String)formedYang));
            sb.append("</pre>");
        }
        return AuxiliaryGenUtils.replaceAllIllegalChars(sb);
    }

    static String createDescription(Set<? extends SchemaNode> schemaNodes, Module module, boolean verboseClassComments) {
        StringBuilder sb = new StringBuilder();
        if (!AuxiliaryGenUtils.isNullOrEmpty(schemaNodes)) {
            SchemaNode node = schemaNodes.iterator().next();
            if (node instanceof RpcDefinition) {
                sb.append("Interface for implementing the following YANG RPCs defined in module <b>" + module.getName() + "</b>");
            } else if (node instanceof NotificationDefinition) {
                sb.append("Interface for receiving the following YANG notifications defined in module <b>" + module.getName() + "</b>");
            }
        }
        sb.append('\n');
        if (verboseClassComments) {
            sb.append("<pre>");
            sb.append('\n');
            sb.append(BindingGeneratorUtil.encodeAngleBrackets((String)yangTemplateForNodes.render(schemaNodes, module).body()));
            sb.append("</pre>");
            sb.append('\n');
        }
        return AuxiliaryGenUtils.replaceAllIllegalChars(sb);
    }

    private static boolean isNullOrEmpty(Collection<?> list) {
        return list == null || list.isEmpty();
    }

    static String augGenTypeName(Map<String, GeneratedTypeBuilder> builders, String genTypeName) {
        int index = 1;
        if (builders != null) {
            while (builders.containsKey(genTypeName + index)) {
                ++index;
            }
        }
        return genTypeName + index;
    }

    static String getAugmentIdentifier(List<UnknownSchemaNode> unknownSchemaNodes) {
        for (UnknownSchemaNode unknownSchemaNode : unknownSchemaNodes) {
            QName nodeType = unknownSchemaNode.getNodeType();
            if (!AUGMENT_IDENTIFIER_NAME.equals(nodeType.getLocalName()) || !YANG_EXT_NAMESPACE.equals(nodeType.getNamespace().toString())) continue;
            return unknownSchemaNode.getNodeParameter();
        }
        return null;
    }

    static EnumBuilder resolveInnerEnumFromTypeDefinition(EnumTypeDefinition enumTypeDef, QName enumName, Map<Module, ModuleContext> genCtx, GeneratedTypeBuilder typeBuilder, Module module) {
        if (enumTypeDef != null && typeBuilder != null && enumTypeDef.getQName().getLocalName() != null) {
            EnumBuilder enumBuilder = typeBuilder.addEnumeration(enumName.getLocalName(), genCtx.get(module));
            String enumTypedefDescription = BindingGeneratorUtil.encodeAngleBrackets((String)enumTypeDef.getDescription());
            enumBuilder.setDescription(enumTypedefDescription);
            enumBuilder.updateEnumPairsFromEnumTypeDef(enumTypeDef);
            ModuleContext ctx = genCtx.get(module);
            ctx.addInnerTypedefType(enumTypeDef.getPath(), (Type)enumBuilder);
            return enumBuilder;
        }
        return null;
    }

    static GeneratedTOBuilder addTOToTypeBuilder(TypeDefinition<?> typeDef, GeneratedTypeBuilder typeBuilder, DataSchemaNode leaf, Module parentModule, TypeProvider typeProvider, SchemaContext schemaContext, ModuleContext context, Map<Module, ModuleContext> genCtx) {
        String classNameFromLeaf = leaf.getQName().getLocalName();
        GeneratedTOBuilder genTOBuilder = null;
        String packageName = typeBuilder.getFullyQualifiedName();
        if (typeDef instanceof UnionTypeDefinition) {
            genTOBuilder = ((TypeProviderImpl)typeProvider).provideGeneratedTOBuilderForUnionTypeDef(packageName, (UnionTypeDefinition)typeDef, classNameFromLeaf, (SchemaNode)leaf, schemaContext, ((TypeProviderImpl)typeProvider).getGenTypeDefsContextMap(), context);
        } else if (typeDef instanceof BitsTypeDefinition) {
            genTOBuilder = ((TypeProviderImpl)typeProvider).provideGeneratedTOBuilderForBitsTypeDefinition(packageName, typeDef, classNameFromLeaf, parentModule.getName(), context);
        }
        if (genTOBuilder != null) {
            typeBuilder.addEnclosingTransferObject(genTOBuilder);
            genCtx.get(parentModule).addInnerTypedefType(typeDef.getPath(), (Type)genTOBuilder);
            return genTOBuilder;
        }
        return null;
    }

    static Type createReturnTypeForUnion(GeneratedTOBuilder genTOBuilder, TypeDefinition<?> typeDef, GeneratedTypeBuilder typeBuilder, Module parentModule, TypeProvider typeProvider) {
        GeneratedTOBuilderImpl returnType = (GeneratedTOBuilderImpl)genTOBuilder;
        String typedefDescription = BindingGeneratorUtil.encodeAngleBrackets((String)typeDef.getDescription());
        returnType.setDescription(typedefDescription);
        returnType.setReference(typeDef.getReference());
        returnType.setSchemaPath((List)typeDef.getPath().getPathFromRoot());
        returnType.setModuleName(parentModule.getName());
        genTOBuilder.setTypedef(true);
        genTOBuilder.setIsUnion(true);
        TypeProviderImpl.addUnitsToGenTO(genTOBuilder, typeDef.getUnits());
        return returnType.toInstance();
    }

    static boolean isInnerType(LeafSchemaNode leaf, TypeDefinition<?> type) {
        return leaf.getPath().equals((Object)type.getPath()) || leaf.getPath().equals((Object)type.getPath().getParent());
    }

    static GeneratedTOBuilder resolveListKeyTOBuilder(String packageName, ListSchemaNode list, ModuleContext context) {
        GeneratedTOBuilderImpl genTOBuilder = null;
        if (list.getKeyDefinition() != null && !list.getKeyDefinition().isEmpty()) {
            String genTOName = list.getQName().getLocalName() + '_' + BindingNamespaceType.Key;
            genTOBuilder = new GeneratedTOBuilderImpl(packageName, genTOName, context);
        }
        return genTOBuilder;
    }

    static GeneratedTypeBuilder resolveListKeyTypeBuilder(String packageName, ListSchemaNode list, ModuleContext context) {
        GeneratedTypeBuilderImpl genTypeBuilder = null;
        if (list.getKeyDefinition() != null && !list.getKeyDefinition().isEmpty()) {
            String genTOName = list.getQName().getLocalName() + '_' + BindingNamespaceType.Key;
            genTypeBuilder = new GeneratedTypeBuilderImpl(packageName, genTOName, context);
        }
        return genTypeBuilder;
    }

    static boolean resolveLeafSchemaNodeAsProperty(String nodeName, GeneratedTOBuilder toBuilder, LeafSchemaNode leaf, Type returnType, boolean isReadOnly) {
        String leafGetterName;
        if (returnType == null) {
            return false;
        }
        String leafName = leaf.getQName().getLocalName();
        if ("key".equals(leafName.toLowerCase())) {
            StringBuilder sb = new StringBuilder(leafName).append('_').append("RESERVED_WORD");
            leafGetterName = sb.toString();
        } else {
            leafGetterName = leafName;
        }
        String leafDesc = BindingGeneratorUtil.encodeAngleBrackets((String)leaf.getDescription());
        GeneratedPropertyBuilder propBuilder = toBuilder.addProperty(JavaIdentifierNormalizer.normalizeSpecificIdentifier((String)leafGetterName, (JavaIdentifier)JavaIdentifier.METHOD));
        propBuilder.setReadOnly(isReadOnly);
        propBuilder.setReturnType(returnType);
        propBuilder.setComment(leafDesc);
        toBuilder.addEqualsIdentity(propBuilder);
        toBuilder.addHashIdentity(propBuilder);
        toBuilder.addToStringProperty(propBuilder);
        return true;
    }

    static void checkModuleAndModuleName(Module module) {
        Preconditions.checkArgument((module != null ? 1 : 0) != 0, (Object)"Module reference cannot be NULL.");
        Preconditions.checkArgument((module.getName() != null ? 1 : 0) != 0, (Object)"Module name cannot be NULL.");
    }

    @VisibleForTesting
    public static String replaceAllIllegalChars(StringBuilder stringBuilder) {
        String ret = UNICODE_CHAR_PATTERN.matcher(stringBuilder).replaceAll("\\\\\\\\u");
        return ret.isEmpty() ? "" : ret;
    }
}

