/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.javav2.generator.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opendaylight.mdsal.binding.javav2.generator.context.ModuleContext;
import org.opendaylight.mdsal.binding.javav2.generator.impl.GenHelperUtil;
import org.opendaylight.mdsal.binding.javav2.generator.spi.TypeProvider;
import org.opendaylight.mdsal.binding.javav2.generator.util.BindingGeneratorUtil;
import org.opendaylight.mdsal.binding.javav2.model.api.Type;
import org.opendaylight.mdsal.binding.javav2.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.javav2.spec.runtime.BindingNamespaceType;
import org.opendaylight.mdsal.binding.javav2.util.BindingMapping;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;

@Beta
final class AugmentToGenType {
    private static final Comparator<AugmentationSchema> AUGMENT_COMP = (o1, o2) -> {
        Iterator thisIt = o1.getTargetPath().getPathFromRoot().iterator();
        Iterator otherIt = o2.getTargetPath().getPathFromRoot().iterator();
        while (thisIt.hasNext()) {
            if (!otherIt.hasNext()) {
                return 1;
            }
            int comp = ((QName)thisIt.next()).compareTo((QName)otherIt.next());
            if (comp == 0) continue;
            return comp;
        }
        return otherIt.hasNext() ? -1 : 0;
    };
    private static final Comparator<Map.Entry<SchemaPath, List<AugmentationSchema>>> AUGMENTS_COMP = (o1, o2) -> {
        Iterator thisIt = ((SchemaPath)o1.getKey()).getPathFromRoot().iterator();
        Iterator otherIt = ((SchemaPath)o2.getKey()).getPathFromRoot().iterator();
        while (thisIt.hasNext()) {
            if (!otherIt.hasNext()) {
                return 1;
            }
            int comp = ((QName)thisIt.next()).compareTo((QName)otherIt.next());
            if (comp == 0) continue;
            return comp;
        }
        return otherIt.hasNext() ? -1 : 0;
    };

    private AugmentToGenType() {
        throw new UnsupportedOperationException("Utility class");
    }

    static Map<Module, ModuleContext> generate(Module module, SchemaContext schemaContext, TypeProvider typeProvider, Map<Module, ModuleContext> genCtx, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, boolean verboseClassComments) {
        Preconditions.checkArgument((module != null ? 1 : 0) != 0, (Object)"Module reference cannot be NULL.");
        Preconditions.checkArgument((module.getName() != null ? 1 : 0) != 0, (Object)"Module name cannot be NULL.");
        Preconditions.checkState((module.getAugmentations() != null ? 1 : 0) != 0, (Object)"Augmentations Set cannot be NULL.");
        String basePackageName = BindingMapping.getRootPackageName((Module)module);
        List<AugmentationSchema> augmentations = AugmentToGenType.resolveAugmentations(module, schemaContext);
        Map<Module, ModuleContext> resultCtx = genCtx;
        Map<SchemaPath, List<AugmentationSchema>> augmentationsGrouped = augmentations.stream().collect(Collectors.groupingBy(AugmentationSchema::getTargetPath));
        ArrayList<Map.Entry<SchemaPath, List<AugmentationSchema>>> sortedAugmentationsGrouped = new ArrayList<Map.Entry<SchemaPath, List<AugmentationSchema>>>(augmentationsGrouped.entrySet());
        Collections.sort(sortedAugmentationsGrouped, AUGMENTS_COMP);
        for (Map.Entry entry : sortedAugmentationsGrouped) {
            resultCtx = AugmentToGenType.augmentationToGenTypes(basePackageName, entry, module, schemaContext, verboseClassComments, resultCtx, genTypeBuilders, typeProvider);
            for (AugmentationSchema augSchema : (List)entry.getValue()) {
                GenHelperUtil.processUsesImplements(augSchema, module, schemaContext, genCtx, BindingNamespaceType.Data);
            }
        }
        return resultCtx;
    }

    private static List<AugmentationSchema> resolveAugmentations(Module module, SchemaContext schemaContext) {
        Preconditions.checkArgument((module != null ? 1 : 0) != 0, (Object)"Module reference cannot be NULL.");
        Preconditions.checkState((module.getAugmentations() != null ? 1 : 0) != 0, (Object)"Augmentations Set cannot be NULL.");
        Set augmentations = module.getAugmentations();
        List<AugmentationSchema> sortedAugmentations = new ArrayList(augmentations).stream().filter(aug -> !module.equals(AugmentToGenType.findAugmentTargetModule(schemaContext, aug))).collect(Collectors.toList());
        Collections.sort(sortedAugmentations, AUGMENT_COMP);
        return sortedAugmentations;
    }

    public static Module findAugmentTargetModule(SchemaContext schemaContext, AugmentationSchema aug) {
        Preconditions.checkNotNull((Object)aug, (Object)"Augmentation schema can not be null.");
        QName first = (QName)aug.getTargetPath().getPathFromRoot().iterator().next();
        return schemaContext.findModuleByNamespaceAndRevision(first.getNamespace(), first.getRevision());
    }

    private static Map<Module, ModuleContext> augmentationToGenTypes(String basePackageName, Map.Entry<SchemaPath, List<AugmentationSchema>> schemaPathAugmentListEntry, Module module, SchemaContext schemaContext, boolean verboseClassComments, Map<Module, ModuleContext> genCtx, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, TypeProvider typeProvider) {
        Preconditions.checkArgument((basePackageName != null ? 1 : 0) != 0, (Object)"Package Name cannot be NULL.");
        Preconditions.checkArgument((schemaPathAugmentListEntry != null ? 1 : 0) != 0, (Object)"Augmentation List Entry cannot be NULL.");
        SchemaPath targetPath = schemaPathAugmentListEntry.getKey();
        Preconditions.checkState((targetPath != null ? 1 : 0) != 0, (Object)"Augmentation List Entry does not contain Target Path (Target Path is NULL).");
        List<AugmentationSchema> augmentationSchemaList = schemaPathAugmentListEntry.getValue();
        Preconditions.checkState((augmentationSchemaList.size() > 0 ? 1 : 0) != 0, (Object)"Augmentation List cannot be empty.");
        SchemaNode targetSchemaNode = SchemaContextUtil.findDataSchemaNode((SchemaContext)schemaContext, (SchemaPath)targetPath);
        if (targetSchemaNode instanceof DataSchemaNode && ((DataSchemaNode)targetSchemaNode).isAddedByUses()) {
            if (targetSchemaNode instanceof DerivableSchemaNode) {
                targetSchemaNode = (SchemaNode)((DerivableSchemaNode)targetSchemaNode).getOriginal().orNull();
            }
            if (targetSchemaNode == null) {
                throw new IllegalStateException("Failed to find target node from grouping in augmentation " + schemaPathAugmentListEntry.getValue().get(0) + " in module " + module.getName());
            }
        }
        if (targetSchemaNode == null) {
            throw new IllegalArgumentException("augment target not found: " + targetPath);
        }
        GeneratedTypeBuilder targetTypeBuilder = GenHelperUtil.findChildNodeByPath(targetSchemaNode.getPath(), genCtx);
        if (targetTypeBuilder == null) {
            targetTypeBuilder = GenHelperUtil.findCaseByPath(targetSchemaNode.getPath(), genCtx);
        }
        if (targetTypeBuilder == null) {
            throw new NullPointerException("Target type not yet generated: " + targetSchemaNode);
        }
        String augmentPackageName = BindingGeneratorUtil.packageNameWithNamespacePrefix((String)basePackageName, (BindingNamespaceType)BindingNamespaceType.Data);
        genCtx = !(targetSchemaNode instanceof ChoiceSchemaNode) ? GenHelperUtil.addRawAugmentGenTypeDefinition(module, augmentPackageName, (Type)targetTypeBuilder.toInstance(), targetSchemaNode, schemaPathAugmentListEntry.getValue(), genTypeBuilders, genCtx, schemaContext, verboseClassComments, typeProvider, BindingNamespaceType.Data) : AugmentToGenType.generateTypesFromAugmentedChoiceCases(schemaContext, module, basePackageName, (Type)targetTypeBuilder.toInstance(), (ChoiceSchemaNode)targetSchemaNode, schemaPathAugmentListEntry.getValue(), null, genCtx, verboseClassComments, genTypeBuilders, typeProvider, BindingNamespaceType.Data);
        return genCtx;
    }

    @Deprecated
    static Map<Module, ModuleContext> usesAugmentationToGenTypes(SchemaContext schemaContext, String augmentPackageName, List<AugmentationSchema> schemaPathAugmentListEntry, Module module, UsesNode usesNode, DataNodeContainer usesNodeParent, Map<Module, ModuleContext> genCtx, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, boolean verboseClassComments, TypeProvider typeProvider, BindingNamespaceType namespaceType) {
        Preconditions.checkArgument((augmentPackageName != null ? 1 : 0) != 0, (Object)"Package Name cannot be NULL.");
        Preconditions.checkArgument((schemaPathAugmentListEntry != null ? 1 : 0) != 0, (Object)"Augmentation Schema List Entry cannot be NULL.");
        Preconditions.checkState((schemaPathAugmentListEntry.size() > 0 ? 1 : 0) != 0, (Object)"Augmentation Schema List cannot be empty");
        SchemaPath targetPath = schemaPathAugmentListEntry.get(0).getTargetPath();
        Preconditions.checkState((targetPath != null ? 1 : 0) != 0, (Object)"Augmentation Schema does not contain Target Path (Target Path is NULL).");
        DataSchemaNode targetSchemaNode = AugmentToGenType.findOriginalTargetFromGrouping(schemaContext, targetPath, usesNode);
        if (targetSchemaNode == null) {
            throw new IllegalArgumentException("augment target not found: " + targetPath);
        }
        GeneratedTypeBuilder targetTypeBuilder = GenHelperUtil.findChildNodeByPath(targetSchemaNode.getPath(), genCtx);
        if (targetTypeBuilder == null) {
            targetTypeBuilder = GenHelperUtil.findCaseByPath(targetSchemaNode.getPath(), genCtx);
        }
        if (targetTypeBuilder == null) {
            throw new NullPointerException("Target type not yet generated: " + targetSchemaNode);
        }
        if (!(targetSchemaNode instanceof ChoiceSchemaNode)) {
            String packageName = augmentPackageName;
            if (usesNodeParent instanceof SchemaNode) {
                packageName = BindingGeneratorUtil.packageNameForAugmentedGeneratedType((String)augmentPackageName, (SchemaPath)((SchemaNode)usesNodeParent).getPath());
            } else if (usesNodeParent instanceof AugmentationSchema) {
                Type parentTypeBuilder = (Type)genCtx.get(module).getTargetToAugmentation().get((Object)((AugmentationSchema)usesNodeParent).getTargetPath());
                packageName = BindingGeneratorUtil.packageNameForAugmentedGeneratedType((String)parentTypeBuilder.getPackageName(), (AugmentationSchema)((AugmentationSchema)usesNodeParent));
            }
            genCtx = GenHelperUtil.addRawAugmentGenTypeDefinition(module, packageName, (Type)targetTypeBuilder.toInstance(), (SchemaNode)targetSchemaNode, schemaPathAugmentListEntry, genTypeBuilders, genCtx, schemaContext, verboseClassComments, typeProvider, namespaceType);
            return genCtx;
        }
        genCtx = AugmentToGenType.generateTypesFromAugmentedChoiceCases(schemaContext, module, augmentPackageName, (Type)targetTypeBuilder.toInstance(), (ChoiceSchemaNode)targetSchemaNode, schemaPathAugmentListEntry, usesNodeParent, genCtx, verboseClassComments, genTypeBuilders, typeProvider, namespaceType);
        return genCtx;
    }

    private static DataSchemaNode findOriginalTargetFromGrouping(SchemaContext schemaContext, SchemaPath targetPath, UsesNode parentUsesNode) {
        Object targetGrouping = null;
        QName current = (QName)parentUsesNode.getGroupingPath().getPathFromRoot().iterator().next();
        Module module = schemaContext.findModuleByNamespaceAndRevision(current.getNamespace(), current.getRevision());
        if (module == null) {
            throw new IllegalArgumentException("Fialed to find module for grouping in: " + parentUsesNode);
        }
        for (Object group : module.getGroupings()) {
            if (!group.getQName().equals((Object)current)) continue;
            targetGrouping = group;
            break;
        }
        if (targetGrouping == null) {
            throw new IllegalArgumentException("Failed to generate code for augment in " + parentUsesNode);
        }
        Object result2 = targetGrouping;
        for (QName node : targetPath.getPathFromRoot()) {
            if (result2 instanceof DataNodeContainer) {
                QName resultNode = QName.create((QNameModule)result2.getQName().getModule(), (String)node.getLocalName());
                result2 = ((DataNodeContainer)result2).getDataChildByName(resultNode);
                continue;
            }
            if (!(result2 instanceof ChoiceSchemaNode)) continue;
            result2 = ((ChoiceSchemaNode)result2).getCaseNodeByName(node.getLocalName());
        }
        if (result2 == null) {
            return null;
        }
        if (result2 instanceof DerivableSchemaNode) {
            DerivableSchemaNode castedResult = (DerivableSchemaNode)result2;
            Optional originalNode = castedResult.getOriginal();
            if (castedResult.isAddedByUses() && originalNode.isPresent()) {
                result2 = (SchemaNode)originalNode.get();
            }
        }
        if (result2 instanceof DataSchemaNode) {
            DataSchemaNode resultDataSchemaNode = (DataSchemaNode)result2;
            if (resultDataSchemaNode.isAddedByUses()) {
                throw new IllegalStateException("Failed to generate code for augment in " + parentUsesNode);
            }
            return resultDataSchemaNode;
        }
        throw new IllegalStateException("Target node of uses-augment statement must be DataSchemaNode. Failed to generate code for augment in " + parentUsesNode);
    }

    private static Map<Module, ModuleContext> generateTypesFromAugmentedChoiceCases(SchemaContext schemaContext, Module module, String basePackageName, Type targetType, ChoiceSchemaNode targetNode, List<AugmentationSchema> schemaPathAugmentListEntry, DataNodeContainer usesNodeParent, Map<Module, ModuleContext> genCtx, boolean verboseClassComments, Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders, TypeProvider typeProvider, BindingNamespaceType namespaceType) {
        Preconditions.checkArgument((basePackageName != null ? 1 : 0) != 0, (Object)"Base Package Name cannot be NULL.");
        Preconditions.checkArgument((targetType != null ? 1 : 0) != 0, (Object)"Referenced Choice Type cannot be NULL.");
        Preconditions.checkArgument((schemaPathAugmentListEntry != null ? 1 : 0) != 0, (Object)"Set of Choice Case Nodes cannot be NULL.");
        for (AugmentationSchema augmentationSchema : schemaPathAugmentListEntry) {
            for (DataSchemaNode caseNode : augmentationSchema.getChildNodes()) {
                if (caseNode == null) continue;
                GeneratedTypeBuilder caseTypeBuilder = GenHelperUtil.addDefaultInterfaceDefinition(basePackageName, (SchemaNode)caseNode, module, genCtx, schemaContext, verboseClassComments, genTypeBuilders, typeProvider, namespaceType);
                caseTypeBuilder.addImplementsType(targetType);
                SchemaPath nodeSp = targetNode.getPath();
                SchemaNode parent = SchemaContextUtil.findDataSchemaNode((SchemaContext)schemaContext, (SchemaPath)nodeSp.getParent());
                GeneratedTypeBuilder childOfType = null;
                if (parent instanceof Module) {
                    childOfType = genCtx.get(parent).getModuleNode();
                } else if (parent instanceof ChoiceCaseNode) {
                    childOfType = GenHelperUtil.findCaseByPath(parent.getPath(), genCtx);
                } else if (parent instanceof DataSchemaNode || parent instanceof NotificationDefinition) {
                    childOfType = GenHelperUtil.findChildNodeByPath(parent.getPath(), genCtx);
                } else if (parent instanceof GroupingDefinition) {
                    childOfType = GenHelperUtil.findGroupingByPath(parent.getPath(), genCtx);
                }
                if (childOfType == null) {
                    throw new IllegalArgumentException("Failed to find parent type of choice " + targetNode);
                }
                ChoiceCaseNode node = null;
                String caseLocalName = caseNode.getQName().getLocalName();
                if (caseNode instanceof ChoiceCaseNode) {
                    node = (ChoiceCaseNode)caseNode;
                } else if (targetNode.getCaseNodeByName(caseLocalName) == null) {
                    String targetNodeLocalName = targetNode.getQName().getLocalName();
                    for (DataSchemaNode dataSchemaNode : usesNodeParent.getChildNodes()) {
                        if (!(dataSchemaNode instanceof ChoiceSchemaNode) || !targetNodeLocalName.equals(dataSchemaNode.getQName().getLocalName())) continue;
                        node = ((ChoiceSchemaNode)dataSchemaNode).getCaseNodeByName(caseLocalName);
                        break;
                    }
                } else {
                    node = targetNode.getCaseNodeByName(caseLocalName);
                }
                Collection childNodes = node.getChildNodes();
                if (childNodes != null) {
                    GenHelperUtil.resolveDataSchemaNodes(module, basePackageName, caseTypeBuilder, childOfType, childNodes, genCtx, schemaContext, verboseClassComments, genTypeBuilders, typeProvider, namespaceType);
                    GenHelperUtil.processUsesImplements(node, module, schemaContext, genCtx, namespaceType);
                }
                genCtx.get(module).addCaseType(caseNode.getPath(), caseTypeBuilder);
                genCtx.get(module).addChoiceToCaseMapping(targetType, (Type)caseTypeBuilder, node);
            }
        }
        return genCtx;
    }
}

