/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.infrautils.diagstatus;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Immutable;
import com.google.gson.annotations.SerializedName;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.infrautils.diagstatus.ServiceState;

@Immutable
public final class ServiceDescriptor {
    private final String serviceName;
    private final ServiceState effectiveStatus;
    @SerializedName(value="reportedStatusDescription")
    private final String statusDesc;
    private final Instant statusTimestamp;
    private final @Nullable Throwable errorCause;

    private ServiceDescriptor(String serviceName, ServiceState svcState, String statusDesc, Throwable errorCause) {
        this.serviceName = Objects.requireNonNull(serviceName, "serviceName");
        this.effectiveStatus = Objects.requireNonNull(svcState, "svcState");
        this.statusDesc = Objects.requireNonNull(statusDesc, "statusDesc");
        this.statusTimestamp = Instant.now();
        this.errorCause = errorCause;
    }

    public ServiceDescriptor(String moduleServiceName, ServiceState svcState) {
        this(moduleServiceName, svcState, "", null);
    }

    public ServiceDescriptor(String moduleServiceName, ServiceState svcState, String statusDesc) {
        this(moduleServiceName, svcState, statusDesc, null);
    }

    public ServiceDescriptor(String moduleServiceName, Throwable errorCause) {
        this(moduleServiceName, ServiceState.ERROR, "", errorCause);
    }

    public String getModuleServiceName() {
        return this.serviceName;
    }

    public ServiceState getServiceState() {
        return this.effectiveStatus;
    }

    public Instant getStatusTimestamp() {
        return this.statusTimestamp;
    }

    public String getStatusDesc() {
        return this.statusDesc;
    }

    public Optional<Throwable> getErrorCause() {
        return Optional.ofNullable(this.errorCause);
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this).add("serviceName", (Object)this.getModuleServiceName()).add("effectiveStatus", (Object)this.getServiceState()).add("statusTimestamp", (Object)this.getStatusTimestamp().toString()).add("statusDesc", (Object)this.getStatusDesc());
        if (this.errorCause != null) {
            toStringHelper.add("errorCause", (Object)this.errorCause);
        }
        return toStringHelper.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof ServiceDescriptor)) return false;
        ServiceDescriptor other = (ServiceDescriptor)obj;
        if (!this.serviceName.equals(other.serviceName)) return false;
        if (this.effectiveStatus != other.effectiveStatus) return false;
        if (!this.statusDesc.equals(other.statusDesc)) return false;
        if (!this.statusTimestamp.equals(other.statusTimestamp)) return false;
        if (!Objects.equals(this.errorCause, other.errorCause)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getModuleServiceName(), this.getServiceState(), this.getStatusDesc(), this.getStatusTimestamp(), this.getErrorCause()});
    }
}

