/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.Dependency;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Field;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.ModuleFieldSerializer;

public class ModuleField
extends Field {
    private final String nullableDefault;
    private final String attributeName;
    private final boolean dependent;
    private final boolean isListOfDependencies;
    private final Dependency dependency;

    private ModuleField(List<Modifier> modifiers, String type, String name, String attributeName, String nullableDefault, boolean isDependency, Dependency dependency, boolean isListOfDependencies, boolean needsDepResolver) {
        super(modifiers, type, name, null, needsDepResolver);
        this.dependent = isDependency;
        this.dependency = dependency;
        this.attributeName = attributeName;
        if (type.startsWith(List.class.getName()) && nullableDefault == null) {
            String generics = type.substring(List.class.getName().length());
            nullableDefault = "new " + ArrayList.class.getName() + generics + "()";
        }
        this.nullableDefault = nullableDefault;
        this.isListOfDependencies = isListOfDependencies;
    }

    public ModuleField(String type, String name, String attributeName, String nullableDefault, boolean isDependency, Dependency dependency, boolean isListOfDependencies, boolean needsDepResolve) {
        this(Collections.emptyList(), type, name, attributeName, nullableDefault, isDependency, dependency, isListOfDependencies, needsDepResolve);
    }

    public boolean isIdentityRef() {
        return false;
    }

    @Override
    public String toString() {
        return ModuleFieldSerializer.toString(this);
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public String getNullableDefault() {
        return this.nullableDefault;
    }

    public boolean isDependent() {
        return this.dependent;
    }

    public boolean isListOfDependencies() {
        return this.isListOfDependencies;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public boolean isList() {
        return this.getType().startsWith("java.util.List");
    }
}

