/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.java;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FullyQualifiedName {
    private final String packageName;
    private final String typeName;

    public FullyQualifiedName(String packageName, String typeName) {
        this.packageName = (String)Preconditions.checkNotNull((Object)packageName);
        this.typeName = (String)Preconditions.checkNotNull((Object)typeName);
    }

    public FullyQualifiedName(Class<?> clazz) {
        this(clazz.getPackage().getName(), clazz.getSimpleName());
    }

    public static FullyQualifiedName fromString(String fqn) {
        Matcher m = Pattern.compile("(.*)\\.([^\\.]+)$").matcher(fqn);
        if (m.matches()) {
            return new FullyQualifiedName(m.group(1), m.group(2));
        }
        return new FullyQualifiedName("", fqn);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public File toFile(File srcDirectory) {
        String directory = this.packageName.replace(".", File.separator);
        return new File(srcDirectory, directory + File.separator + this.typeName + ".java");
    }

    public String toString() {
        if (this.packageName.isEmpty()) {
            return this.typeName;
        }
        return this.packageName + "." + this.typeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FullyQualifiedName that = (FullyQualifiedName)o;
        if (!this.packageName.equals(that.packageName)) {
            return false;
        }
        return this.typeName.equals(that.typeName);
    }

    public int hashCode() {
        int result = this.packageName.hashCode();
        result = 31 * result + this.typeName.hashCode();
        return result;
    }
}

