/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntryTest;
import org.opendaylight.controller.config.yangjmxgenerator.RuntimeBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.JavaAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.ListAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.TOAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.GeneralClassTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.GeneralInterfaceTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.TemplateFactory;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Method;

public class ModuleMXBeanEntryPluginTest
extends ModuleMXBeanEntryTest {
    @Test
    public void testThreadsJavaPlugin() {
        Map namesToMBEs = this.loadThreadsJava();
        ModuleMXBeanEntry threadFactoryNaming = (ModuleMXBeanEntry)namesToMBEs.get("threadfactory-naming");
        Collection runtimeBeans = threadFactoryNaming.getRuntimeBeans();
        Assert.assertThat((Object)runtimeBeans.size(), (Matcher)CoreMatchers.is((Object)4));
        RuntimeBeanEntry rootRB = this.findFirstByYangName(runtimeBeans, "threadfactory-naming");
        Assert.assertThat((Object)rootRB.isRoot(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)rootRB.getAttributes().size(), (Matcher)CoreMatchers.is((Object)1));
        JavaAttribute attribute = (JavaAttribute)rootRB.getAttributes().iterator().next();
        Assert.assertThat((Object)attribute.getAttributeYangName(), (Matcher)CoreMatchers.is((Object)"created-sessions"));
        Assert.assertThat((Object)rootRB.getYangName(), (Matcher)CoreMatchers.is((Object)"threadfactory-naming"));
        Map ftlMap = TemplateFactory.getTOAndMXInterfaceFtlFiles((RuntimeBeanEntry)rootRB);
        Assert.assertThat((Object)ftlMap.size(), (Matcher)CoreMatchers.is((Object)1));
        GeneralInterfaceTemplate rootGeneratorInterface = (GeneralInterfaceTemplate)ftlMap.get("NamingThreadFactoryRuntimeMXBean.java");
        Assert.assertNotNull((Object)rootGeneratorInterface);
        Assert.assertThat((Object)rootGeneratorInterface.getPackageName(), (Matcher)CoreMatchers.is((Object)"pack2"));
        Assert.assertThat((Object)rootGeneratorInterface.getFullyQualifiedName(), (Matcher)CoreMatchers.is((Object)"pack2.NamingThreadFactoryRuntimeMXBean"));
        Assert.assertThat((Object)rootGeneratorInterface.getTypeDeclaration().getExtended(), (Matcher)CoreMatchers.is(Arrays.asList("org.opendaylight.controller.config.api.runtime.RuntimeBean")));
        Assert.assertThat((Object)rootGeneratorInterface.getMethods().size(), (Matcher)CoreMatchers.is((Object)1));
        Method getCreatedSessions = this.findFirstMethodByName(rootGeneratorInterface.getMethods(), "getCreatedSessions");
        Assert.assertThat((Object)getCreatedSessions.getName(), (Matcher)CoreMatchers.is((Object)"getCreatedSessions"));
        Assert.assertThat((Object)getCreatedSessions.getParameters().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)getCreatedSessions.getReturnType(), (Matcher)CoreMatchers.is((Object)Long.class.getName()));
        threadFactoryNaming = (ModuleMXBeanEntry)namesToMBEs.get("threadfactory-naming");
        runtimeBeans = threadFactoryNaming.getRuntimeBeans();
        Assert.assertThat((Object)runtimeBeans.size(), (Matcher)CoreMatchers.is((Object)4));
        RuntimeBeanEntry streamRB = this.findFirstByNamePrefix(runtimeBeans, "ThreadStream");
        Assert.assertNotNull((Object)streamRB);
        Assert.assertFalse((boolean)streamRB.getKeyYangName().isPresent());
        Assert.assertFalse((boolean)streamRB.getKeyJavaName().isPresent());
        Map attributeMap = streamRB.getYangPropertiesToTypesMap();
        Assert.assertEquals((long)4L, (long)attributeMap.size());
        TOAttribute toAttr = (TOAttribute)attributeMap.get("peer");
        Assert.assertNotNull((Object)toAttr);
        JavaAttribute timestampAttr = (JavaAttribute)attributeMap.get("timestamp");
        Assert.assertNotNull((Object)timestampAttr);
        JavaAttribute stateAttr = (JavaAttribute)attributeMap.get("state");
        Assert.assertNotNull((Object)stateAttr);
        ListAttribute innerStreamList = (ListAttribute)attributeMap.get("inner-stream-list");
        Assert.assertNotNull((Object)innerStreamList);
        Map ftlMap2 = TemplateFactory.getTOAndMXInterfaceFtlFiles((RuntimeBeanEntry)streamRB);
        Assert.assertThat((Object)ftlMap2.size(), (Matcher)CoreMatchers.is((Object)3));
        GeneralInterfaceTemplate streamGeneralInterface = (GeneralInterfaceTemplate)ftlMap2.get("ThreadStreamRuntimeMXBean.java");
        Assert.assertThat((Object)streamGeneralInterface.getMethods().size(), (Matcher)CoreMatchers.is((Object)4));
        Method getPeer = this.findFirstMethodByName(streamGeneralInterface.getMethods(), "getPeer");
        Assert.assertNotNull((Object)getPeer);
        Assert.assertThat((Object)getPeer.getReturnType(), (Matcher)CoreMatchers.is((Object)"pack2.Peer"));
        GeneralClassTemplate peerTO = (GeneralClassTemplate)ftlMap2.get("pack2.Peer");
        Assert.assertThat((Object)peerTO.getPackageName(), (Matcher)CoreMatchers.is((Object)"pack2"));
        Assert.assertThat((Object)peerTO.getTypeDeclaration().getExtended().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)peerTO.getFullyQualifiedName(), (Matcher)CoreMatchers.is((Object)"pack2.Peer"));
        Assert.assertThat((Object)peerTO.getMethods().size(), (Matcher)CoreMatchers.is((Object)7));
        Method getPort = this.findFirstMethodByName(peerTO.getMethods(), "getPort");
        Assert.assertNotNull((Object)getPort);
        Method setPort = this.findFirstMethodByName(peerTO.getMethods(), "setPort");
        Assert.assertNotNull((Object)setPort);
        Method getCoreSize = this.findFirstMethodByName(peerTO.getMethods(), "getCoreSize");
        Method setCoreSize = this.findFirstMethodByName(peerTO.getMethods(), "setCoreSize");
        Assert.assertNotNull((Object)setCoreSize);
        Assert.assertNotNull((Object)getCoreSize);
    }

    private Method findFirstMethodByName(List<? extends Method> methods, String name) {
        for (Method method : methods) {
            if (!name.equals(method.getName())) continue;
            return method;
        }
        throw new IllegalArgumentException("Method with given name not found");
    }
}

