/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.opendaylight.controller.config.api.runtime.HierarchicalRuntimeBeanRegistration;
import org.opendaylight.controller.config.api.runtime.RootRuntimeBeanRegistrator;
import org.opendaylight.controller.config.yangjmxgenerator.RuntimeBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.FtlTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.GeneralClassTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.TypeHelper;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Annotation;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Field;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.MethodDefinition;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.util.FullyQualifiedNameHelper;

public class RuntimeRegistratorFtlTemplate
extends GeneralClassTemplate {
    private static Field hierachchicalRegistration = new Field(Lists.newArrayList((Object[])new String[]{"final"}), HierarchicalRuntimeBeanRegistration.class.getCanonicalName(), "registration");

    private RuntimeRegistratorFtlTemplate(RuntimeBeanEntry runtimeBeanEntry, String name, List<Field> fields, List<MethodDefinition> methods) {
        super(null, runtimeBeanEntry.getPackageName(), name, Collections.emptyList(), Arrays.asList(Closeable.class.getCanonicalName()), fields, methods);
    }

    public static RuntimeBeanEntry findRoot(Collection<RuntimeBeanEntry> runtimeBeanEntries) {
        RuntimeBeanEntry result = null;
        for (RuntimeBeanEntry rb : runtimeBeanEntries) {
            if (!rb.isRoot()) continue;
            if (result != null) {
                throw new IllegalArgumentException("More than one root runtime bean found");
            }
            result = rb;
        }
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("No root runtime bean found");
    }

    private static String constructConstructorBody(List<Field> constructorParameters) {
        StringBuffer constructorBody = new StringBuffer();
        for (Field field : constructorParameters) {
            constructorBody.append("this.");
            constructorBody.append(field.getName());
            constructorBody.append("=");
            constructorBody.append(field.getName());
            constructorBody.append(";\n");
        }
        return constructorBody.toString();
    }

    public static Map<String, FtlTemplate> create(RuntimeBeanEntry rootRB) {
        Preconditions.checkArgument((boolean)rootRB.isRoot(), (Object)"RuntimeBeanEntry must be root");
        String registratorName = RuntimeRegistratorFtlTemplate.getJavaNameOfRuntimeRegistrator(rootRB);
        ArrayList<MethodDefinition> methods = new ArrayList<MethodDefinition>();
        Field rootRuntimeBeanRegistratorField = new Field(Lists.newArrayList((Object[])new String[]{"final"}), RootRuntimeBeanRegistrator.class.getName(), "rootRuntimeBeanRegistrator");
        ArrayList constructorParameters = Lists.newArrayList((Object[])new Field[]{rootRuntimeBeanRegistratorField});
        String constructorBody = RuntimeRegistratorFtlTemplate.constructConstructorBody(constructorParameters);
        MethodDefinition constructor = MethodDefinition.createConstructor(registratorName, constructorParameters, constructorBody);
        methods.add(constructor);
        LinkedHashMap<String, RuntimeRegistratorFtlTemplate> RuntimeRegistratorFtlTemplates = RuntimeRegistratorFtlTemplate.createRegistrationHierarchy(rootRB, Collections.emptySet());
        RuntimeRegistratorFtlTemplate rootFtlFile = RuntimeRegistratorFtlTemplates.values().iterator().next();
        String fullyQualifiedNameOfMXBean = FullyQualifiedNameHelper.getFullyQualifiedName((String)rootRB.getPackageName(), (String)rootRB.getJavaNameOfRuntimeMXBean());
        String childRegistratorFQN = rootFtlFile.getFullyQualifiedName();
        Field rbParameter = new Field(fullyQualifiedNameOfMXBean, "rb");
        StringBuilder registerBody = new StringBuilder();
        registerBody.append(String.format("%s %s = this.%s.registerRoot(%s);\n", HierarchicalRuntimeBeanRegistration.class.getCanonicalName(), hierachchicalRegistration.getName(), rootRuntimeBeanRegistratorField.getName(), rbParameter.getName()));
        registerBody.append(String.format("return new %s(%s);\n", rootFtlFile.getFullyQualifiedName(), hierachchicalRegistration.getName()));
        MethodDefinition registerMethod = new MethodDefinition(childRegistratorFQN, "register", Arrays.asList(rbParameter), registerBody.toString());
        methods.add(registerMethod);
        MethodDefinition closeRegistrator = RuntimeRegistratorFtlTemplate.createCloseMethodToCloseField(rootRuntimeBeanRegistratorField);
        methods.add(closeRegistrator);
        GeneralClassTemplate registrator = new GeneralClassTemplate(null, rootRB.getPackageName(), registratorName, Collections.emptyList(), Arrays.asList(Closeable.class.getCanonicalName()), constructorParameters, methods);
        Preconditions.checkState((!RuntimeRegistratorFtlTemplates.containsKey(registrator.getTypeDeclaration().getName()) ? 1 : 0) != 0, (Object)("Name conflict: " + registrator.getTypeDeclaration().getName()));
        HashMap<String, FtlTemplate> result = new HashMap<String, FtlTemplate>();
        result.putAll(RuntimeRegistratorFtlTemplates);
        result.put(registrator.getTypeDeclaration().getName(), registrator);
        return result;
    }

    private static LinkedHashMap<String, RuntimeRegistratorFtlTemplate> createRegistrationHierarchy(RuntimeBeanEntry parent, Set<String> occupiedKeys) {
        LinkedHashMap<String, RuntimeRegistratorFtlTemplate> unorderedResult = new LinkedHashMap<String, RuntimeRegistratorFtlTemplate>();
        ArrayList<MethodDefinition> methods = new ArrayList<MethodDefinition>();
        if (occupiedKeys.contains(parent.getJavaNamePrefix())) {
            throw new IllegalArgumentException("Name conflict in runtime bean hierarchy - java name found more than once. Consider using java-name extension. Conflicting name: " + parent.getJavaNamePrefix());
        }
        HashSet<String> currentOccupiedKeys = new HashSet<String>(occupiedKeys);
        currentOccupiedKeys.add(parent.getJavaNamePrefix());
        Field registratorsMapField = new Field(Arrays.asList("final"), TypeHelper.getGenericType(Map.class, String.class, AtomicInteger.class), "unkeyedMap", "new " + TypeHelper.getGenericType(HashMap.class, String.class, AtomicInteger.class) + "()");
        for (RuntimeBeanEntry child : parent.getChildren()) {
            String value;
            Preconditions.checkArgument((boolean)parent.getPackageName().equals(child.getPackageName()), (Object)"Invalid package name");
            LinkedHashMap<String, RuntimeRegistratorFtlTemplate> childRegistratorMap = RuntimeRegistratorFtlTemplate.createRegistrationHierarchy(child, currentOccupiedKeys);
            for (Map.Entry<String, RuntimeRegistratorFtlTemplate> entry : childRegistratorMap.entrySet()) {
                if (unorderedResult.containsKey(entry.getKey())) {
                    throw new IllegalStateException("Conflicting name found while generating runtime registration:" + entry.getKey());
                }
                unorderedResult.put(entry.getKey(), entry.getValue());
            }
            if (childRegistratorMap.isEmpty()) continue;
            RuntimeRegistratorFtlTemplate childRegistrator = childRegistratorMap.values().iterator().next();
            StringBuilder body = new StringBuilder();
            String key = child.getJavaNamePrefix();
            body.append(String.format("String key = \"%s\"; //TODO: check for conflicts\n", key));
            if (child.getKeyJavaName().isPresent()) {
                value = "bean.get" + (String)child.getKeyJavaName().get() + "()";
                value = "String.valueOf(" + value + ")";
            } else {
                body.append("java.util.concurrent.atomic.AtomicInteger counter = unkeyedMap.get(key);\nif (counter==null){\ncounter = new java.util.concurrent.atomic.AtomicInteger();\nunkeyedMap.put(key, counter);\n}\n");
                value = "String.valueOf(counter.incrementAndGet())";
            }
            body.append(String.format("String value = %s;\n", value));
            body.append(String.format("%s r = %s.register(key, value, bean);\n", HierarchicalRuntimeBeanRegistration.class.getCanonicalName(), hierachchicalRegistration.getName()));
            body.append(String.format("return new %s(r);", childRegistrator.getFullyQualifiedName()));
            Field param = new Field(Lists.newArrayList((Object[])new String[]{"final"}), child.getJavaNameOfRuntimeMXBean(), "bean");
            MethodDefinition register = new MethodDefinition(Arrays.asList("synchronized"), childRegistrator.getFullyQualifiedName(), "register", Arrays.asList(param), Collections.emptyList(), Collections.emptyList(), body.toString());
            methods.add(register);
        }
        String createdName = RuntimeRegistratorFtlTemplate.getJavaNameOfRuntimeRegistration(parent.getJavaNamePrefix());
        List<Field> constructorParameters = Arrays.asList(hierachchicalRegistration);
        String constructorBody = RuntimeRegistratorFtlTemplate.constructConstructorBody(constructorParameters);
        MethodDefinition constructor = MethodDefinition.createConstructor(createdName, constructorParameters, constructorBody);
        MethodDefinition closeRegistrator = RuntimeRegistratorFtlTemplate.createCloseMethodToCloseField(hierachchicalRegistration);
        methods.add(closeRegistrator);
        methods.add(constructor);
        ArrayList privateFields = Lists.newArrayList((Object[])new Field[]{registratorsMapField});
        privateFields.addAll(constructorParameters);
        RuntimeRegistratorFtlTemplate created = new RuntimeRegistratorFtlTemplate(parent, createdName, privateFields, methods);
        LinkedHashMap<String, RuntimeRegistratorFtlTemplate> result = new LinkedHashMap<String, RuntimeRegistratorFtlTemplate>();
        result.put(created.getTypeDeclaration().getName(), created);
        Preconditions.checkState((!unorderedResult.containsKey(created.getTypeDeclaration().getName()) ? 1 : 0) != 0, (Object)("Naming conflict: " + created.getTypeDeclaration().getName()));
        result.putAll(unorderedResult);
        return result;
    }

    private static MethodDefinition createCloseMethodToCloseField(Field field) {
        String body = field.getName() + ".close();";
        ArrayList annotations = Lists.newArrayList((Object[])new Annotation[]{new Annotation("Override", Collections.emptyList())});
        return new MethodDefinition(Collections.emptyList(), "void", "close", Collections.emptyList(), Collections.emptyList(), annotations, body);
    }

    @VisibleForTesting
    public static String getJavaNameOfRuntimeRegistration(String javaNamePrefix) {
        return javaNamePrefix + "RuntimeRegistration";
    }

    public static String getJavaNameOfRuntimeRegistrator(RuntimeBeanEntry rootRB) {
        Preconditions.checkArgument((boolean)rootRB.isRoot(), (Object)"RuntimeBeanEntry must be root");
        return rootRB.getJavaNamePrefix() + "RuntimeRegistrator";
    }
}

