/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.util;

import java.io.IOException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.FullyQualifiedName;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.util.StringUtil;

public class StringUtilTest {
    @Test
    public void testPrefixAndJoin() {
        Assert.assertEquals((Object)" extends p1.Foo,Bar", (Object)StringUtil.prefixAndJoin(Arrays.asList(new FullyQualifiedName("p1", "Foo"), new FullyQualifiedName("", "Bar")), (String)"extends"));
    }

    @Test
    public void testAddAsterixAtEachLineStart() {
        String input = "foo   \nbar";
        String expectedOutput = "* foo\n* bar\n";
        Assert.assertEquals((Object)expectedOutput, (Object)StringUtil.addAsterixAtEachLineStart((String)input));
    }

    @Test
    @Ignore
    public void testCopyright() throws IOException {
        Assert.assertTrue((boolean)StringUtil.loadCopyright().isPresent());
    }

    @Test
    public void testFormatting() {
        String input = "  \tpack;\nclass Bar{ \n method() {\n  body\n}\n  }";
        String expected = "pack;\nclass Bar{\n    method() {\n        body\n    }\n}\n";
        Assert.assertEquals((Object)expected, (Object)StringUtil.formatJavaSource((String)input));
        input = "{\nbar\n}\n\n\nbaz\n\n\n\n";
        expected = "{\n    bar\n}\n\nbaz\n";
        Assert.assertEquals((Object)expected, (Object)StringUtil.formatJavaSource((String)input));
    }
}

