/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.java;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.FullyQualifiedName;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.util.StringUtil;

public class GeneratedObject {
    private final FullyQualifiedName fqn;
    private final String content;

    public GeneratedObject(FullyQualifiedName fqn, String content) {
        this.fqn = (FullyQualifiedName)Preconditions.checkNotNull((Object)fqn);
        this.content = StringUtil.formatJavaSource((String)Preconditions.checkNotNull((Object)content));
    }

    public FullyQualifiedName getFQN() {
        return this.fqn;
    }

    public String getContent() {
        return this.content;
    }

    public Optional<Map.Entry<FullyQualifiedName, File>> persist(File srcDirectory, boolean overwrite) throws IOException {
        File dstFile = this.fqn.toFile(srcDirectory);
        if (overwrite || !dstFile.exists()) {
            Files.createParentDirs((File)dstFile);
            Files.touch((File)dstFile);
            Files.write((CharSequence)this.content, (File)dstFile, (Charset)StandardCharsets.UTF_8);
            return Optional.of((Object)Maps.immutableEntry((Object)this.fqn, (Object)dstFile));
        }
        return Optional.absent();
    }

    public Optional<Map.Entry<FullyQualifiedName, File>> persist(File srcDirectory) throws IOException {
        return this.persist(srcDirectory, true);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "fqn=" + this.fqn + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneratedObject that = (GeneratedObject)o;
        return this.fqn.equals(that.fqn);
    }

    public int hashCode() {
        return this.fqn.hashCode();
    }
}

