/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.config.yangjmxgenerator.RuntimeBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.RuntimeRegistratorTest;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.FtlTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.RuntimeRegistratorFtlTemplate;

public class RuntimeRegistratorFtlFileTest
extends RuntimeRegistratorTest {
    @Test
    public void testRootWithoutAnything() {
        RuntimeBeanEntry rootRB = this.prepareRootRB(Collections.emptyList());
        Map createdFtls = RuntimeRegistratorFtlTemplate.create((RuntimeBeanEntry)rootRB);
        Assert.assertThat((Object)createdFtls.size(), (Matcher)CoreMatchers.is((Object)2));
        String rootRegistratorName = RuntimeRegistratorFtlTemplate.getJavaNameOfRuntimeRegistration((String)rootRB.getJavaNamePrefix());
        FtlTemplate rootFtlFile = (FtlTemplate)createdFtls.get(rootRegistratorName);
        Assert.assertNotNull((Object)rootFtlFile);
        Assert.assertThat((Object)createdFtls.values().size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testHierarchy2() {
        RuntimeBeanEntry grandChildRB = this.prepareChildRB(Collections.emptyList(), "grand");
        RuntimeBeanEntry childRB = this.prepareChildRB(Arrays.asList(grandChildRB), "");
        RuntimeBeanEntry rootRB = this.prepareRootRB(Arrays.asList(childRB));
        Map createdFtls = RuntimeRegistratorFtlTemplate.create((RuntimeBeanEntry)rootRB);
        Assert.assertThat((Object)createdFtls.values().size(), (Matcher)CoreMatchers.is((Object)4));
    }
}

