/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.SimpleType;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.IdentityAttributeRef;
import org.opendaylight.controller.config.api.RuntimeBeanRegistratorAwareModule;
import org.opendaylight.controller.config.api.annotations.AbstractServiceInterface;
import org.opendaylight.controller.config.api.runtime.RuntimeBean;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.yangjmxgenerator.AbstractEntry;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.RuntimeBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.ServiceInterfaceEntry;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.AbstractDependencyAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.AttributeIfc;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.Dependency;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.JavaAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.ListAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.ListDependenciesAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.TOAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.TypedAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.VoidAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.AbstractFactoryTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.AbstractModuleTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.FtlTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.GeneralClassTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.GeneralInterfaceTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.RuntimeRegistratorFtlTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.StubFactoryTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Annotation;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Constructor;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Field;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Header;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.IdentityRefModuleField;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.MethodDeclaration;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.MethodDefinition;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.ModuleField;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.util.FullyQualifiedNameHelper;
import org.opendaylight.yangtools.binding.generator.util.BindingGeneratorUtil;
import org.opendaylight.yangtools.sal.binding.model.api.ParameterizedType;
import org.opendaylight.yangtools.sal.binding.model.api.Type;

public class TemplateFactory {
    private static final Type identityRefType = new Type(){
        public final Class<IdentityAttributeRef> IDENTITY_ATTRIBUTE_REF_CLASS = IdentityAttributeRef.class;

        public String getPackageName() {
            return this.IDENTITY_ATTRIBUTE_REF_CLASS.getPackage().getName();
        }

        public String getName() {
            return this.IDENTITY_ATTRIBUTE_REF_CLASS.getSimpleName();
        }

        public String getFullyQualifiedName() {
            return this.IDENTITY_ATTRIBUTE_REF_CLASS.getName();
        }
    };

    public static Map<String, FtlTemplate> getTOAndMXInterfaceFtlFiles(RuntimeBeanEntry entry) {
        HashMap<String, FtlTemplate> result = new HashMap<String, FtlTemplate>();
        String mxBeanTypeName = entry.getJavaNameOfRuntimeMXBean();
        List<String> extendedInterfaces = Arrays.asList(RuntimeBean.class.getCanonicalName());
        ArrayList<MethodDeclaration> methods = new ArrayList<MethodDeclaration>();
        for (AttributeIfc attributeIfc : entry.getAttributes()) {
            String returnType = TemplateFactory.getReturnType(attributeIfc);
            String getterName = "get" + attributeIfc.getUpperCaseCammelCase();
            MethodDeclaration getter = new MethodDeclaration(returnType, getterName, Collections.emptyList());
            methods.add(getter);
        }
        for (RuntimeBeanEntry.Rpc rpc : entry.getRpcs()) {
            ArrayList<Field> fields = new ArrayList<Field>();
            for (JavaAttribute ja : rpc.getParameters()) {
                Field field = new Field(Collections.emptyList(), ja.getType().getFullyQualifiedName(), ja.getLowerCaseCammelCase(), ja.getNullableDefaultWrappedForCode());
                fields.add(field);
            }
            MethodDeclaration operation = new MethodDeclaration(TemplateFactory.getReturnType(rpc.getReturnType()), rpc.getName(), fields);
            methods.add(operation);
        }
        GeneralInterfaceTemplate runtimeMxBeanIfc = new GeneralInterfaceTemplate(null, entry.getPackageName(), mxBeanTypeName, extendedInterfaces, methods);
        result.put(runtimeMxBeanIfc.getTypeDeclaration().getName() + ".java", runtimeMxBeanIfc);
        result.putAll(TemplateFactory.tOsFromRbe(entry));
        return result;
    }

    static String serializeType(Type type, boolean addWildcards) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            StringBuffer sb = new StringBuffer();
            sb.append(parameterizedType.getRawType().getFullyQualifiedName());
            sb.append(addWildcards ? "<? extends " : "<");
            boolean first = true;
            for (Type parameter : parameterizedType.getActualTypeArguments()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(TemplateFactory.serializeType(parameter));
            }
            sb.append(">");
            return sb.toString();
        }
        return type.getFullyQualifiedName();
    }

    static String serializeType(Type type) {
        return TemplateFactory.serializeType(type, false);
    }

    private static String getReturnType(AttributeIfc attributeIfc) {
        if (!(attributeIfc instanceof TypedAttribute)) {
            if (attributeIfc == VoidAttribute.getInstance()) {
                return "void";
            }
            throw new UnsupportedOperationException("Attribute not supported: " + attributeIfc.getClass());
        }
        Type type = ((TypedAttribute)attributeIfc).getType();
        String returnType = TemplateFactory.serializeType(type);
        return returnType;
    }

    public static GeneralInterfaceTemplate serviceInterfaceFromSie(ServiceInterfaceEntry sie) {
        ArrayList extendedInterfaces = Lists.newArrayList((Object[])new String[]{AbstractServiceInterface.class.getCanonicalName()});
        if (sie.getBase().isPresent()) {
            extendedInterfaces.add(((ServiceInterfaceEntry)sie.getBase().get()).getFullyQualifiedName());
        }
        GeneralInterfaceTemplate sieTemplate = new GeneralInterfaceTemplate(TemplateFactory.getHeaderFromEntry((AbstractEntry)sie), sie.getPackageName(), sie.getTypeName(), extendedInterfaces, Lists.newArrayList());
        sieTemplate.setJavadoc(sie.getNullableDescription());
        if (sie.getNullableDescription() != null) {
            sieTemplate.getAnnotations().add(Annotation.createDescriptionAnnotation(sie.getNullableDescription()));
        }
        sieTemplate.getAnnotations().addAll(Annotation.createSieAnnotations(sie));
        return sieTemplate;
    }

    public static AbstractFactoryTemplate abstractFactoryTemplateFromMbe(ModuleMXBeanEntry mbe) {
        AbstractFactoryAttributesProcessor attrProcessor = new AbstractFactoryAttributesProcessor();
        attrProcessor.processAttributes(mbe.getAttributes(), mbe.getPackageName());
        return new AbstractFactoryTemplate(TemplateFactory.getHeaderFromEntry((AbstractEntry)mbe), mbe.getPackageName(), mbe.getAbstractFactoryName(), attrProcessor.getFields());
    }

    public static AbstractModuleTemplate abstractModuleTemplateFromMbe(ModuleMXBeanEntry mbe) {
        AbstractModuleAttributesProcessor attrProcessor = new AbstractModuleAttributesProcessor(mbe.getAttributes());
        List<ModuleField> moduleFields = attrProcessor.getModuleFields();
        ArrayList implementedIfcs = Lists.newArrayList((Object[])new String[]{Module.class.getCanonicalName(), mbe.getFullyQualifiedName(mbe.getMXBeanInterfaceName())});
        for (String implementedService : mbe.getProvidedServices().keySet()) {
            implementedIfcs.add(implementedService);
        }
        boolean generateRuntime = false;
        String registratorFullyQualifiedName = null;
        if (mbe.getRuntimeBeans() != null && !mbe.getRuntimeBeans().isEmpty()) {
            generateRuntime = true;
            RuntimeBeanEntry rootEntry = RuntimeRegistratorFtlTemplate.findRoot(mbe.getRuntimeBeans());
            registratorFullyQualifiedName = rootEntry.getPackageName().concat(".").concat(RuntimeRegistratorFtlTemplate.getJavaNameOfRuntimeRegistrator(rootEntry));
            implementedIfcs.add(RuntimeBeanRegistratorAwareModule.class.getCanonicalName());
        }
        AbstractModuleTemplate abstractModuleTemplate = new AbstractModuleTemplate(TemplateFactory.getHeaderFromEntry((AbstractEntry)mbe), mbe.getPackageName(), mbe.getAbstractModuleName(), implementedIfcs, moduleFields, attrProcessor.getMethods(), generateRuntime, registratorFullyQualifiedName);
        if (mbe.getNullableDescription() != null) {
            abstractModuleTemplate.getAnnotations().add(Annotation.createDescriptionAnnotation(mbe.getNullableDescription()));
        }
        return abstractModuleTemplate;
    }

    public static StubFactoryTemplate stubFactoryTemplateFromMbe(ModuleMXBeanEntry mbe) {
        return new StubFactoryTemplate(TemplateFactory.getHeaderFromEntry((AbstractEntry)mbe), mbe.getPackageName(), mbe.getStubFactoryName(), mbe.getFullyQualifiedName(mbe.getAbstractFactoryName()));
    }

    public static GeneralInterfaceTemplate mXBeanInterfaceTemplateFromMbe(ModuleMXBeanEntry mbe) {
        MXBeanInterfaceAttributesProcessor attrProcessor = new MXBeanInterfaceAttributesProcessor();
        attrProcessor.processAttributes(mbe.getAttributes());
        GeneralInterfaceTemplate ifcTemplate = new GeneralInterfaceTemplate(TemplateFactory.getHeaderFromEntry((AbstractEntry)mbe), mbe.getPackageName(), mbe.getMXBeanInterfaceName(), Lists.newArrayList(), attrProcessor.getMethods());
        ifcTemplate.setJavadoc(mbe.getNullableDescription());
        return ifcTemplate;
    }

    public static Map<String, GeneralClassTemplate> tOsFromMbe(ModuleMXBeanEntry mbe) {
        HashMap retVal = Maps.newHashMap();
        TOAttributesProcessor processor = new TOAttributesProcessor();
        processor.processAttributes(mbe.getAttributes());
        for (TOAttributesProcessor.TOInternal to : processor.getTOs()) {
            ArrayList constructors = Lists.newArrayList();
            constructors.add(new Constructor(to.getName(), "super();"));
            Header header = TemplateFactory.getHeaderFromEntry((AbstractEntry)mbe);
            retVal.put(to.getType(), new GeneralClassTemplate(header, mbe.getPackageName(), to.getName(), Collections.emptyList(), Collections.emptyList(), to.getFields(), to.getMethods(), false, false, constructors));
        }
        return retVal;
    }

    public static Map<String, GeneralClassTemplate> tOsFromRbe(RuntimeBeanEntry rbe) {
        HashMap retVal = Maps.newHashMap();
        TOAttributesProcessor processor = new TOAttributesProcessor();
        HashMap yangPropertiesToTypesMap = Maps.newHashMap((Map)rbe.getYangPropertiesToTypesMap());
        for (RuntimeBeanEntry.Rpc rpc : rbe.getRpcs()) {
            AttributeIfc returnType = rpc.getReturnType();
            if (returnType == VoidAttribute.getInstance() || returnType instanceof JavaAttribute || returnType instanceof ListAttribute && returnType.getOpenType() instanceof SimpleType) continue;
            Preconditions.checkState((!yangPropertiesToTypesMap.containsKey(returnType.getAttributeYangName()) ? 1 : 0) != 0, (String)"Duplicate TO %s for %s", (Object[])new Object[]{returnType.getAttributeYangName(), rbe});
            yangPropertiesToTypesMap.put(returnType.getAttributeYangName(), returnType);
        }
        processor.processAttributes(yangPropertiesToTypesMap);
        for (TOAttributesProcessor.TOInternal to : processor.getTOs()) {
            ArrayList constructors = Lists.newArrayList();
            constructors.add(new Constructor(to.getName(), "super();"));
            retVal.put(to.getType(), new GeneralClassTemplate(null, rbe.getPackageName(), to.getName(), Collections.emptyList(), Collections.emptyList(), to.getFields(), to.getMethods(), false, false, constructors));
        }
        return retVal;
    }

    private static Header getHeaderFromEntry(AbstractEntry mbe) {
        return new Header(mbe.getYangModuleName(), mbe.getYangModuleLocalname());
    }

    private static boolean needsDepResolver(AttributeIfc value) {
        if (value instanceof TOAttribute) {
            return true;
        }
        if (value instanceof ListAttribute) {
            AttributeIfc innerAttribute = ((ListAttribute)value).getInnerAttribute();
            return TemplateFactory.needsDepResolver(innerAttribute);
        }
        return false;
    }

    private static String getInnerTypeFromIdentity(Type type) {
        Preconditions.checkArgument((boolean)(type instanceof ParameterizedType));
        Type[] args = ((ParameterizedType)type).getActualTypeArguments();
        Preconditions.checkArgument((args.length == 1 ? 1 : 0) != 0);
        return TemplateFactory.serializeType(args[0]);
    }

    private static class AbstractModuleAttributesProcessor {
        private final Holder holder;

        private AbstractModuleAttributesProcessor(Map<String, AttributeIfc> attributes) {
            this.holder = AbstractModuleAttributesProcessor.processAttributes(attributes);
        }

        private static Holder processAttributes(Map<String, AttributeIfc> attributes) {
            ArrayList<ModuleField> moduleFields = new ArrayList<ModuleField>();
            ArrayList<MethodDefinition> methods = new ArrayList<MethodDefinition>();
            for (Map.Entry<String, AttributeIfc> attrEntry : attributes.entrySet()) {
                ModuleField field;
                String type;
                String nullableDefaultWrapped = null;
                AttributeIfc attributeIfc = attrEntry.getValue();
                boolean isIdentity = false;
                boolean needsDepResolver = TemplateFactory.needsDepResolver(attrEntry.getValue());
                if (attributeIfc instanceof TypedAttribute) {
                    TypedAttribute typedAttribute = (TypedAttribute)attributeIfc;
                    type = TemplateFactory.serializeType(typedAttribute.getType());
                    if (attributeIfc instanceof JavaAttribute) {
                        nullableDefaultWrapped = ((JavaAttribute)attributeIfc).getNullableDefaultWrappedForCode();
                        if (((JavaAttribute)attrEntry.getValue()).isIdentityRef()) {
                            isIdentity = true;
                            type = TemplateFactory.serializeType(typedAttribute.getType(), true);
                        }
                    }
                } else {
                    throw new UnsupportedOperationException("Attribute not supported: " + attributeIfc.getClass());
                }
                boolean isDependency = false;
                boolean isListOfDependencies = false;
                Dependency dependency = null;
                Annotation overrideAnnotation = new Annotation("Override", Collections.emptyList());
                ArrayList annotations = Lists.newArrayList((Object[])new Annotation[]{overrideAnnotation});
                if (attributeIfc instanceof AbstractDependencyAttribute) {
                    isDependency = true;
                    dependency = ((AbstractDependencyAttribute)attributeIfc).getDependency();
                    annotations.add(Annotation.createRequireIfcAnnotation(dependency.getSie()));
                    if (attributeIfc instanceof ListDependenciesAttribute) {
                        isListOfDependencies = true;
                    }
                }
                String varName = BindingGeneratorUtil.parseToValidParamName((String)attrEntry.getKey());
                if (isIdentity) {
                    String identityBaseClass = TemplateFactory.getInnerTypeFromIdentity(((TypedAttribute)attributeIfc).getType());
                    IdentityRefModuleField identityField = new IdentityRefModuleField(type, varName, attributeIfc.getUpperCaseCammelCase(), identityBaseClass);
                    String getterName = "get" + attributeIfc.getUpperCaseCammelCase() + "Identity";
                    MethodDefinition additionalGetter = new MethodDefinition(type, getterName, Collections.emptyList(), Collections.emptyList(), "return " + identityField.getIdentityClassName() + ";");
                    methods.add(additionalGetter);
                    String setterName = "set" + attributeIfc.getUpperCaseCammelCase();
                    String setterBody = "this." + identityField.getIdentityClassName() + " = " + identityField.getIdentityClassName() + ";";
                    MethodDefinition additionalSetter = new MethodDefinition("void", setterName, Lists.newArrayList((Object[])new Field[]{new Field(type, identityField.getIdentityClassName())}), Collections.emptyList(), setterBody);
                    additionalSetter.setJavadoc(attributeIfc.getNullableDescription());
                    methods.add(additionalSetter);
                    type = TemplateFactory.serializeType(identityRefType);
                    field = identityField;
                } else {
                    field = new ModuleField(type, varName, attributeIfc.getUpperCaseCammelCase(), nullableDefaultWrapped, isDependency, dependency, isListOfDependencies, needsDepResolver);
                }
                moduleFields.add(field);
                String getterName = "get" + attributeIfc.getUpperCaseCammelCase();
                MethodDefinition getter = new MethodDefinition(type, getterName, Collections.emptyList(), Lists.newArrayList((Object[])new Annotation[]{overrideAnnotation}), "return " + varName + ";");
                methods.add(getter);
                String setterName = "set" + attributeIfc.getUpperCaseCammelCase();
                if (attributeIfc.getNullableDescription() != null) {
                    annotations.add(Annotation.createDescriptionAnnotation(attributeIfc.getNullableDescription()));
                }
                String setterBody = "this." + varName + " = " + varName + ";";
                if (isListOfDependencies) {
                    String nullCheck = String.format("if (%s == null) throw new IllegalArgumentException(\"Null not supported\");%n", varName);
                    setterBody = nullCheck + setterBody;
                }
                MethodDefinition setter = new MethodDefinition("void", setterName, Lists.newArrayList((Object[])new Field[]{new Field(type, varName)}), annotations, setterBody);
                setter.setJavadoc(attributeIfc.getNullableDescription());
                methods.add(setter);
            }
            return new Holder(moduleFields, methods);
        }

        List<ModuleField> getModuleFields() {
            return this.holder.moduleFields;
        }

        List<MethodDefinition> getMethods() {
            return this.holder.methods;
        }

        private static class Holder {
            private final List<ModuleField> moduleFields;
            private final List<MethodDefinition> methods;

            private Holder(List<ModuleField> moduleFields, List<MethodDefinition> methods) {
                this.moduleFields = Collections.unmodifiableList(moduleFields);
                this.methods = Collections.unmodifiableList(methods);
            }
        }
    }

    private static class AbstractFactoryAttributesProcessor {
        private final List<Field> fields = Lists.newArrayList();

        private AbstractFactoryAttributesProcessor() {
        }

        void processAttributes(Map<String, AttributeIfc> attributes, String packageName) {
            for (Map.Entry<String, AttributeIfc> attrEntry : attributes.entrySet()) {
                String nullableDefaultWrapped = null;
                AttributeIfc attributeIfc = attrEntry.getValue();
                if (!(attributeIfc instanceof TypedAttribute)) {
                    throw new UnsupportedOperationException("Attribute not supported: " + attributeIfc.getClass());
                }
                TypedAttribute typedAttribute = (TypedAttribute)attributeIfc;
                String type = TemplateFactory.serializeType(typedAttribute.getType());
                this.fields.add(new Field(type, attributeIfc.getUpperCaseCammelCase(), nullableDefaultWrapped));
            }
        }

        List<Field> getFields() {
            return this.fields;
        }
    }

    private static class MXBeanInterfaceAttributesProcessor {
        private final List<MethodDeclaration> methods = Lists.newArrayList();

        private MXBeanInterfaceAttributesProcessor() {
        }

        void processAttributes(Map<String, AttributeIfc> attributes) {
            for (Map.Entry<String, AttributeIfc> attrEntry : attributes.entrySet()) {
                String returnType;
                AttributeIfc attributeIfc = attrEntry.getValue();
                boolean isIdentityRef = false;
                if (attributeIfc instanceof TypedAttribute) {
                    TypedAttribute typedAttribute = (TypedAttribute)attributeIfc;
                    returnType = TemplateFactory.serializeType(typedAttribute.getType());
                    if (attributeIfc instanceof JavaAttribute && ((JavaAttribute)attrEntry.getValue()).isIdentityRef()) {
                        returnType = TemplateFactory.serializeType(identityRefType);
                    }
                } else {
                    throw new UnsupportedOperationException("Attribute not supported: " + attributeIfc.getClass());
                }
                String getterName = "get" + attributeIfc.getUpperCaseCammelCase();
                MethodDeclaration getter = new MethodDeclaration(returnType, getterName, Collections.emptyList());
                String varName = BindingGeneratorUtil.parseToValidParamName((String)attrEntry.getKey());
                String setterName = "set" + attributeIfc.getUpperCaseCammelCase();
                MethodDeclaration setter = new MethodDeclaration("void", setterName, Lists.newArrayList((Object[])new Field[]{new Field(returnType, varName)}));
                this.methods.add(getter);
                this.methods.add(setter);
                if (attributeIfc.getNullableDescription() == null) continue;
                setter.setJavadoc(attrEntry.getValue().getNullableDescription());
            }
        }

        List<MethodDeclaration> getMethods() {
            return this.methods;
        }
    }

    private static class TOAttributesProcessor {
        private final List<TOInternal> tos = Lists.newArrayList();

        private TOAttributesProcessor() {
        }

        void processAttributes(Map<String, AttributeIfc> attributes) {
            for (Map.Entry<String, AttributeIfc> attrEntry : attributes.entrySet()) {
                AttributeIfc innerAttr;
                AttributeIfc attributeIfc = attrEntry.getValue();
                if (attributeIfc instanceof TOAttribute) {
                    this.createTOInternal((TOAttribute)attributeIfc);
                }
                if (!(attributeIfc instanceof ListAttribute) || !((innerAttr = ((ListAttribute)attributeIfc).getInnerAttribute()) instanceof TOAttribute)) continue;
                this.createTOInternal((TOAttribute)innerAttr);
            }
        }

        private void createTOInternal(TOAttribute toAttribute) {
            Map attrs = toAttribute.getCapitalizedPropertiesToTypesMap();
            this.processAttributes(attrs);
            this.tos.add(new TOInternal(toAttribute.getType(), attrs));
        }

        List<TOInternal> getTOs() {
            return this.tos;
        }

        private static class TOInternal {
            private final String fullyQualifiedName;
            private final String name;
            private List<Field> fields;
            private List<MethodDefinition> methods;
            private static final String dependencyResolverVarName = "dependencyResolver";
            private static final String dependencyResolverInjectMethodName = "injectDependencyResolver";

            public TOInternal(Type type, Map<String, AttributeIfc> attrs) {
                this(type.getFullyQualifiedName(), type.getName(), attrs, type.getPackageName());
            }

            public TOInternal(String fullyQualifiedName, String name, Map<String, AttributeIfc> attrs, String packageName) {
                this.fullyQualifiedName = fullyQualifiedName;
                this.name = name;
                this.processAttrs(attrs, packageName);
            }

            private void processAttrs(Map<String, AttributeIfc> attrs, String packageName) {
                this.fields = Lists.newArrayList();
                this.methods = Lists.newArrayList();
                Field depRes = new Field(DependencyResolver.class.getName(), dependencyResolverVarName);
                this.fields.add(depRes);
                this.methods.add(new MethodDefinition("void", dependencyResolverInjectMethodName, Lists.newArrayList((Object[])new Field[]{depRes}), "this.dependencyResolver = dependencyResolver;"));
                for (Map.Entry<String, AttributeIfc> attrEntry : attrs.entrySet()) {
                    String fullyQualifiedName;
                    String innerName = attrEntry.getKey();
                    String varName = BindingGeneratorUtil.parseToValidParamName((String)attrEntry.getKey());
                    String nullableDefault = null;
                    if (attrEntry.getValue() instanceof TypedAttribute) {
                        Type type = ((TypedAttribute)attrEntry.getValue()).getType();
                        if (attrEntry.getValue() instanceof JavaAttribute) {
                            nullableDefault = ((JavaAttribute)attrEntry.getValue()).getNullableDefaultWrappedForCode();
                            if (((JavaAttribute)attrEntry.getValue()).isIdentityRef()) {
                                String fieldType = TemplateFactory.serializeType(type, true);
                                String innerType = TemplateFactory.getInnerTypeFromIdentity(type);
                                this.methods.add(new MethodDefinition(fieldType, "resolve" + attrEntry.getKey(), Collections.emptyList(), "return " + varName + ".resolveIdentity(" + dependencyResolverVarName + "," + innerType + ".class);"));
                                type = identityRefType;
                            }
                        }
                        fullyQualifiedName = TemplateFactory.serializeType(type);
                    } else {
                        fullyQualifiedName = FullyQualifiedNameHelper.getFullyQualifiedName((String)packageName, (String)attrEntry.getValue().getUpperCaseCammelCase());
                    }
                    this.fields.add(new Field(fullyQualifiedName, varName, nullableDefault, TemplateFactory.needsDepResolver(attrEntry.getValue())));
                    String getterName = "get" + innerName;
                    MethodDefinition getter = new MethodDefinition(fullyQualifiedName, getterName, Collections.emptyList(), "return " + varName + ";");
                    String setterName = "set" + innerName;
                    MethodDefinition setter = new MethodDefinition("void", setterName, Lists.newArrayList((Object[])new Field[]{new Field(fullyQualifiedName, varName)}), "this." + varName + " = " + varName + ";");
                    this.methods.add(getter);
                    this.methods.add(setter);
                }
            }

            String getType() {
                return this.fullyQualifiedName;
            }

            String getName() {
                return this.name;
            }

            List<Field> getFields() {
                return this.fields;
            }

            List<MethodDefinition> getMethods() {
                return this.methods;
            }
        }
    }
}

