/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.DependencyResolverFactory;
import org.opendaylight.controller.config.api.DynamicMBeanWithInstance;
import org.opendaylight.controller.config.api.annotations.Description;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.api.annotations.ServiceInterfaceAnnotation;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.opendaylight.controller.config.yangjmxgenerator.ServiceInterfaceEntryTest;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.AbstractGeneratorTest;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.CodeWriter;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.JMXGenerator;
import org.osgi.framework.BundleContext;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JMXGeneratorTest
extends AbstractGeneratorTest {
    JMXGenerator jmxGenerator;
    protected final HashMap<String, String> map = Maps.newHashMap();
    protected File outputBaseDir;
    File generatedResourcesDir;
    private static final List<String> expectedModuleFileNames = ServiceInterfaceEntryTest.toFileNames((String)"[AbstractAsyncEventBusModule.java, AbstractAsyncEventBusModuleFactory.java, AbstractDynamicThreadPoolModule.java, AbstractDynamicThreadPoolModuleFactory.java, AbstractEventBusModule.java, AbstractEventBusModuleFactory.java, AbstractNamingThreadFactoryModule.java, AbstractNamingThreadFactoryModuleFactory.java, AbstractThreadPoolRegistryImplModule.java, AbstractThreadPoolRegistryImplModuleFactory.java, AsyncEventBusModule.java, AsyncEventBusModuleFactory.java, AsyncEventBusModuleMXBean.java, AsyncEventBusRuntimeMXBean.java, AsyncEventBusRuntimeRegistration.java, AsyncEventBusRuntimeRegistrator.java, DynamicThreadPoolModule.java, DynamicThreadPoolModuleFactory.java, DynamicThreadPoolModuleMXBean.java, DynamicThreadPoolRuntimeMXBean.java, DynamicThreadPoolRuntimeRegistration.java, DynamicThreadPoolRuntimeRegistrator.java, EventBusModule.java, EventBusModuleFactory.java, EventBusModuleMXBean.java, EventRuntimeMXBean.java, EventRuntimeRegistration.java, FromGrouping.java, InnerStreamList.java, NamingThreadFactoryModule.java, NamingThreadFactoryModuleFactory.java, NamingThreadFactoryModuleMXBean.java, NamingThreadFactoryRuntimeMXBean.java, NamingThreadFactoryRuntimeRegistration.java, NamingThreadFactoryRuntimeRegistrator.java, Peer.java, StreamRuntimeMXBean.java, StreamRuntimeRegistration.java, ThreadPoolRegistryImplModule.java, ThreadPoolRegistryImplModuleFactory.java, ThreadPoolRegistryImplModuleMXBean.java, ThreadRuntimeMXBean.java, ThreadRuntimeRegistration.java, ThreadStreamRuntimeMXBean.java, ThreadStreamRuntimeRegistration.java]");
    private static final List<String> expectedBGPNames = ServiceInterfaceEntryTest.toFileNames((String)"[AbstractBgpListenerImplModule.java, AbstractBgpListenerImplModuleFactory.java, BgpListenerImplModule.java, BgpListenerImplModuleFactory.java, BgpListenerImplModuleMXBean.java, Peers.java]");
    private static final List<String> expectedNetconfNames = ServiceInterfaceEntryTest.toFileNames((String)"[AbstractNetconfTestImplModule.java, AbstractNetconfTestImplModuleFactory.java, AbstractTestImplModule.java, AbstractTestImplModuleFactory.java, AutoCloseableServiceInterface.java, ComplexDtoBInner.java, ComplexList.java, Deep.java, DtoA.java, DtoA1.java, DtoAInner.java, DtoAInnerInner.java, DtoB.java, DtoC.java,NetconfTestImplModule.java, NetconfTestImplModuleFactory.java,NetconfTestImplModuleMXBean.java, Peer.java, SimpleList.java, TestImplModule.java, TestImplModuleFactory.java, TestImplModuleMXBean.java]");
    private static final List<String> expectedTestFiles = ServiceInterfaceEntryTest.toFileNames((String)"[AbstractNetconfTestFileImplModule.java, AbstractNetconfTestFileImplModuleFactory.java, AbstractNetconfTestFiles1ImplModule.java, AbstractNetconfTestFiles1ImplModuleFactory.java, AbstractTestFileImplModule.java, AbstractTestFileImplModuleFactory.java, AbstractTestFiles1ImplModule.java, AbstractTestFiles1ImplModuleFactory.java, DtoA.java, DtoA.java, NetconfTestFileImplModuleMXBean.java, NetconfTestFileImplRuntimeMXBean.java, NetconfTestFileImplRuntimeRegistration.java, NetconfTestFileImplRuntimeRegistrator.java, NetconfTestFiles1ImplModule.java, NetconfTestFiles1ImplModuleFactory.java, NetconfTestFiles1ImplModuleMXBean.java, NetconfTestFiles1ImplRuntimeMXBean.java, NetconfTestFiles1ImplRuntimeRegistration.java, NetconfTestFiles1ImplRuntimeRegistrator.java, TestFileImplModule.java, TestFileImplModuleFactory.java, TestFileImplModuleMXBean.java, TestFileImplRuntimeMXBean.java, TestFileImplRuntimeRegistration.java, TestFileImplRuntimeRegistrator.java, TestFiles1ImplModule.java, TestFiles1ImplModuleFactory.java, TestFiles1ImplModuleMXBean.java, TestFiles1ImplRuntimeMXBean.java, TestFiles1ImplRuntimeRegistration.java, TestFiles1ImplRuntimeRegistrator.java]");
    private static final List<String> expectedAllFileNames = ServiceInterfaceEntryTest.toFileNames((String)"[AbstractAsyncEventBusModule.java, AbstractAsyncEventBusModuleFactory.java, AbstractBgpListenerImplModule.java, AbstractBgpListenerImplModuleFactory.java, AbstractDynamicThreadPoolModule.java, AbstractDynamicThreadPoolModuleFactory.java, AbstractEventBusModule.java, AbstractEventBusModuleFactory.java, AbstractNamingThreadFactoryModule.java, AbstractNamingThreadFactoryModuleFactory.java, AbstractNetconfTestFileImplModule.java, AbstractNetconfTestFileImplModuleFactory.java, AbstractNetconfTestFiles1ImplModule.java, AbstractNetconfTestFiles1ImplModuleFactory.java, AbstractNetconfTestImplModule.java, AbstractNetconfTestImplModuleFactory.java, AbstractTestFileImplModule.java, AbstractTestFileImplModuleFactory.java, AbstractTestFiles1ImplModule.java, AbstractTestFiles1ImplModuleFactory.java, AbstractTestImplModule.java, AbstractTestImplModuleFactory.java, AbstractThreadPoolRegistryImplModule.java, AbstractThreadPoolRegistryImplModuleFactory.java, AsyncEventBusModule.java, AsyncEventBusModuleFactory.java, AsyncEventBusModuleMXBean.java, AsyncEventBusRuntimeMXBean.java, AsyncEventBusRuntimeRegistration.java, AsyncEventBusRuntimeRegistrator.java, AutoCloseableServiceInterface.java, BgpListenerImplModule.java, BgpListenerImplModuleFactory.java, BgpListenerImplModuleMXBean.java, BgpListenerImplRuntimeMXBean.java, BgpListenerImplRuntimeRegistration.java, BgpListenerImplRuntimeRegistrator.java, ComplexDtoBInner.java, ComplexList.java, Deep.java, DtoA.java, DtoA.java, DtoA.java, DtoA1.java, DtoAInner.java, DtoAInnerInner.java, DtoB.java, DtoC.java, DynamicThreadPoolModule.java, DynamicThreadPoolModuleFactory.java, DynamicThreadPoolModuleMXBean.java, DynamicThreadPoolRuntimeMXBean.java, DynamicThreadPoolRuntimeRegistration.java, DynamicThreadPoolRuntimeRegistrator.java, EventBusModule.java, EventBusModuleFactory.java, EventBusModuleMXBean.java, EventBusServiceInterface.java, EventRuntimeMXBean.java, EventRuntimeRegistration.java, FromGrouping.java, InnerStreamList.java, NamingThreadFactoryModule.java, NamingThreadFactoryModuleFactory.java, NamingThreadFactoryModuleMXBean.java, NamingThreadFactoryRuntimeMXBean.java, NamingThreadFactoryRuntimeRegistration.java, NamingThreadFactoryRuntimeRegistrator.java, NetconfTestFileImplModule.java, NetconfTestFileImplModuleFactory.java, NetconfTestFileImplModuleMXBean.java, NetconfTestFileImplRuntimeMXBean.java, NetconfTestFileImplRuntimeRegistration.java, NetconfTestFileImplRuntimeRegistrator.java, NetconfTestFiles1ImplModule.java, NetconfTestFiles1ImplModuleFactory.java, NetconfTestFiles1ImplModuleMXBean.java, NetconfTestFiles1ImplRuntimeMXBean.java, NetconfTestFiles1ImplRuntimeRegistration.java, NetconfTestFiles1ImplRuntimeRegistrator.java, NetconfTestImplModule.java, NetconfTestImplModuleFactory.java, NetconfTestImplModuleMXBean.java, NetconfTestImplRuntimeMXBean.java, NetconfTestImplRuntimeRegistration.java, NetconfTestImplRuntimeRegistrator.java, Peer.java, Peer.java, PeersRuntimeMXBean.java, PeersRuntimeRegistration.java, ScheduledThreadPoolServiceInterface.java, SimpleList.java, StreamRuntimeMXBean.java, StreamRuntimeRegistration.java, TestFileImplModule.java, TestFileImplModuleFactory.java, TestFileImplModuleMXBean.java, TestFileImplRuntimeMXBean.java, TestFileImplRuntimeRegistration.java, TestFileImplRuntimeRegistrator.java, TestFiles1ImplModule.java, TestFiles1ImplModuleFactory.java, TestFiles1ImplModuleMXBean.java, TestFiles1ImplRuntimeMXBean.java, TestFiles1ImplRuntimeRegistration.java, TestFiles1ImplRuntimeRegistrator.java, TestImplModule.java, TestImplModuleFactory.java, TestImplModuleMXBean.java, TestImplRuntimeMXBean.java, TestImplRuntimeRegistration.java, TestImplRuntimeRegistrator.java, ThreadFactoryServiceInterface.java, ThreadPoolRegistryImplModule.java, ThreadPoolRegistryImplModuleFactory.java, ThreadPoolRegistryImplModuleMXBean.java, ThreadPoolServiceInterface.java, ThreadRuntimeMXBean.java, ThreadRuntimeRegistration.java, ThreadStreamRuntimeMXBean.java, ThreadStreamRuntimeRegistration.java]");
    private static final List<String> expectedGenerateMBEsListNames = ServiceInterfaceEntryTest.toFileNames((String)"[AbstractBgpListenerImplModule.java, AbstractBgpListenerImplModuleFactory.java, BgpListenerImplModule.java, BgpListenerImplModuleFactory.java, BgpListenerImplModuleMXBean.java, BgpListenerImplRuntimeMXBean.java, BgpListenerImplRuntimeRegistration.java, BgpListenerImplRuntimeRegistrator.java, PeersRuntimeMXBean.java, PeersRuntimeRegistration.java]");

    @Before
    public void setUp() {
        this.map.put("namespaceToPackage1", "urn:opendaylight:params:xml:ns:yang:controller:config==org.opendaylight.controller.config");
        this.map.put("moduleFactoryFile", "false");
        this.jmxGenerator = new JMXGenerator(new CodeWriter());
        this.jmxGenerator.setAdditionalConfig(this.map);
        File targetDir = new File(this.generatorOutputPath, "target");
        this.generatedResourcesDir = new File(targetDir, "generated-resources");
        this.jmxGenerator.setResourceBaseDir(this.generatedResourcesDir);
        Log mockedLog = (Log)Mockito.mock(Log.class);
        ((Log)Mockito.doReturn((Object)false).when((Object)mockedLog)).isDebugEnabled();
        ((Log)Mockito.doNothing().when((Object)mockedLog)).debug((CharSequence)Matchers.any(CharSequence.class));
        ((Log)Mockito.doNothing().when((Object)mockedLog)).info((CharSequence)Matchers.any(CharSequence.class));
        ((Log)Mockito.doNothing().when((Object)mockedLog)).error((CharSequence)Matchers.any(CharSequence.class), (Throwable)Matchers.any(Throwable.class));
        this.jmxGenerator.setLog(mockedLog);
        MavenProject project = (MavenProject)Mockito.mock(MavenProject.class);
        ((MavenProject)Mockito.doReturn((Object)this.generatorOutputPath).when((Object)project)).getBasedir();
        this.jmxGenerator.setMavenProject(project);
        this.outputBaseDir = JMXGenerator.concatFolders((File)targetDir, (String[])new String[]{"generated-sources", "config"});
    }

    @Test
    public void generateSIsMBsTest() {
        Collection files = this.jmxGenerator.generateSources(this.context, this.outputBaseDir, this.context.getModules());
        ArrayList<String> expectedFileNames = new ArrayList<String>();
        expectedFileNames.addAll(ServiceInterfaceEntryTest.expectedSIEFileNames);
        expectedFileNames.addAll(expectedModuleFileNames);
        expectedFileNames.addAll(expectedBGPNames);
        expectedFileNames.addAll(expectedNetconfNames);
        expectedFileNames.addAll(expectedTestFiles);
        Collections.sort(expectedFileNames);
        Assert.assertEquals(expectedAllFileNames, JMXGeneratorTest.toFileNames(files));
        this.verifyModuleFactoryFile(false);
    }

    private void verifyModuleFactoryFile(boolean shouldBePresent) {
        File factoryFile = new File(this.generatedResourcesDir, "META-INF" + File.separator + "services" + File.separator + ModuleFactory.class.getName());
        if (!shouldBePresent) {
            Assert.assertFalse((String)"Factory file should not be generated", (boolean)factoryFile.exists());
        } else {
            Assert.assertTrue((String)"Factory file should be generated", (boolean)factoryFile.exists());
        }
    }

    public static List<String> toFileNames(Collection<File> files) {
        ArrayList<String> result = new ArrayList<String>();
        for (File f : files) {
            result.add(f.getName());
        }
        Collections.sort(result);
        return result;
    }

    @Test
    public void generateSIEsTest() throws IOException {
        Collection files = this.jmxGenerator.generateSources(this.context, this.outputBaseDir, (Set)Sets.newHashSet((Object[])new org.opendaylight.yangtools.yang.model.api.Module[]{this.threadsModule}));
        Assert.assertEquals((Object)ServiceInterfaceEntryTest.expectedSIEFileNames, JMXGeneratorTest.toFileNames(files));
        HashMap verifiers = Maps.newHashMap();
        for (File file : files) {
            verifiers.put(file.getName(), new SieASTVisitor());
        }
        this.processGeneratedCode(files, verifiers);
        for (File file : files) {
            String fileName = file.getName();
            SieASTVisitor verifier = (SieASTVisitor)((Object)verifiers.get(fileName));
            Assert.assertEquals((Object)fileName.substring(0, fileName.length() - 5), (Object)verifier.type);
            Assert.assertThat((Object)verifier.extnds, (Matcher)JUnitMatchers.containsString((String)"org.opendaylight.controller.config.api.annotations.AbstractServiceInterface"));
            Assert.assertEquals((Object)"org.opendaylight.controller.config.threads", (Object)verifier.packageName);
            Assert.assertNotNull((Object)verifier.javadoc);
            if ("ThreadPoolServiceInterface.java".equals(fileName)) {
                this.assertContains(verifier.descriptionAnotValue, "A simple pool of threads able to execute work.");
                this.assertContains(verifier.sieAnnotValue, "threadpool");
                this.assertContains(verifier.sieAnnotOsgiRegistrationType, "org.opendaylight.controller.config.threadpool.ThreadPool.class");
                continue;
            }
            if ("ScheduledThreadPoolServiceInterface.java".equals(fileName)) {
                this.assertContains(verifier.extnds, "org.opendaylight.controller.config.threads.ThreadPoolServiceInterface");
                this.assertContains(verifier.descriptionAnotValue, "An extension of the simple pool of threads able to schedule work to be executed at some point in time.");
                this.assertContains(verifier.sieAnnotValue, "scheduled-threadpool");
                this.assertContains(verifier.sieAnnotOsgiRegistrationType, "org.opendaylight.controller.config.threadpool.ScheduledThreadPool.class");
                continue;
            }
            if ("EventBusServiceInterface.java".equals(fileName)) {
                this.assertContains(verifier.descriptionAnotValue, "Service representing an event bus. The service acts as message router between event producers and event consumers");
                this.assertContains(verifier.sieAnnotValue, "eventbus");
                this.assertContains(verifier.sieAnnotOsgiRegistrationType, "com.google.common.eventbus.EventBus.class");
                continue;
            }
            if ("ThreadFactoryServiceInterface.java".equals(fileName)) {
                this.assertContains(verifier.descriptionAnotValue, "Service representing a ThreadFactory instance. It is directly useful in Java world, where various library pieces need to create threads and you may want to inject a customized thread implementation.");
                this.assertContains(verifier.sieAnnotValue, "threadfactory");
                this.assertContains(verifier.sieAnnotOsgiRegistrationType, "java.util.concurrent.ThreadFactory.class");
                continue;
            }
            if ("ScheduledExecutorServiceServiceInterface.java".equals(fileName)) {
                this.assertContains(verifier.sieAnnotOsgiRegistrationType, "java.util.concurrent.ScheduledExecutorService.class");
                continue;
            }
            Assert.fail((String)("Unknown generated sie " + fileName));
        }
    }

    @Test
    public void generateMBEsListTest() throws Exception {
        this.map.put("moduleFactoryFile", "randomValue");
        this.jmxGenerator.setAdditionalConfig(this.map);
        Collection files = this.jmxGenerator.generateSources(this.context, this.outputBaseDir, (Set)Sets.newHashSet((Object[])new org.opendaylight.yangtools.yang.model.api.Module[]{this.bgpListenerJavaModule}));
        Assert.assertEquals(expectedGenerateMBEsListNames, JMXGeneratorTest.toFileNames(files));
    }

    @Test
    public void generateMBEsTest() throws Exception {
        this.map.put("moduleFactoryFile", "randomValue");
        this.jmxGenerator.setAdditionalConfig(this.map);
        Collection files = this.jmxGenerator.generateSources(this.context, this.outputBaseDir, (Set)Sets.newHashSet((Object[])new org.opendaylight.yangtools.yang.model.api.Module[]{this.threadsJavaModule}));
        Assert.assertEquals(expectedModuleFileNames, JMXGeneratorTest.toFileNames(files));
        HashMap verifiers = Maps.newHashMap();
        Collection xmlFiles = Collections2.filter((Collection)files, (Predicate)new Predicate<File>(){

            public boolean apply(File input) {
                return input.getName().endsWith("xml");
            }
        });
        Collection javaFiles = Collections2.filter((Collection)files, (Predicate)new Predicate<File>(){

            public boolean apply(File input) {
                return input.getName().endsWith("java");
            }
        });
        MbeASTVisitor abstractDynamicThreadPoolModuleVisitor = null;
        MbeASTVisitor asyncEventBusModuleMXBeanVisitor = null;
        MbeASTVisitor abstractNamingThreadFactoryModuleFactoryVisitor = null;
        MbeASTVisitor asyncEventBusModuleVisitor = null;
        MbeASTVisitor eventBusModuleFactoryVisitor = null;
        for (File file : javaFiles) {
            String name = file.getName();
            MbeASTVisitor visitor = new MbeASTVisitor();
            verifiers.put(name, visitor);
            if (name.equals("AbstractDynamicThreadPoolModule.java")) {
                abstractDynamicThreadPoolModuleVisitor = visitor;
            }
            if (name.equals("AsyncEventBusModuleMXBean.java")) {
                asyncEventBusModuleMXBeanVisitor = visitor;
            }
            if (name.equals("AbstractNamingThreadFactoryModuleFactory.java")) {
                abstractNamingThreadFactoryModuleFactoryVisitor = visitor;
            }
            if (name.equals("AsyncEventBusModule.java")) {
                asyncEventBusModuleVisitor = visitor;
            }
            if (!name.equals("EventBusModuleFactory.java")) continue;
            eventBusModuleFactoryVisitor = visitor;
        }
        this.processGeneratedCode(javaFiles, verifiers);
        this.assertAbstractDynamicThreadPoolModule(abstractDynamicThreadPoolModuleVisitor);
        this.assertAsyncEventBusModuleMXBean(asyncEventBusModuleMXBeanVisitor);
        this.assertAbstractNamingThreadFactoryModuleFactory(abstractNamingThreadFactoryModuleFactoryVisitor);
        this.assertAsyncEventBusModule(asyncEventBusModuleVisitor);
        this.assertEventBusModuleFactory(eventBusModuleFactoryVisitor);
        this.verifyXmlFiles(xmlFiles);
        File moduleFactoryFile = JMXGenerator.concatFolders((File)this.generatedResourcesDir, (String[])new String[]{"META-INF", "services", ModuleFactory.class.getName()});
        Assert.assertThat((Object)moduleFactoryFile.exists(), (Matcher)CoreMatchers.is((Object)true));
        HashSet lines = Sets.newHashSet((Iterable)FileUtils.readLines((File)moduleFactoryFile));
        HashSet expectedLines = Sets.newHashSet((Object[])new String[]{"org.opendaylight.controller.config.threads.java.EventBusModuleFactory", "org.opendaylight.controller.config.threads.java.AsyncEventBusModuleFactory", "org.opendaylight.controller.config.threads.java.DynamicThreadPoolModuleFactory", "org.opendaylight.controller.config.threads.java.NamingThreadFactoryModuleFactory", "org.opendaylight.controller.config.threads.java.ThreadPoolRegistryImplModuleFactory"});
        Assert.assertThat((Object)lines, (Matcher)CoreMatchers.equalTo((Object)expectedLines));
    }

    private void verifyXmlFiles(Collection<File> xmlFiles) throws Exception {
        ErrorHandler errorHandler = new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                Assert.fail((String)("Generated blueprint xml is not well formed " + exception.getMessage()));
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                Assert.fail((String)("Generated blueprint xml is not well formed " + exception.getMessage()));
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                Assert.fail((String)("Generated blueprint xml is not well formed " + exception.getMessage()));
            }
        };
        for (File file : xmlFiles) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(errorHandler);
            builder.parse(new InputSource(file.getPath()));
        }
    }

    private void assertEventBusModuleFactory(MbeASTVisitor visitor) {
        Assert.assertEquals((Object)"org.opendaylight.controller.config.threads.java", (Object)visitor.packageName);
        Assert.assertEquals((Object)"EventBusModuleFactory", (Object)visitor.type);
        this.assertContains(visitor.extnds, "org.opendaylight.controller.config.threads.java.AbstractEventBusModuleFactory");
        Assert.assertEquals((long)0L, (long)visitor.fieldDeclarations.size());
        Assert.assertEquals((String)"Incorrenct number of generated methods", (long)0L, (long)visitor.methods.size());
        Assert.assertEquals((String)"Incorrenct number of generated constructors", (long)0L, (long)visitor.constructors.size());
        Assert.assertEquals((String)"Incorrenct number of generated method descriptions", (long)0L, (long)visitor.methodDescriptions.size());
        Assert.assertEquals((String)"Incorrenct number of generated method javadoc", (long)0L, (long)visitor.methodJavadoc.size());
    }

    private void assertAsyncEventBusModule(MbeASTVisitor visitor) {
        Assert.assertEquals((Object)"org.opendaylight.controller.config.threads.java", (Object)visitor.packageName);
        Assert.assertEquals((Object)"AsyncEventBusModule", (Object)visitor.type);
        this.assertContains(visitor.extnds, "org.opendaylight.controller.config.threads.java.AbstractAsyncEventBusModule");
        Assert.assertEquals((long)0L, (long)visitor.fieldDeclarations.size());
        Assert.assertEquals((String)"Incorrenct number of generated methods", (long)2L, (long)visitor.methods.size());
        Assert.assertEquals((String)"Incorrenct number of generated constructors", (long)2L, (long)visitor.constructors.size());
        Assert.assertEquals((String)"Incorrenct number of generated method descriptions", (long)0L, (long)visitor.methodDescriptions.size());
        Assert.assertEquals((String)"Incorrenct number of generated method javadoc", (long)0L, (long)visitor.methodJavadoc.size());
    }

    private void assertAbstractNamingThreadFactoryModuleFactory(MbeASTVisitor visitor) {
        Assert.assertEquals((Object)"org.opendaylight.controller.config.threads.java", (Object)visitor.packageName);
        Assert.assertEquals((Object)"AbstractNamingThreadFactoryModuleFactory", (Object)visitor.type);
        this.assertContains(visitor.implmts, "org.opendaylight.controller.config.spi.ModuleFactory");
        Set fieldDeclarations = visitor.fieldDeclarations;
        this.assertDeclaredField(fieldDeclarations, "public static final java.lang.String NAME=\"threadfactory-naming\"");
        this.assertDeclaredField(fieldDeclarations, "private static final java.util.Set<Class<? extends org.opendaylight.controller.config.api.annotations.AbstractServiceInterface>> serviceIfcs");
        Assert.assertEquals((long)2L, (long)fieldDeclarations.size());
        this.assertFactoryMethods(visitor.methods, 9);
        Assert.assertEquals((String)"Incorrenct number of generated method descriptions", (long)0L, (long)visitor.methodDescriptions.size());
        Assert.assertEquals((String)"Incorrenct number of generated method javadoc", (long)0L, (long)visitor.methodJavadoc.size());
    }

    private void assertFactoryMethods(Set<String> methods, int expectedSize) {
        ArrayList args = Lists.newArrayList();
        ArgumentAssertion oldInstanceArg = new ArgumentAssertion(DynamicMBeanWithInstance.class.getCanonicalName(), "old");
        ArgumentAssertion instanceNameArg = new ArgumentAssertion(String.class.getSimpleName(), "instanceName");
        ArgumentAssertion dependencyResolverArg = new ArgumentAssertion(DependencyResolver.class.getCanonicalName(), "dependencyResolver");
        ArgumentAssertion bundleContextArg = new ArgumentAssertion(BundleContext.class.getCanonicalName(), "bundleContext");
        this.assertMethodPresent(methods, new MethodAssertion(String.class.getSimpleName(), "getImplementationName"));
        args.add(instanceNameArg);
        args.add(dependencyResolverArg);
        args.add(bundleContextArg);
        this.assertMethodPresent(methods, new MethodAssertion(Module.class.getCanonicalName(), "createModule", args));
        args.add(2, oldInstanceArg);
        this.assertMethodPresent(methods, new MethodAssertion(Module.class.getCanonicalName(), "createModule", args));
        args.clear();
        args.add(oldInstanceArg);
        this.assertMethodPresent(methods, new MethodAssertion("org.opendaylight.controller.config.threads.java.NamingThreadFactoryModule", "handleChangedClass", args));
        args.clear();
        args.add(instanceNameArg);
        args.add(dependencyResolverArg);
        args.add(bundleContextArg);
        this.assertMethodPresent(methods, new MethodAssertion("org.opendaylight.controller.config.threads.java.NamingThreadFactoryModule", "instantiateModule", args));
        args.add(2, new ArgumentAssertion("org.opendaylight.controller.config.threads.java.NamingThreadFactoryModule", "oldModule"));
        args.add(3, new ArgumentAssertion(AutoCloseable.class.getCanonicalName(), "oldInstance"));
        this.assertMethodPresent(methods, new MethodAssertion("org.opendaylight.controller.config.threads.java.NamingThreadFactoryModule", "instantiateModule", args));
        args.clear();
        args.add(new ArgumentAssertion(DependencyResolverFactory.class.getCanonicalName(), "dependencyResolverFactory"));
        args.add(bundleContextArg);
        this.assertMethodPresent(methods, new MethodAssertion("java.util.Set<org.opendaylight.controller.config.threads.java.NamingThreadFactoryModule>", "getDefaultModules", args));
        args.clear();
        args.add(new ArgumentAssertion("Class<? extends org.opendaylight.controller.config.api.annotations.AbstractServiceInterface>", "serviceInterface"));
        this.assertMethodPresent(methods, new MethodAssertion("boolean", "isModuleImplementingServiceInterface", args));
        Assert.assertEquals((long)methods.size(), (long)expectedSize);
    }

    private void assertMethodPresent(Set<String> methods, MethodAssertion methodAssertion) {
        Assert.assertTrue((String)String.format("Generated methods did not contain %s, generated methods: %s", methodAssertion.toString(), methods), (boolean)methods.contains(methodAssertion.toString()));
    }

    private void assertAsyncEventBusModuleMXBean(MbeASTVisitor visitor) {
        Assert.assertEquals((Object)"org.opendaylight.controller.config.threads.java", (Object)visitor.packageName);
        Assert.assertEquals((Object)"AsyncEventBusModuleMXBean", (Object)visitor.type);
        Assert.assertEquals((String)"Incorrenct number of generated methods", (long)4L, (long)visitor.methods.size());
    }

    private void assertAbstractDynamicThreadPoolModule(MbeASTVisitor visitor) {
        Assert.assertEquals((Object)"org.opendaylight.controller.config.threads.java", (Object)visitor.packageName);
        Assert.assertNotNull((Object)visitor.javadoc);
        this.assertContains(visitor.descriptionAnotValue, "threadpool-dynamic description");
        Assert.assertEquals((Object)"AbstractDynamicThreadPoolModule", (Object)visitor.type);
        this.assertContains(visitor.implmts, "org.opendaylight.controller.config.threads.java.DynamicThreadPoolModuleMXBean", Module.class.getCanonicalName(), "org.opendaylight.controller.config.threads.ScheduledThreadPoolServiceInterface", "org.opendaylight.controller.config.threads.ThreadPoolServiceInterface");
        Assert.assertEquals((long)2L, (long)visitor.constructors.size());
        Set fieldDeclarations = visitor.fieldDeclarations;
        this.assertDeclaredField(fieldDeclarations, "private java.lang.Long maximumSize");
        this.assertDeclaredField(fieldDeclarations, "private javax.management.ObjectName threadfactory");
        this.assertDeclaredField(fieldDeclarations, "private java.util.concurrent.ThreadFactory threadfactoryDependency");
        this.assertDeclaredField(fieldDeclarations, "private java.lang.Long keepAlive=new java.lang.Long(\"10\")");
        this.assertDeclaredField(fieldDeclarations, "private java.lang.Long coreSize");
        this.assertDeclaredField(fieldDeclarations, "private byte[] binary");
        Assert.assertEquals((long)22L, (long)fieldDeclarations.size());
        Assert.assertEquals((long)1L, (long)visitor.requireIfc.size());
        String reqIfc = (String)visitor.requireIfc.get("setThreadfactory");
        Assert.assertNotNull((String)"Missing generated setter for threadfactory", (Object)reqIfc);
        this.assertContains(reqIfc, "org.opendaylight.controller.config.threads.ThreadFactoryServiceInterface");
        Assert.assertEquals((String)"Incorrenct number of generated methods", (long)27L, (long)visitor.methods.size());
        Assert.assertEquals((String)"Incorrenct number of generated method descriptions", (long)3L, (long)visitor.methodDescriptions.size());
        Assert.assertEquals((String)"Incorrenct number of generated method javadoc", (long)3L, (long)visitor.methodJavadoc.size());
        Assert.assertNotNull((String)("Missing javadoc for setMaximumSize method " + visitor.methodJavadoc), visitor.methodJavadoc.get("void setMaximumSize(java.lang.Long maximumSize)"));
    }

    private void assertDeclaredField(Set<String> fieldDeclarations, String declaration) {
        Assert.assertTrue((String)("Missing field " + declaration + ", got: " + fieldDeclarations), (boolean)fieldDeclarations.contains(declaration + ";\n"));
    }

    private void assertContains(String source, String ... contained) {
        for (String string : contained) {
            Assert.assertThat((Object)source, (Matcher)JUnitMatchers.containsString((String)string));
        }
    }

    private void processGeneratedCode(Collection<File> files, Map<String, ASTVisitor> verifiers) throws IOException {
        ASTParser parser = ASTParser.newParser((int)3);
        Hashtable options = JavaCore.getOptions();
        JavaCore.setComplianceOptions((String)"1.7", (Map)options);
        parser.setCompilerOptions((Map)options);
        parser.setKind(8);
        for (File file : files) {
            char[] source = JMXGeneratorTest.readFileAsChars(file);
            parser.setSource(source);
            parser.setResolveBindings(true);
            CompilationUnit cu = (CompilationUnit)parser.createAST(null);
            for (IProblem c : cu.getProblems()) {
                if (c.getID() == 1610613332 || c.getID() == 1610613329 || c.getID() == 1610613328) continue;
                Assert.fail((String)("Error in generated source code " + file + ":" + c.getSourceLineNumber() + " id: " + c.getID() + " message:" + c.toString()));
            }
            ASTVisitor visitor = verifiers.get(file.getName());
            if (visitor == null) {
                Assert.fail((String)("Unknown generated file " + file.getName()));
            }
            cu.accept(visitor);
        }
    }

    public static char[] readFileAsChars(File file) throws IOException {
        List readLines = Files.readLines((File)file, (Charset)Charset.forName("utf-8"));
        char[] retVal = new char[]{};
        for (String string : readLines) {
            char[] line = string.toCharArray();
            int beforeLength = retVal.length;
            retVal = Arrays.copyOf(retVal, retVal.length + line.length + 1);
            System.arraycopy(line, 0, retVal, beforeLength, line.length);
            retVal[retVal.length - 1] = 10;
        }
        return retVal;
    }

    private static class ArgumentAssertion {
        protected final String type;
        protected final String name;

        private ArgumentAssertion(String type, String name) {
            this.type = type;
            this.name = name;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.type).append(' ');
            sb.append(this.name);
            return sb.toString();
        }
    }

    private static class MethodAssertion
    extends ArgumentAssertion {
        private List<ArgumentAssertion> arguments;

        MethodAssertion(String type, String name, List<ArgumentAssertion> arguments) {
            super(type, name);
            this.arguments = arguments;
        }

        MethodAssertion(String type, String name) {
            this(type, name, Collections.emptyList());
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.type).append(' ');
            sb.append(this.name).append('(');
            int i = 0;
            for (ArgumentAssertion argument : this.arguments) {
                sb.append(argument.type).append(' ');
                sb.append(argument.name);
                if (++i == this.arguments.size()) continue;
                sb.append(',');
            }
            sb.append(')');
            return sb.toString();
        }
    }

    private static class MbeASTVisitor
    extends SieASTVisitor {
        private String implmts;
        private final Set<String> fieldDeclarations = Sets.newHashSet();
        private final Set<String> constructors = Sets.newHashSet();
        private final Set<String> methods = new HashSet<String>();
        private final Map<String, String> requireIfc = Maps.newHashMap();
        private final Map<String, String> methodJavadoc = Maps.newHashMap();

        private MbeASTVisitor() {
        }

        @Override
        public boolean visit(NormalAnnotation node) {
            boolean result = super.visit(node);
            if (node.getTypeName().toString().equals(RequireInterface.class.getCanonicalName()) && node.getParent() instanceof MethodDeclaration) {
                String reqVal = node.values().get(0).toString();
                this.requireIfc.put(((MethodDeclaration)node.getParent()).getName().toString(), reqVal);
            }
            return result;
        }

        public boolean visit(FieldDeclaration node) {
            this.fieldDeclarations.add(node.toString());
            return super.visit(node);
        }

        public boolean visit(MethodDeclaration node) {
            if (node.isConstructor()) {
                this.constructors.add(node.toString());
            } else {
                String methodSignature = node.getReturnType2() + " " + node.getName() + "(";
                boolean first = true;
                for (Object o : node.parameters()) {
                    if (first) {
                        first = false;
                    } else {
                        methodSignature = methodSignature + ",";
                    }
                    methodSignature = methodSignature + o.toString();
                }
                methodSignature = methodSignature + ")";
                this.methods.add(methodSignature);
                if (node.getJavadoc() != null) {
                    this.methodJavadoc.put(methodSignature, node.getJavadoc().toString());
                }
            }
            return super.visit(node);
        }

        @Override
        public boolean visit(TypeDeclaration node) {
            boolean visit = super.visit(node);
            List superIfcs = node.superInterfaceTypes();
            this.implmts = superIfcs != null && !superIfcs.isEmpty() ? superIfcs.toString() : null;
            this.extnds = node.getSuperclassType() == null ? null : node.getSuperclassType().toString();
            return visit;
        }
    }

    private static class SieASTVisitor
    extends ASTVisitor {
        protected String packageName;
        protected String descriptionAnotValue;
        protected String sieAnnotValue;
        protected String sieAnnotOsgiRegistrationType;
        protected String type;
        protected String extnds;
        protected String javadoc;
        protected Map<String, String> methodDescriptions = Maps.newHashMap();

        private SieASTVisitor() {
        }

        public boolean visit(PackageDeclaration node) {
            this.packageName = node.getName().toString();
            return super.visit(node);
        }

        public boolean visit(NormalAnnotation node) {
            if (node.getTypeName().toString().equals(Description.class.getCanonicalName())) {
                if (node.getParent() instanceof TypeDeclaration) {
                    this.descriptionAnotValue = node.values().get(0).toString();
                } else if (node.getParent() instanceof MethodDeclaration) {
                    String descr = node.values().get(0).toString();
                    this.methodDescriptions.put(((MethodDeclaration)node.getParent()).getName().toString(), descr);
                }
            } else if (node.getTypeName().toString().equals(ServiceInterfaceAnnotation.class.getCanonicalName())) {
                String text1 = node.values().get(0).toString();
                String text2 = node.values().get(1).toString();
                if (text1.contains("value")) {
                    this.sieAnnotValue = text1;
                    this.sieAnnotOsgiRegistrationType = text2;
                } else {
                    this.sieAnnotValue = text2;
                    this.sieAnnotOsgiRegistrationType = text1;
                }
            }
            return super.visit(node);
        }

        public boolean visit(TypeDeclaration node) {
            this.javadoc = node.getJavadoc() == null ? null : node.getJavadoc().toString();
            this.type = node.getName().toString();
            List superIfcs = node.superInterfaceTypes();
            this.extnds = superIfcs != null && !superIfcs.isEmpty() ? superIfcs.toString() : null;
            return super.visit(node);
        }
    }
}

