/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.java;

import com.google.common.base.Optional;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.FullyQualifiedName;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.GeneratedObject;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.JavaFileInput;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.util.StringUtil;

public class GeneratedObjectBuilder {
    private final JavaFileInput input;

    public GeneratedObjectBuilder(JavaFileInput input) {
        this.input = input;
    }

    public GeneratedObject toGeneratedObject() {
        FullyQualifiedName fqn = this.input.getFQN();
        StringBuilder content = new StringBuilder();
        content.append(GeneratedObjectBuilder.maybeAddComment(this.input.getCopyright()));
        content.append(GeneratedObjectBuilder.maybeAddComment(this.input.getHeader()));
        if (!this.input.getFQN().getPackageName().isEmpty()) {
            content.append("package ");
            content.append(this.input.getFQN().getPackageName());
            content.append(";\n");
        }
        content.append(GeneratedObjectBuilder.maybeAddComment(this.input.getClassJavaDoc(), true));
        for (String classAnnotation : this.input.getClassAnnotations()) {
            content.append(classAnnotation);
            content.append("\n");
        }
        content.append("public ");
        content.append((Object)this.input.getType());
        content.append(" ");
        content.append(this.input.getFQN().getTypeName());
        content.append(StringUtil.prefixAndJoin(this.input.getExtends(), "extends"));
        content.append(StringUtil.prefixAndJoin(this.input.getImplements(), "implements"));
        content.append(" {\n");
        for (String method : this.input.getBodyElements()) {
            content.append(method);
            content.append("\n");
        }
        content.append("\n}\n");
        return new GeneratedObject(fqn, content.toString());
    }

    private static String maybeAddComment(Optional<String> comment) {
        return GeneratedObjectBuilder.maybeAddComment(comment, false);
    }

    private static String maybeAddComment(Optional<String> comment, boolean isJavadoc) {
        if (comment.isPresent()) {
            String input = (String)comment.get();
            return StringUtil.writeComment(input, isJavadoc);
        }
        return "";
    }
}

