/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model;

import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Annotation;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Field;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Method;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.MethodDeclaration;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.MethodDefinition;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.util.StringUtil;

class MethodSerializer {
    MethodSerializer() {
    }

    static String toString(Method method) {
        StringBuilder build = new StringBuilder();
        if (method.getJavadoc() != null) {
            build.append(StringUtil.writeComment(method.getJavadoc(), true));
        }
        for (Annotation a : method.getAnnotations()) {
            build.append(a);
        }
        build.append("    public ");
        for (String mod : method.getModifiers()) {
            build.append(mod + " ");
        }
        build.append(method.getReturnType() + " ");
        build.append(method.getName() + "(");
        for (Field param : method.getParameters()) {
            for (String mod : param.getModifiers()) {
                build.append(mod + " ");
            }
            build.append(param.getType() + " ");
            build.append(param.getName() + ", ");
        }
        if (method.getParameters().isEmpty()) {
            build.append(")");
        } else {
            build.deleteCharAt(build.length() - 1);
            build.deleteCharAt(build.length() - 1);
            build.append(')');
        }
        if (method instanceof MethodDeclaration) {
            build.append(";");
            build.append("\n");
        } else if (method instanceof MethodDefinition) {
            if (!((MethodDefinition)method).getThrowsExceptions().isEmpty()) {
                build.append(" throws ");
            }
            for (String ex : ((MethodDefinition)method).getThrowsExceptions()) {
                build.append(ex + " ");
            }
            build.append(" {");
            build.append("\n");
            build.append("        ");
            build.append(((MethodDefinition)method).getBody());
            build.append("\n");
            build.append("    ");
            build.append("}");
            build.append("\n");
        }
        build.append("\n");
        return build.toString();
    }
}

