/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.gofactory;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.DynamicMBeanWithInstance;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.AbstractServiceInterface;
import org.opendaylight.controller.config.api.annotations.Description;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.AbstractFactoryTemplate;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.TemplateFactory;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Annotation;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Field;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.FullyQualifiedName;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.GeneratedObject;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.GeneratedObjectBuilder;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.JavaFileInputBuilder;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.java.TypeName;
import org.opendaylight.yangtools.yang.common.QName;

public class AbsFactoryGeneratedObjectFactory {
    private static final String BUNDLE_CONTEXT = "org.osgi.framework.BundleContext";

    public GeneratedObject toGeneratedObject(ModuleMXBeanEntry mbe, Optional<String> copyright) {
        FullyQualifiedName absFactoryFQN = new FullyQualifiedName(mbe.getPackageName(), mbe.getAbstractFactoryName());
        FullyQualifiedName moduleFQN = new FullyQualifiedName(mbe.getPackageName(), mbe.getStubModuleName());
        Optional classJavaDoc = Optional.fromNullable((Object)mbe.getNullableDescription());
        AbstractFactoryTemplate abstractFactoryTemplate = TemplateFactory.abstractFactoryTemplateFromMbe(mbe);
        Optional<String> header = abstractFactoryTemplate.getHeaderString();
        ArrayList<FullyQualifiedName> providedServices = new ArrayList<FullyQualifiedName>();
        for (String providedService : mbe.getProvidedServices().keySet()) {
            providedServices.add(FullyQualifiedName.fromString(providedService));
        }
        return this.toGeneratedObject(absFactoryFQN, copyright, header, (Optional<String>)classJavaDoc, mbe.getYangModuleQName(), mbe.getGloballyUniqueName(), providedServices, moduleFQN, abstractFactoryTemplate.getFields());
    }

    public GeneratedObject toGeneratedObject(FullyQualifiedName absFactoryFQN, Optional<String> copyright, Optional<String> header, Optional<String> classJavaDoc, QName yangModuleQName, String globallyUniqueName, List<FullyQualifiedName> providedServices, FullyQualifiedName moduleFQN, List<Field> moduleFields) {
        JavaFileInputBuilder b = new JavaFileInputBuilder();
        Annotation moduleQNameAnnotation = Annotation.createModuleQNameANnotation(yangModuleQName);
        b.addClassAnnotation(moduleQNameAnnotation);
        b.setFqn(absFactoryFQN);
        b.setTypeName(TypeName.absClassType);
        b.setCopyright(copyright);
        b.setHeader(header);
        b.setClassJavaDoc(classJavaDoc);
        b.addImplementsFQN(new FullyQualifiedName(ModuleFactory.class));
        if (classJavaDoc.isPresent()) {
            b.addClassAnnotation(String.format("@%s(value=\"%s\")", Description.class.getCanonicalName(), classJavaDoc.get()));
        }
        b.addToBody(String.format("public static final java.lang.String NAME = \"%s\";", globallyUniqueName));
        b.addToBody(String.format("private static final java.util.Set<Class<? extends %s>> serviceIfcs;", AbstractServiceInterface.class.getCanonicalName()));
        b.addToBody("@Override\n public final String getImplementationName() { \n return NAME; \n}");
        b.addToBody(AbsFactoryGeneratedObjectFactory.getServiceIfcsInitialization(providedServices));
        b.addToBody(String.format("\n@Override\npublic %s createModule(String instanceName, %s dependencyResolver, %s bundleContext) {\nreturn instantiateModule(instanceName, dependencyResolver, bundleContext);\n}\n", Module.class.getCanonicalName(), DependencyResolver.class.getCanonicalName(), BUNDLE_CONTEXT));
        b.addToBody(AbsFactoryGeneratedObjectFactory.getCreateModule(moduleFQN, moduleFields));
        b.addToBody(String.format("\npublic %s instantiateModule(String instanceName, %s dependencyResolver, %s oldModule, %s oldInstance, %s bundleContext) {\nreturn new %s(new %s(NAME, instanceName), dependencyResolver, oldModule, oldInstance);\n}\n", moduleFQN, DependencyResolver.class.getCanonicalName(), moduleFQN, AutoCloseable.class.getCanonicalName(), BUNDLE_CONTEXT, moduleFQN, ModuleIdentifier.class.getCanonicalName()));
        b.addToBody(String.format("\npublic %s instantiateModule(String instanceName, %s dependencyResolver, %s bundleContext) {\nreturn new %s(new %s(NAME, instanceName), dependencyResolver);\n}\n", moduleFQN, DependencyResolver.class.getCanonicalName(), BUNDLE_CONTEXT, moduleFQN, ModuleIdentifier.class.getCanonicalName()));
        b.addToBody(String.format("\npublic %s handleChangedClass(%s old) throws Exception {\nthrow new UnsupportedOperationException(\"Class reloading is not supported\");\n}\n", moduleFQN, DynamicMBeanWithInstance.class.getCanonicalName()));
        b.addToBody(String.format("\n@Override\npublic java.util.Set<%s> getDefaultModules(org.opendaylight.controller.config.api.DependencyResolverFactory dependencyResolverFactory, %s bundleContext) {\nreturn new java.util.HashSet<%s>();\n}\n", moduleFQN, BUNDLE_CONTEXT, moduleFQN));
        return new GeneratedObjectBuilder(b.build()).toGeneratedObject();
    }

    private static String getCreateModule(FullyQualifiedName moduleFQN, List<Field> moduleFields) {
        String result = "\n@Override\n" + String.format("public %s createModule(String instanceName, %s dependencyResolver, %s old, %s bundleContext) throws Exception {\n", Module.class.getCanonicalName(), DependencyResolver.class.getCanonicalName(), DynamicMBeanWithInstance.class.getCanonicalName(), BUNDLE_CONTEXT) + String.format("%s oldModule = null;\n", moduleFQN) + "try {\n" + String.format("oldModule = (%s) old.getModule();\n", moduleFQN) + "} catch(Exception e) {\n" + "return handleChangedClass(old);\n" + "}\n" + String.format("%s module = instantiateModule(instanceName, dependencyResolver, oldModule, old.getInstance(), bundleContext);\n", moduleFQN);
        for (Field field : moduleFields) {
            result = result + String.format("module.set%s(oldModule.get%1$s());\n", field.getName());
        }
        result = result + "\nreturn module;\n}\n";
        return result;
    }

    private static String getServiceIfcsInitialization(List<FullyQualifiedName> providedServices) {
        String generic = String.format("Class<? extends %s>", AbstractServiceInterface.class.getCanonicalName());
        String result = String.format("static {\njava.util.Set<%1$s> serviceIfcs2 = new java.util.HashSet<%1$s>();\n", generic);
        for (FullyQualifiedName fqn : providedServices) {
            result = result + String.format("serviceIfcs2.add(%s.class);\n", fqn);
        }
        result = result + "serviceIfcs = java.util.Collections.unmodifiableSet(serviceIfcs2);\n}\n";
        result = result + String.format("\n@Override\npublic final boolean isModuleImplementingServiceInterface(Class<? extends %1$s> serviceInterface) {\nfor (Class<?> ifc: serviceIfcs) {\nif (serviceInterface.isAssignableFrom(ifc)){\nreturn true;\n}\n}\nreturn false;\n}\n\n@Override\npublic java.util.Set<Class<? extends %1$s>> getImplementedServiceIntefaces() {\nreturn serviceIfcs;\n}\n", AbstractServiceInterface.class.getCanonicalName());
        return result;
    }
}

