/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.it.provider;

import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.opendaylight.controller.clustering.it.provider.CarDataTreeChangeListener;
import org.opendaylight.controller.clustering.it.provider.CarEntryDataTreeCommitCohort;
import org.opendaylight.controller.clustering.it.provider.PurchaseCarProvider;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataTreeChangeListener;
import org.opendaylight.controller.md.sal.binding.api.DataTreeIdentifier;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeCommitCohortRegistry;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohort;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohortRegistration;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.eos.binding.api.Entity;
import org.opendaylight.mdsal.eos.binding.api.EntityOwnershipChange;
import org.opendaylight.mdsal.eos.binding.api.EntityOwnershipListener;
import org.opendaylight.mdsal.eos.binding.api.EntityOwnershipService;
import org.opendaylight.mdsal.eos.common.api.CandidateAlreadyRegisteredException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.CarId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.CarService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.Cars;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.CarsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.RegisterCommitCohortInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.RegisterCommitCohortOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.RegisterCommitCohortOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.RegisterLoggingDtclInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.RegisterLoggingDtclOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.RegisterLoggingDtclOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.RegisterOwnershipInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.RegisterOwnershipOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.RegisterOwnershipOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.StopStressTestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.StopStressTestOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.StopStressTestOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.StressTestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.StressTestOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.StressTestOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.UnregisterCommitCohortInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.UnregisterCommitCohortOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.UnregisterCommitCohortOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.UnregisterLoggingDtclsInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.UnregisterLoggingDtclsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.UnregisterLoggingDtclsOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.UnregisterOwnershipInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.UnregisterOwnershipOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.UnregisterOwnershipOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.cars.CarEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.cars.CarEntryBuilder;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"SLF4J_ILLEGAL_PASSED_CLASS"})
public class CarProvider
implements CarService {
    private static final Logger LOG_PURCHASE_CAR = LoggerFactory.getLogger(PurchaseCarProvider.class);
    private static final Logger LOG_CAR_PROVIDER = LoggerFactory.getLogger(CarProvider.class);
    private static final String ENTITY_TYPE = "cars";
    private static final InstanceIdentifier<Cars> CARS_IID = InstanceIdentifier.builder(Cars.class).build();
    private static final DataTreeIdentifier<Cars> CARS_DTID = new DataTreeIdentifier(org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType.CONFIGURATION, CARS_IID);
    private final DataBroker dataProvider;
    private final DOMDataBroker domDataBroker;
    private final EntityOwnershipService ownershipService;
    private final AtomicLong succcessCounter = new AtomicLong();
    private final AtomicLong failureCounter = new AtomicLong();
    private final CarEntityOwnershipListener ownershipListener = new CarEntityOwnershipListener();
    private final AtomicBoolean registeredListener = new AtomicBoolean();
    private final Set<ListenerRegistration<?>> carsDclRegistrations = ConcurrentHashMap.newKeySet();
    private final Set<ListenerRegistration<CarDataTreeChangeListener>> carsDtclRegistrations = ConcurrentHashMap.newKeySet();
    private volatile Thread testThread;
    private volatile boolean stopThread;
    private final AtomicReference<DOMDataTreeCommitCohortRegistration<CarEntryDataTreeCommitCohort>> commitCohortReg = new AtomicReference();

    public CarProvider(DataBroker dataProvider, EntityOwnershipService ownershipService, DOMDataBroker domDataBroker) {
        this.dataProvider = dataProvider;
        this.ownershipService = ownershipService;
        this.domDataBroker = domDataBroker;
    }

    public void close() {
        this.stopThread();
        this.closeCommitCohortRegistration();
    }

    private void stopThread() {
        if (this.testThread != null) {
            this.stopThread = true;
            this.testThread.interrupt();
            try {
                this.testThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.testThread = null;
        }
    }

    public ListenableFuture<RpcResult<StressTestOutput>> stressTest(StressTestInput input) {
        if (input.getRate() == null || input.getRate().toJava() == 0) {
            LOG_PURCHASE_CAR.info("Exiting stress test as no rate is given.");
            return Futures.immediateFuture((Object)RpcResultBuilder.failed().withError(RpcError.ErrorType.PROTOCOL, "invalid rate").build());
        }
        int inputRate = input.getRate().toJava();
        long inputCount = input.getCount() != null ? input.getCount().toJava() : 0L;
        LOG_PURCHASE_CAR.info("Stress test starting : rate: {} count: {}", (Object)inputRate, (Object)inputCount);
        this.stopThread();
        this.succcessCounter.set(0L);
        this.failureCounter.set(0L);
        WriteTransaction tx = this.dataProvider.newWriteOnlyTransaction();
        InstanceIdentifier carsId = InstanceIdentifier.create(Cars.class);
        tx.merge(org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType.CONFIGURATION, carsId, (DataObject)new CarsBuilder().build());
        try {
            tx.submit().checkedGet(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException | TransactionCommitFailedException e) {
            LOG_PURCHASE_CAR.error("Put Cars failed", e);
            return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)new StressTestOutputBuilder().build()).build());
        }
        this.stopThread = false;
        long sleep = TimeUnit.NANOSECONDS.convert(1000L, TimeUnit.MILLISECONDS) / (long)inputRate;
        Stopwatch sw = Stopwatch.createUnstarted();
        this.testThread = new Thread(() -> {
            sw.start();
            AtomicLong count = new AtomicLong();
            while (!this.stopThread) {
                long id = count.incrementAndGet();
                WriteTransaction tx1 = this.dataProvider.newWriteOnlyTransaction();
                CarEntry car = new CarEntryBuilder().setId(new CarId("car" + id)).build();
                tx1.put(org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType.CONFIGURATION, InstanceIdentifier.builder(Cars.class).child(CarEntry.class, (Identifier)car.key()).build(), (DataObject)car);
                Futures.addCallback((ListenableFuture)tx1.submit(), (FutureCallback)new FutureCallback<Void>(){

                    public void onSuccess(Void result) {
                        CarProvider.this.succcessCounter.getAndIncrement();
                    }

                    public void onFailure(Throwable ex) {
                        CarProvider.this.failureCounter.getAndIncrement();
                        LOG_CAR_PROVIDER.error("Put Cars failed", ex);
                    }
                }, (Executor)MoreExecutors.directExecutor());
                try {
                    TimeUnit.NANOSECONDS.sleep(sleep);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (count.get() % 1000L == 0L) {
                    LOG_PURCHASE_CAR.info("Cars created {}, time: {}", (Object)count.get(), (Object)sw.elapsed(TimeUnit.SECONDS));
                }
                if (inputCount == 0L || count.get() < inputCount) continue;
                this.stopThread = true;
            }
            LOG_PURCHASE_CAR.info("Stress test thread stopping after creating {} cars.", (Object)count.get());
        });
        this.testThread.start();
        return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)new StressTestOutputBuilder().build()).build());
    }

    public ListenableFuture<RpcResult<StopStressTestOutput>> stopStressTest(StopStressTestInput input) {
        this.stopThread();
        StopStressTestOutputBuilder stopStressTestOutput = new StopStressTestOutputBuilder().setSuccessCount(Uint32.valueOf((long)this.succcessCounter.longValue())).setFailureCount(Uint32.valueOf((long)this.failureCounter.longValue()));
        StopStressTestOutput result = stopStressTestOutput.build();
        LOG_PURCHASE_CAR.info("Executed Stop Stress test; No. of cars created {}; No. of cars failed {}; ", (Object)this.succcessCounter, (Object)this.failureCounter);
        this.succcessCounter.set(0L);
        this.failureCounter.set(0L);
        return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)result).build());
    }

    public ListenableFuture<RpcResult<RegisterOwnershipOutput>> registerOwnership(RegisterOwnershipInput input) {
        if (this.registeredListener.compareAndSet(false, true)) {
            this.ownershipService.registerListener(ENTITY_TYPE, (EntityOwnershipListener)this.ownershipListener);
        }
        Entity entity = new Entity(ENTITY_TYPE, input.getCarId());
        try {
            this.ownershipService.registerCandidate(entity);
        }
        catch (CandidateAlreadyRegisteredException e) {
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "Could not register for car " + input.getCarId(), (Throwable)e).buildFuture();
        }
        return RpcResultBuilder.success((Object)new RegisterOwnershipOutputBuilder().build()).buildFuture();
    }

    public ListenableFuture<RpcResult<UnregisterOwnershipOutput>> unregisterOwnership(UnregisterOwnershipInput input) {
        return RpcResultBuilder.success((Object)new UnregisterOwnershipOutputBuilder().build()).buildFuture();
    }

    public ListenableFuture<RpcResult<RegisterLoggingDtclOutput>> registerLoggingDtcl(RegisterLoggingDtclInput input) {
        LOG_CAR_PROVIDER.info("Registering a new CarDataTreeChangeListener");
        ListenerRegistration carsDtclRegistration = this.dataProvider.registerDataTreeChangeListener(CARS_DTID, (DataTreeChangeListener)new CarDataTreeChangeListener());
        this.carsDtclRegistrations.add((ListenerRegistration<CarDataTreeChangeListener>)carsDtclRegistration);
        return RpcResultBuilder.success((Object)new RegisterLoggingDtclOutputBuilder().build()).buildFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<RpcResult<UnregisterLoggingDtclsOutput>> unregisterLoggingDtcls(UnregisterLoggingDtclsInput input) {
        LOG_CAR_PROVIDER.info("Unregistering the CarDataTreeChangeListener(s)");
        Set<ListenerRegistration<CarDataTreeChangeListener>> set = this.carsDtclRegistrations;
        synchronized (set) {
            int numListeners = 0;
            for (ListenerRegistration<CarDataTreeChangeListener> carsDtclRegistration : this.carsDtclRegistrations) {
                carsDtclRegistration.close();
                ++numListeners;
            }
            this.carsDtclRegistrations.clear();
            LOG_CAR_PROVIDER.info("Unregistered {} CaraDataTreeChangeListener(s)", (Object)numListeners);
        }
        return RpcResultBuilder.success((Object)new UnregisterLoggingDtclsOutputBuilder().build()).buildFuture();
    }

    public ListenableFuture<RpcResult<UnregisterCommitCohortOutput>> unregisterCommitCohort(UnregisterCommitCohortInput input) {
        this.closeCommitCohortRegistration();
        return RpcResultBuilder.success((Object)new UnregisterCommitCohortOutputBuilder().build()).buildFuture();
    }

    private void closeCommitCohortRegistration() {
        DOMDataTreeCommitCohortRegistration reg = this.commitCohortReg.getAndSet(null);
        if (reg != null) {
            reg.close();
            LOG_CAR_PROVIDER.info("Unregistered commit cohort");
        }
    }

    public synchronized ListenableFuture<RpcResult<RegisterCommitCohortOutput>> registerCommitCohort(RegisterCommitCohortInput input) {
        if (this.commitCohortReg.get() != null) {
            return RpcResultBuilder.success((Object)new RegisterCommitCohortOutputBuilder().build()).buildFuture();
        }
        DOMDataTreeCommitCohortRegistry commitCohortRegistry = (DOMDataTreeCommitCohortRegistry)this.domDataBroker.getSupportedExtensions().get(DOMDataTreeCommitCohortRegistry.class);
        if (commitCohortRegistry == null) {
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "DOMDataTreeCommitCohortRegistry not found").buildFuture();
        }
        YangInstanceIdentifier carEntryPath = YangInstanceIdentifier.builder((YangInstanceIdentifier)YangInstanceIdentifier.of((QName)Cars.QNAME)).node(CarEntry.QNAME).node(CarEntry.QNAME).build();
        this.commitCohortReg.set((DOMDataTreeCommitCohortRegistration<CarEntryDataTreeCommitCohort>)commitCohortRegistry.registerCommitCohort(new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, carEntryPath), (DOMDataTreeCommitCohort)new CarEntryDataTreeCommitCohort()));
        LOG_CAR_PROVIDER.info("Registered commit cohort");
        return RpcResultBuilder.success((Object)new RegisterCommitCohortOutputBuilder().build()).buildFuture();
    }

    private static class CarEntityOwnershipListener
    implements EntityOwnershipListener {
        private CarEntityOwnershipListener() {
        }

        public void ownershipChanged(EntityOwnershipChange ownershipChange) {
            LOG_CAR_PROVIDER.info("ownershipChanged: {}", (Object)ownershipChange);
        }
    }
}

