/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.it.provider;

import java.util.Collection;
import org.opendaylight.controller.md.sal.binding.api.DataObjectModification;
import org.opendaylight.controller.md.sal.binding.api.DataTreeChangeListener;
import org.opendaylight.controller.md.sal.binding.api.DataTreeModification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.Cars;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarDataTreeChangeListener
implements DataTreeChangeListener<Cars> {
    private static final Logger LOG = LoggerFactory.getLogger(CarDataTreeChangeListener.class);

    public void onDataTreeChanged(Collection<DataTreeModification<Cars>> changes) {
        if (LOG.isTraceEnabled()) {
            for (DataTreeModification<Cars> change : changes) {
                CarDataTreeChangeListener.ouputChanges(change);
            }
        }
    }

    private static void ouputChanges(DataTreeModification<Cars> change) {
        DataObjectModification rootNode = change.getRootNode();
        DataObjectModification.ModificationType modificationType = rootNode.getModificationType();
        InstanceIdentifier rootIdentifier = change.getRootPath().getRootIdentifier();
        switch (modificationType) {
            case WRITE: 
            case SUBTREE_MODIFIED: {
                Cars dataBefore = (Cars)rootNode.getDataBefore();
                Cars dataAfter = (Cars)rootNode.getDataAfter();
                LOG.trace("onDataTreeChanged - Cars config with path {} was added or changed from {} to {}", new Object[]{rootIdentifier, dataBefore, dataAfter});
                break;
            }
            case DELETE: {
                LOG.trace("onDataTreeChanged - Cars config with path {} was deleted", (Object)rootIdentifier);
                break;
            }
            default: {
                LOG.trace("onDataTreeChanged called with unknown modificationType: {}", (Object)modificationType);
            }
        }
    }
}

